/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.am;
import com.google.android.gms.internal.cg;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.es;
import com.google.android.gms.internal.ev;
import com.google.android.gms.internal.ew;
import com.google.android.gms.internal.ez;
import com.google.android.gms.internal.fa;
import com.google.android.gms.internal.fb;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.l;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ey
extends WebView
implements DownloadListener {
    private final ez sx;
    private final a sy;
    private final Object lq = new Object();
    private final l py;
    private final ew nE;
    private cg sz;
    private am nD;
    private boolean sA;
    private boolean sB;
    private boolean sC;
    private final WindowManager lA;

    public static ey a(Context context, am am2, boolean bl2, boolean bl3, l l2, ew ew2) {
        a a2 = new a(context);
        return new ey(a2, am2, bl2, bl3, l2, ew2);
    }

    private ey(a a2, am am2, boolean bl2, boolean bl3, l l2, ew ew2) {
        super((Context)a2);
        this.sy = a2;
        this.nD = am2;
        this.sA = bl2;
        this.py = l2;
        this.nE = ew2;
        this.lA = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        ep.a((Context)a2, ew2.st, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            es.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            er.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.sx = Build.VERSION.SDK_INT >= 11 ? new fb(this, bl3) : new ez(this, bl3);
        this.setWebViewClient(this.sx);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new fc(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new fa(this));
        }
        this.cb();
    }

    public void bS() {
        if (!this.bW().ce()) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = this.lA.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        int n2 = ep.m(this.getContext());
        float f2 = 160.0f / (float)displayMetrics.densityDpi;
        int n3 = (int)((float)displayMetrics.widthPixels * f2);
        int n4 = (int)((float)(displayMetrics.heightPixels - n2) * f2);
        try {
            JSONObject jSONObject = new JSONObject().put("width", n3).put("height", n4).put("density", (double)displayMetrics.density).put("rotation", display.getRotation());
            this.b("onScreenInfoChanged", jSONObject);
        }
        catch (JSONException jSONException) {
            ev.b("Error occured while obtaining screen information.", jSONException);
        }
    }

    public void a(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = ep.o(map);
        }
        catch (JSONException jSONException) {
            ev.D("Could not convert parameters to JSON.");
            return;
        }
        this.b(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void E(String string2) {
        Object object = this.lq;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                ev.D("The webview is destroyed. Ignoring action.");
            }
        }
    }

    public void a(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:" + string2 + "(");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        this.E(stringBuilder.toString());
    }

    public void b(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        ev.C("Dispatching AFMA event: " + stringBuilder);
        this.E(stringBuilder.toString());
    }

    public void bT() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.nE.st);
        this.a("onhide", hashMap);
    }

    public void bU() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.nE.st);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public cg bV() {
        Object object = this.lq;
        synchronized (object) {
            return this.sz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public am Q() {
        Object object = this.lq;
        synchronized (object) {
            return this.nD;
        }
    }

    public ez bW() {
        return this.sx;
    }

    public l bX() {
        return this.py;
    }

    public ew bY() {
        return this.nE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bZ() {
        Object object = this.lq;
        synchronized (object) {
            return this.sA;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            ev.z("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.py != null) {
            this.py.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.lq;
        synchronized (object) {
            if (this.isInEditMode() || this.sA) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n6 = Integer.MAX_VALUE;
            if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
                n6 = n3;
            }
            int n7 = Integer.MAX_VALUE;
            if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
                n7 = n5;
            }
            if (this.nD.widthPixels > n6 || this.nD.heightPixels > n7) {
                float f2 = this.sy.getResources().getDisplayMetrics().density;
                ev.D("Not enough space to show ad. Needs " + (int)((float)this.nD.widthPixels / f2) + "x" + (int)((float)this.nD.heightPixels / f2) + " dp, but only has " + (int)((float)n3 / f2) + "x" + (int)((float)n5 / f2) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.nD.widthPixels, this.nD.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, am am2) {
        Object object = this.lq;
        synchronized (object) {
            this.sy.setBaseContext(context);
            this.sz = null;
            this.nD = am2;
            this.sA = false;
            ep.b(this);
            this.loadUrl("about:blank");
            this.sx.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(cg cg2) {
        Object object = this.lq;
        synchronized (object) {
            this.sz = cg2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(am am2) {
        Object object = this.lq;
        synchronized (object) {
            this.nD = am2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void q(boolean bl2) {
        Object object = this.lq;
        synchronized (object) {
            this.sA = bl2;
            this.cb();
        }
    }

    public void setContext(Context context) {
        this.sy.setBaseContext(context);
    }

    public Context ca() {
        return this.sy.ca();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cb() {
        Object object = this.lq;
        synchronized (object) {
            if (this.sA || this.nD.md) {
                if (Build.VERSION.SDK_INT < 14) {
                    ev.z("Disabling hardware acceleration on an overlay.");
                    this.cc();
                } else {
                    ev.z("Enabling hardware acceleration on an overlay.");
                    this.cd();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                ev.z("Disabling hardware acceleration on an AdView.");
                this.cc();
            } else {
                ev.z("Enabling hardware acceleration on an AdView.");
                this.cd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cc() {
        Object object = this.lq;
        synchronized (object) {
            if (!this.sB && Build.VERSION.SDK_INT >= 11) {
                er.d((View)this);
            }
            this.sB = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cd() {
        Object object = this.lq;
        synchronized (object) {
            if (this.sB && Build.VERSION.SDK_INT >= 11) {
                er.e((View)this);
            }
            this.sB = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lq;
        synchronized (object) {
            super.destroy();
            this.sC = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.lq;
        synchronized (object) {
            return this.sC;
        }
    }

    private static class a
    extends MutableContextWrapper {
        private Activity sD;
        private Context lx;

        public a(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.lx = base.getApplicationContext();
            this.sD = base instanceof Activity ? (Activity)base : null;
            super.setBaseContext(this.lx);
        }

        public void startActivity(Intent intent) {
            if (this.sD != null) {
                this.sD.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.lx.startActivity(intent);
            }
        }

        public Context ca() {
            return this.sD;
        }
    }
}

