/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.ji;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String Oy = null;
        private int UX = 0;
        private long UY = Long.MIN_VALUE;
        private short UZ = (short)-1;
        private double Va;
        private double Vb;
        private float Vc;
        private int Vd = 0;
        private int Ve = -1;

        public Builder setRequestId(String requestId) {
            this.Oy = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.UX = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.UY = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.UZ = 1;
            this.Va = latitude;
            this.Vb = longitude;
            this.Vc = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.Vd = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.Ve = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.Oy == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.UX == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.UX & 4) != 0 && this.Ve < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.UY == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.UZ == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.Vd < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new ji(this.Oy, this.UX, 1, this.Va, this.Vb, this.Vc, this.UY, this.Vd, this.Ve);
        }
    }
}

