/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import com.google.android.gms.maps.model.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int xJ;
    private final List<LatLng> aaU;
    private final List<List<LatLng>> aaV;
    private float aar = 10.0f;
    private int aas = -16777216;
    private int aat = 0;
    private float aau = 0.0f;
    private boolean aav = true;
    private boolean aaW = false;

    public PolygonOptions() {
        this.xJ = 1;
        this.aaU = new ArrayList<LatLng>();
        this.aaV = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.xJ = versionCode;
        this.aaU = points;
        this.aaV = holes;
        this.aar = strokeWidth;
        this.aas = strokeColor;
        this.aat = fillColor;
        this.aau = zIndex;
        this.aav = visible;
        this.aaW = geodesic;
    }

    int getVersionCode() {
        return this.xJ;
    }

    List jK() {
        return this.aaV;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.jG()) {
            g.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.aaU.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.aaU.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.aaU.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.aaV.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.aar = width;
        return this;
    }

    public PolygonOptions strokeColor(int color2) {
        this.aas = color2;
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        this.aat = color2;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.aau = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.aav = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.aaW = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.aaU;
    }

    public List<List<LatLng>> getHoles() {
        return this.aaV;
    }

    public float getStrokeWidth() {
        return this.aar;
    }

    public int getStrokeColor() {
        return this.aas;
    }

    public int getFillColor() {
        return this.aat;
    }

    public float getZIndex() {
        return this.aau;
    }

    public boolean isVisible() {
        return this.aav;
    }

    public boolean isGeodesic() {
        return this.aaW;
    }
}

