/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hl;
import com.google.android.gms.wearable.a;

public class Asset
implements SafeParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new a();
    final int xJ;
    private byte[] TC;
    private String ald;
    public ParcelFileDescriptor ale;
    public Uri uri;

    Asset(int versionCode, byte[] data, String digest, ParcelFileDescriptor fd2, Uri uri) {
        this.xJ = versionCode;
        this.TC = data;
        this.ald = digest;
        this.ale = fd2;
        this.uri = uri;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        a.a(this, dest, flags | 1);
    }

    public static Asset createFromRef(String digest) {
        if (digest == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(1, null, digest, null, null);
    }

    public static Asset createFromBytes(byte[] assetData) {
        if (assetData == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(1, assetData, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor fd2) {
        if (fd2 == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(1, null, null, fd2, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(1, null, null, null, uri);
    }

    public byte[] getData() {
        return this.TC;
    }

    public String getDigest() {
        return this.ald;
    }

    public ParcelFileDescriptor getFd() {
        return this.ale;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return hl.hashCode(this.TC, this.ald, this.ale, this.uri);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)o2;
        return hl.equal(this.TC, asset.TC) && hl.equal(this.ald, asset.ald) && hl.equal(this.ale, asset.ale) && hl.equal(this.uri, asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.ald == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.ald);
        }
        if (this.TC != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.TC.length);
        }
        if (this.ale != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.ale);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

