/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.ad;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.ah;
import com.google.android.gms.analytics.ai;
import com.google.android.gms.analytics.am;
import com.google.android.gms.analytics.an;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.k;
import com.google.android.gms.analytics.y;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.ld;
import com.google.android.gms.internal.lf;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker {
    private final TrackerHandler Ce;
    private Context mContext;
    private final Map<String, String> rd = new HashMap<String, String>();
    private final Map<String, String> Cf = new HashMap<String, String>();
    private ah Cg;
    private final k Ch;
    private final ai Ci;
    private final g Cj;
    private boolean Ck;
    private a Cl;
    private am Cm;
    private ExceptionReporter Cn;

    Tracker(String trackingId, TrackerHandler handler, Context context) {
        this(trackingId, handler, k.el(), ai.fl(), g.dZ(), new ad("tracking"), context);
    }

    Tracker(String trackingId, TrackerHandler handler, k clientIdDefaultProvider, ai screenResolutionDefaultProvider, g appFieldsDefaultProvider, ah rateLimiter, Context context) {
        this.Ce = handler;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        if (trackingId != null) {
            this.rd.put("&tid", trackingId);
        }
        this.rd.put("useSecure", "1");
        this.Ch = clientIdDefaultProvider;
        this.Ci = screenResolutionDefaultProvider;
        this.Cj = appFieldsDefaultProvider;
        this.rd.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.Cg = rateLimiter;
        this.Cl = new a();
        this.enableAdvertisingIdCollection(false);
    }

    void a(am am2) {
        String string2;
        ae.V("Loading Tracker config values.");
        this.Cm = am2;
        if (this.Cm.ft()) {
            string2 = this.Cm.fu();
            this.set("&tid", string2);
            ae.V("[Tracker] trackingId loaded: " + string2);
        }
        if (this.Cm.fv()) {
            string2 = Double.toString(this.Cm.fw());
            this.set("&sf", string2);
            ae.V("[Tracker] sample frequency loaded: " + string2);
        }
        if (this.Cm.fx()) {
            this.setSessionTimeout(this.Cm.getSessionTimeout());
            ae.V("[Tracker] session timeout loaded: " + this.fn());
        }
        if (this.Cm.fy()) {
            this.enableAutoActivityTracking(this.Cm.fz());
            ae.V("[Tracker] auto activity tracking loaded: " + this.fo());
        }
        if (this.Cm.fA()) {
            if (this.Cm.fB()) {
                this.set("&aip", "1");
                ae.V("[Tracker] anonymize ip loaded: true");
            }
            ae.V("[Tracker] anonymize ip loaded: false");
        }
        this.enableExceptionReporting(this.Cm.fC());
    }

    public void enableExceptionReporting(boolean enabled) {
        if (this.Ck == enabled) {
            return;
        }
        this.Ck = enabled;
        if (enabled) {
            this.Cn = new ExceptionReporter(this, Thread.getDefaultUncaughtExceptionHandler(), this.mContext);
            Thread.setDefaultUncaughtExceptionHandler(this.Cn);
            ae.V("Uncaught exceptions will be reported to Google Analytics.");
        } else {
            if (this.Cn != null) {
                Thread.setDefaultUncaughtExceptionHandler(this.Cn.et());
            } else {
                Thread.setDefaultUncaughtExceptionHandler(null);
            }
            ae.V("Uncaught exceptions will not be reported to Google Analytics.");
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.Cl.setSessionTimeout(sessionTimeout * 1000L);
    }

    long fn() {
        return this.Cl.fn();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.Cl.enableAutoActivityTracking(enabled);
    }

    boolean fo() {
        return this.Cl.fo();
    }

    public void send(Map<String, String> params) {
        y.eK().a(y.a.Ah);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.rd);
        if (params != null) {
            hashMap.putAll(params);
        }
        Object object = this.Cf.keySet().iterator();
        while (object.hasNext()) {
            String string2 = object.next();
            if (hashMap.containsKey(string2)) continue;
            hashMap.put(string2, this.Cf.get(string2));
        }
        this.Cf.clear();
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            ae.W(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(object = (String)hashMap.get("&t")))) {
            ae.W(String.format("Missing hit type (%s) parameter.", "&t"));
            object = "";
        }
        if (this.Cl.fp()) {
            hashMap.put("&sc", "start");
        }
        if ("screenview".equals(object = ((String)object).toLowerCase()) || "pageview".equals(object) || "appview".equals(object) || TextUtils.isEmpty((CharSequence)object)) {
            int n2 = Integer.parseInt(this.rd.get("&a"));
            n2 = ++n2 >= Integer.MAX_VALUE ? 1 : n2;
            this.rd.put("&a", Integer.toString(n2));
        }
        if (!(((String)object).equals("transaction") || ((String)object).equals("item") || this.Cg.fe())) {
            ae.W("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.Ce.u(hashMap);
        }
    }

    public String get(String key) {
        y.eK().a(y.a.Af);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.rd.containsKey(key)) {
            return this.rd.get(key);
        }
        if (key.equals("&ul")) {
            return an.a(Locale.getDefault());
        }
        if (this.Ch != null && this.Ch.ac(key)) {
            return this.Ch.getValue(key);
        }
        if (this.Ci != null && this.Ci.ac(key)) {
            return this.Ci.getValue(key);
        }
        if (this.Cj != null && this.Cj.ac(key)) {
            return this.Cj.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        jx.b(key, (Object)"Key should be non-null");
        y.eK().a(y.a.Ag);
        this.rd.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toHexString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", an.E(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            ae.W("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", an.E(anonymize));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null) {
            return;
        }
        String string2 = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        Uri uri2 = Uri.parse((String)("http://hostname/?" + string2));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.Cf.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.Cf.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.Cf.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.Cf.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.Cf.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.Cf.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.Cf.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.Cf.put("&gclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.rd.put("&ate", null);
            this.rd.put("&adid", null);
        } else {
            if (this.rd.containsKey("&ate")) {
                this.rd.remove("&ate");
            }
            if (this.rd.containsKey("&adid")) {
                this.rd.remove("&adid");
            }
        }
    }

    private class a
    implements GoogleAnalytics.a {
        private boolean Co = false;
        private int Cp = 0;
        private long Cq = -1L;
        private boolean Cr = false;
        private long Cs;
        private ld wb = lf.if();

        public void setSessionTimeout(long sessionTimeout) {
            this.Cq = sessionTimeout;
            this.fq();
        }

        public long fn() {
            return this.Cq;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.Co = enabled;
            this.fq();
        }

        public boolean fo() {
            return this.Co;
        }

        public boolean fp() {
            boolean bl2 = this.Cr;
            this.Cr = false;
            return bl2;
        }

        private void fq() {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.eY();
            if (googleAnalytics == null) {
                ae.T("GoogleAnalytics isn't initialized for the Tracker!");
                return;
            }
            if (this.Cq >= 0L || this.Co) {
                googleAnalytics.a(Tracker.this.Cl);
            } else {
                googleAnalytics.b(Tracker.this.Cl);
            }
        }

        @Override
        public void i(Activity activity) {
            y.eK().a(y.a.Be);
            if (this.Cp == 0 && this.fr()) {
                this.Cr = true;
            }
            ++this.Cp;
            if (this.Co) {
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                y.eK().D(true);
                Tracker.this.set("&cd", Tracker.this.Cm != null ? Tracker.this.Cm.k(activity) : activity.getClass().getCanonicalName());
                Tracker.this.send(hashMap);
                y.eK().D(false);
            }
        }

        @Override
        public void j(Activity activity) {
            y.eK().a(y.a.Bf);
            --this.Cp;
            this.Cp = Math.max(0, this.Cp);
            if (this.Cp == 0) {
                this.Cs = this.wb.elapsedRealtime();
            }
        }

        boolean fr() {
            return this.wb.elapsedRealtime() >= this.Cs + Math.max(1000L, this.Cq);
        }
    }
}

