/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.jv;

public final class Status
implements Result,
SafeParcelable {
    public static final Status Kw = new Status(0);
    public static final Status Kx = new Status(14);
    public static final Status Ky = new Status(8);
    public static final Status Kz = new Status(15);
    public static final Status KA = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int CK;
    private final int Iv;
    private final String KB;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.CK = versionCode;
        this.Iv = statusCode;
        this.KB = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent gP() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.KB;
    }

    int getVersionCode() {
        return this.CK;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.Iv <= 0;
    }

    public boolean isCanceled() {
        return this.Iv == 16;
    }

    public boolean isInterrupted() {
        return this.Iv == 14;
    }

    public int getStatusCode() {
        return this.Iv;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return jv.hashCode(this.CK, this.Iv, this.KB, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.CK == status.CK && this.Iv == status.Iv && jv.equal(this.KB, status.KB) && jv.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String gt() {
        if (this.KB != null) {
            return this.KB;
        }
        return CommonStatusCodes.getStatusCodeString(this.Iv);
    }

    public String toString() {
        return jv.h(this).a("statusCode", this.gt()).a("resolution", this.mPendingIntent).toString();
    }

    @Deprecated
    public ConnectionResult gQ() {
        return new ConnectionResult(this.Iv, this.mPendingIntent);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

