/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.jx;
import com.google.android.gms.location.ActivityRecognitionResultCreator;
import com.google.android.gms.location.DetectedActivity;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
implements SafeParcelable {
    public static final String EXTRA_ACTIVITY_RESULT = "com.google.android.location.internal.EXTRA_ACTIVITY_RESULT";
    public static final ActivityRecognitionResultCreator CREATOR = new ActivityRecognitionResultCreator();
    private final int CK;
    List<DetectedActivity> afX;
    long afY;
    long afZ;

    public ActivityRecognitionResult(List<DetectedActivity> probableActivities, long time, long elapsedRealtimeMillis) {
        jx.b((probableActivities != null && probableActivities.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 detected activity");
        jx.b((time > 0L && elapsedRealtimeMillis > 0L ? 1 : 0) != 0, (Object)"Must set times");
        this.CK = 1;
        this.afX = probableActivities;
        this.afY = time;
        this.afZ = elapsedRealtimeMillis;
    }

    public ActivityRecognitionResult(DetectedActivity mostProbableActivity, long time, long elapsedRealtimeMillis) {
        this(Collections.singletonList(mostProbableActivity), time, elapsedRealtimeMillis);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra(EXTRA_ACTIVITY_RESULT);
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        Object object = intent.getExtras().get(EXTRA_ACTIVITY_RESULT);
        if (object instanceof byte[]) {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall((byte[])object, 0, ((byte[])object).length);
            parcel.setDataPosition(0);
            return CREATOR.createFromParcel(parcel);
        }
        if (object instanceof ActivityRecognitionResult) {
            return (ActivityRecognitionResult)object;
        }
        return null;
    }

    public DetectedActivity getMostProbableActivity() {
        return this.afX.get(0);
    }

    public int getActivityConfidence(int activityType) {
        for (DetectedActivity detectedActivity : this.afX) {
            if (detectedActivity.getType() != activityType) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.afX;
    }

    public long getTime() {
        return this.afY;
    }

    public long getElapsedRealtimeMillis() {
        return this.afZ;
    }

    public String toString() {
        return "ActivityRecognitionResult [probableActivities=" + this.afX + ", timeMillis=" + this.afY + ", elapsedRealtimeMillis=" + this.afZ + "]";
    }

    public ActivityRecognitionResult(int versionCode, List<DetectedActivity> probableActivities, long timeMillis, long elapsedRealtimeMillis) {
        this.CK = 1;
        this.afX = probableActivities;
        this.afY = timeMillis;
        this.afZ = elapsedRealtimeMillis;
    }

    public int getVersionCode() {
        return this.CK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        ActivityRecognitionResultCreator.a(this, out, flags);
    }
}

