/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.internal.nn;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int tq;
    private final int agl;
    private final List<Geofence> agm;
    private final Location agn;

    private GeofencingEvent(int errorCode, int transitionType, List<Geofence> triggeringGeofences, Location triggeringLocaton) {
        this.tq = errorCode;
        this.agl = transitionType;
        this.agm = triggeringGeofences;
        this.agn = triggeringLocaton;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = GeofencingEvent.k(intent);
        List<Geofence> list = GeofencingEvent.l(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n, n2, list, location);
    }

    private static int k(Intent intent) {
        int n = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n == -1) {
            return -1;
        }
        if (n == 1 || n == 2 || n == 4) {
            return n;
        }
        return -1;
    }

    private static List<Geofence> l(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(nn.h(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.tq != -1;
    }

    public int getErrorCode() {
        return this.tq;
    }

    public int getGeofenceTransition() {
        return this.agl;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.agm;
    }

    public Location getTriggeringLocation() {
        return this.agn;
    }
}

