/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import com.google.android.gms.maps.internal.aa;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.a;
import com.google.android.gms.maps.model.b;

public final class CameraPosition
implements SafeParcelable {
    public static final a CREATOR = new a();
    private final int CK;
    public final LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    CameraPosition(int versionCode, LatLng target, float zoom, float tilt, float bearing) {
        jx.b((Object)target, (Object)"null camera target");
        jx.b((0.0f <= tilt && tilt <= 90.0f ? 1 : 0) != 0, (Object)"Tilt needs to be between 0 and 90 inclusive");
        this.CK = versionCode;
        this.target = target;
        this.zoom = zoom;
        this.tilt = tilt + 0.0f;
        this.bearing = ((double)bearing <= 0.0 ? bearing % 360.0f + 360.0f : bearing) % 360.0f;
    }

    public CameraPosition(LatLng target, float zoom, float tilt, float bearing) {
        this(1, target, zoom, tilt, bearing);
    }

    public void writeToParcel(Parcel out, int flags) {
        if (aa.ob()) {
            b.a(this, out, flags);
        } else {
            a.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.target, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    int getVersionCode() {
        return this.CK;
    }

    public static final CameraPosition fromLatLngZoom(LatLng target, float zoom) {
        return new CameraPosition(target, zoom, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition camera) {
        return new Builder(camera);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)o2;
        return this.target.equals(cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public String toString() {
        return jv.h((Object)this).a("target", (Object)this.target).a("zoom", (Object)Float.valueOf(this.zoom)).a("tilt", (Object)Float.valueOf(this.tilt)).a("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static CameraPosition createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLat)) {
            f2 = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLat, 0.0f);
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLng)) {
            f3 = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLng, 0.0f);
        }
        LatLng latLng = new LatLng(f2, f3);
        Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraZoom)) {
            builder.zoom(typedArray.getFloat(R.styleable.MapAttrs_cameraZoom, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraBearing)) {
            builder.bearing(typedArray.getFloat(R.styleable.MapAttrs_cameraBearing, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTilt)) {
            builder.tilt(typedArray.getFloat(R.styleable.MapAttrs_cameraTilt, 0.0f));
        }
        return builder.build();
    }

    public static final class Builder {
        private LatLng alN;
        private float alO;
        private float alP;
        private float alQ;

        public Builder() {
        }

        public Builder(CameraPosition previous) {
            CameraPosition cameraPosition = previous;
            this.alN = cameraPosition.target;
            this.alO = cameraPosition.zoom;
            this.alP = cameraPosition.tilt;
            this.alQ = cameraPosition.bearing;
        }

        public Builder target(LatLng location) {
            this.alN = location;
            return this;
        }

        public Builder zoom(float zoom) {
            this.alO = zoom;
            return this;
        }

        public Builder tilt(float tilt) {
            this.alP = tilt;
            return this;
        }

        public Builder bearing(float bearing) {
            this.alQ = bearing;
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.alN, this.alO, this.alP, this.alQ);
        }
    }
}

