/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.CornerPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import io.scanbot.common.Result;
import io.scanbot.sdk.barcode.BarcodeItem;
import io.scanbot.sdk.barcode.BarcodeItemKt;
import io.scanbot.sdk.barcode.BarcodeScannerFrameHandler;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.barcode.R;
import io.scanbot.sdk.barcode.ui.BarcodeOverlayTextFormat;
import io.scanbot.sdk.barcode.ui.BarcodePolygonsView;
import io.scanbot.sdk.barcode.ui.lgb;
import io.scanbot.sdk.barcode.ui.lgd;
import io.scanbot.sdk.barcode.ui.lge;
import io.scanbot.sdk.barcode.ui.lgu;
import io.scanbot.sdk.base.R;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.ui.BasePolygonView;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.view.PolygonViewHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 \u00af\u00012\u00020\u00012\u00020\u0002:\u0018\u00b0\u0001\u00b1\u0001\u00b2\u0001\u00b3\u0001\u00af\u0001\u00b4\u0001\u00b5\u0001\u00b6\u0001\u00b7\u0001\u00b8\u0001\u00b9\u0001\u00ba\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ!\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\tJM\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001f\u001a\u00020\n*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010!\u001a\u00020\n*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b!\u0010 J\u001b\u0010\"\u001a\u00020\n*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\"\u0010 J\u001b\u0010#\u001a\u00020\n*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b#\u0010 J\u001f\u0010$\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b$\u0010\tJ\u001d\u0010&\u001a\u00020\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0002\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010*\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b*\u0010+J'\u0010/\u001a\u00020\n2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b/\u00100J%\u00103\u001a\u00020\n2\u0006\u00101\u001a\u00020\u000e2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0002\u00a2\u0006\u0004\b3\u00104J \u00108\u001a\u00020\n2\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0004\b8\u00109J\u0011\u0010;\u001a\u0004\u0018\u00010:H\u0002\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010=\u001a\u00020\n2\u0006\u00106\u001a\u000205H\u0002\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010?\u001a\u00020\n2\u0006\u00106\u001a\u000205H\u0002\u00a2\u0006\u0004\b?\u0010>J\r\u0010@\u001a\u00020\n\u00a2\u0006\u0004\b@\u0010AJ\u000f\u0010B\u001a\u00020\nH\u0014\u00a2\u0006\u0004\bB\u0010AJ\u000f\u0010C\u001a\u00020\nH\u0014\u00a2\u0006\u0004\bC\u0010AJ/\u0010H\u001a\u00020\n2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\bH\u0010IJ\u0019\u0010L\u001a\u00020\u00162\b\u0010K\u001a\u0004\u0018\u00010JH\u0016\u00a2\u0006\u0004\bL\u0010MJ\u0017\u0010P\u001a\u00020\n2\u0006\u0010O\u001a\u00020NH\u0014\u00a2\u0006\u0004\bP\u0010QR\u001c\u0010R\u001a\b\u0012\u0004\u0012\u0002050\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u001c\u0010U\u001a\b\u0012\u0004\u0012\u00020:0T8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u0010SR\"\u0010V\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010W\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\"\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020]0\\8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0016\u0010`\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u0016\u0010c\u001a\u00020b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bc\u0010dR\u0016\u0010f\u001a\u00020e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u0016\u0010\u0011\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010hR\u0016\u0010\u0013\u001a\u00020i8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010jR\u0016\u0010\u0010\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010hR\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010hR\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010WR\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010kR\u0018\u0010m\u001a\u0004\u0018\u00010l8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bm\u0010nR$\u0010p\u001a\u0004\u0018\u00010o8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bp\u0010q\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR\"\u0010w\u001a\u00020v8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bw\u0010x\u001a\u0004\by\u0010z\"\u0004\b{\u0010|R&\u0010~\u001a\u00020}8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0016\n\u0004\b~\u0010\u007f\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001\"\u0006\b\u0082\u0001\u0010\u0083\u0001R,\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0084\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0085\u0001\u0010\u0086\u0001\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R,\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008b\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u008c\u0001\u0010\u008d\u0001\u001a\u0006\b\u008e\u0001\u0010\u008f\u0001\"\u0006\b\u0090\u0001\u0010\u0091\u0001R,\u0010\u0093\u0001\u001a\u0005\u0018\u00010\u0092\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0093\u0001\u0010\u0094\u0001\u001a\u0006\b\u0095\u0001\u0010\u0096\u0001\"\u0006\b\u0097\u0001\u0010\u0098\u0001R,\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u0099\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u009a\u0001\u0010\u009b\u0001\u001a\u0006\b\u009c\u0001\u0010\u009d\u0001\"\u0006\b\u009e\u0001\u0010\u009f\u0001R\u001d\u0010\u00a1\u0001\u001a\u00030\u00a0\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u00a1\u0001\u0010\u00a2\u0001\u001a\u0006\b\u00a3\u0001\u0010\u00a4\u0001R,\u0010\u00a6\u0001\u001a\u0005\u0018\u00010\u00a5\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00a6\u0001\u0010\u00a7\u0001\u001a\u0006\b\u00a8\u0001\u0010\u00a9\u0001\"\u0006\b\u00aa\u0001\u0010\u00ab\u0001R,\u0010\u00ac\u0001\u001a\u0005\u0018\u00010\u00a5\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00ac\u0001\u0010\u00a7\u0001\u001a\u0006\b\u00ad\u0001\u0010\u00a9\u0001\"\u0006\b\u00ae\u0001\u0010\u00ab\u0001\u00a8\u0006\u00bb\u0001"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/BasePolygonView;", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "Landroid/util/AttributeSet;", "attrs", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "", "initView", "Lio/scanbot/sdk/barcode/BarcodeItem;", "barcode", "", "frameHeight", "frameWidth", "orientation", "Landroid/graphics/RectF;", "finderRect", "Lio/scanbot/sdk/camera/CameraModule;", "cameraModule", "", "analyzerFrameMirrored", "", "Landroid/graphics/PointF;", "mapBarcodePolygonToPointsArray", "(Lio/scanbot/sdk/barcode/BarcodeItem;IIILandroid/graphics/RectF;Lio/scanbot/sdk/camera/CameraModule;Z)Ljava/util/List;", "Landroid/graphics/Paint;", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;", "polygonStyle", "highlightedFillPaint", "(Landroid/graphics/Paint;Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;)V", "fillPaint", "strokeHighLightedPaint", "strokePaint", "loadAttributes", "list", "processNewFrame", "(Ljava/util/List;)V", "key", "item", "compareBarcodeItems", "(Lio/scanbot/sdk/barcode/BarcodeItem;Lio/scanbot/sdk/barcode/BarcodeItem;)Z", "drawShadows", "paint", "useFill", "updateShadows", "(ZLandroid/graphics/Paint;Z)V", "frameOrientation", "newBarcodes", "updatePolygons", "(ILjava/util/List;)V", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeElement;", "barcodeElement", "index", "updatePolygon", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeElement;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Landroid/view/View;", "createClickableView", "()Landroid/view/View;", "animateToPolygon", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeElement;)V", "updatePath", "resetPolygonState", "()V", "onAttachedToWindow", "onDetachedFromWindow", "w", "h", "oldw", "oldh", "onSizeChanged", "(IIII)V", "Landroid/view/MotionEvent;", "event", "onTouchEvent", "(Landroid/view/MotionEvent;)Z", "Landroid/graphics/Canvas;", "canvas", "onDraw", "(Landroid/graphics/Canvas;)V", "barcodeElements", "Ljava/util/List;", "", "viewsPool", "processingEnabled", "Z", "getProcessingEnabled", "()Z", "setProcessingEnabled", "(Z)V", "", "", "mapBarcodeValues", "Ljava/util/Map;", "defaultPolygonStyle", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;", "defaultTextViewStyle", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;", "Lio/scanbot/sdk/util/view/PolygonViewHelper;", "polygonHelper", "Lio/scanbot/sdk/util/view/PolygonViewHelper;", "I", "Landroid/graphics/Rect;", "Landroid/graphics/Rect;", "Lio/scanbot/sdk/camera/CameraModule;", "Landroid/animation/ValueAnimator;", "frameAnimator", "Landroid/animation/ValueAnimator;", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$PolygonValueClickListener;", "polygonValueClickListener", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$PolygonValueClickListener;", "getPolygonValueClickListener", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$PolygonValueClickListener;", "setPolygonValueClickListener", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$PolygonValueClickListener;)V", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeStringDelegate;", "stringValueDelegate", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeStringDelegate;", "getStringValueDelegate", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeStringDelegate;", "setStringValueDelegate", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeStringDelegate;)V", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeAppearanceDelegate;", "barcodeAppearanceDelegate", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeAppearanceDelegate;", "getBarcodeAppearanceDelegate", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeAppearanceDelegate;", "setBarcodeAppearanceDelegate", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeAppearanceDelegate;)V", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeHighlightDelegate;", "barcodeHighlightDelegate", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeHighlightDelegate;", "getBarcodeHighlightDelegate", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeHighlightDelegate;", "setBarcodeHighlightDelegate", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeHighlightDelegate;)V", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewFactory;", "barcodeItemViewFactory", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewFactory;", "getBarcodeItemViewFactory", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewFactory;", "setBarcodeItemViewFactory", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewFactory;)V", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewBinder;", "barcodeItemViewBinder", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewBinder;", "getBarcodeItemViewBinder", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewBinder;", "setBarcodeItemViewBinder", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewBinder;)V", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewPositionHandler;", "barcodeItemPositionHandler", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewPositionHandler;", "getBarcodeItemPositionHandler", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewPositionHandler;", "setBarcodeItemPositionHandler", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewPositionHandler;)V", "Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$ResultHandler;", "barcodesResultHandler", "Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$ResultHandler;", "getBarcodesResultHandler", "()Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$ResultHandler;", "Lkotlinx/coroutines/Job;", "cancelJob", "Lkotlinx/coroutines/Job;", "getCancelJob", "()Lkotlinx/coroutines/Job;", "setCancelJob", "(Lkotlinx/coroutines/Job;)V", "appearanceJob", "getAppearanceJob", "setAppearanceJob", "Companion", "BarcodePolygonStyle", "BarcodeTextViewStyle", "BarcodeElement", "io/scanbot/sdk/barcode/ui/lgd", "PolygonValueClickListener", "BarcodeItemViewFactory", "BarcodeItemViewBinder", "BarcodeStringDelegate", "BarcodeItemViewPositionHandler", "BarcodeHighlightDelegate", "BarcodeAppearanceDelegate", "sdk-barcode_release"}, xi=48)
@SourceDebugExtension(value={"SMAP\nBarcodePolygonsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodePolygonsView.kt\nio/scanbot/sdk/barcode/ui/BarcodePolygonsView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Color.kt\nandroidx/core/graphics/ColorKt\n+ 5 Rect.kt\nandroidx/core/graphics/RectKt\n+ 6 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,766:1\n1#2:767\n1573#3:768\n1604#3,4:769\n1869#3,2:823\n1563#3:825\n1634#3,2:826\n295#3,2:828\n1636#3:831\n827#3:832\n855#3,2:833\n295#3,2:835\n1878#3,3:837\n1869#3,2:840\n1869#3,2:843\n1761#3,3:845\n295#3,2:848\n111#4,25:773\n111#4,25:798\n337#5:830\n251#6:842\n*S KotlinDebug\n*F\n+ 1 BarcodePolygonsView.kt\nio/scanbot/sdk/barcode/ui/BarcodePolygonsView\n*L\n287#1:768\n287#1:769,4\n435#1:823,2\n465#1:825\n465#1:826,2\n466#1:828,2\n465#1:831\n483#1:832\n483#1:833,2\n565#1:835,2\n605#1:837,3\n612#1:840,2\n357#1:843,2\n430#1:845,3\n590#1:848,2\n318#1:773,25\n325#1:798,25\n474#1:830\n356#1:842\n*E\n"})
public final class BarcodePolygonsView
extends FrameLayout
implements BasePolygonView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double defaultFillPaintAlpha = 0.2;
    public static final long RETAIN_BARCODE_TIMEOUT_MS = 700L;
    @NotNull
    public static final String TAG = "BarcodePolygonsView";
    @NotNull
    private List<BarcodeElement> barcodeElements;
    @NotNull
    private List<View> viewsPool;
    private boolean processingEnabled;
    @NotNull
    private Map<BarcodeItem, Long> mapBarcodeValues;
    @NotNull
    private BarcodePolygonStyle defaultPolygonStyle;
    @NotNull
    private BarcodeTextViewStyle defaultTextViewStyle;
    @NotNull
    private PolygonViewHelper polygonHelper;
    private int orientation;
    @NotNull
    private Rect finderRect;
    private int frameWidth;
    private int frameHeight;
    private boolean analyzerFrameMirrored;
    @NotNull
    private CameraModule cameraModule;
    @Nullable
    private ValueAnimator frameAnimator;
    @Nullable
    private PolygonValueClickListener polygonValueClickListener;
    @NotNull
    private BarcodeStringDelegate stringValueDelegate;
    @NotNull
    private BarcodeAppearanceDelegate barcodeAppearanceDelegate;
    @Nullable
    private BarcodeHighlightDelegate barcodeHighlightDelegate;
    @Nullable
    private BarcodeItemViewFactory barcodeItemViewFactory;
    @Nullable
    private BarcodeItemViewBinder barcodeItemViewBinder;
    @Nullable
    private BarcodeItemViewPositionHandler barcodeItemPositionHandler;
    @NotNull
    private final BarcodeScannerFrameHandler.ResultHandler barcodesResultHandler;
    @Nullable
    private Job cancelJob;
    @Nullable
    private Job appearanceJob;

    public BarcodePolygonsView(@NotNull Context context) {
        BarcodeOverlayTextFormat barcodeOverlayTextFormat;
        void v0 = barcodeOverlayTextFormat;
        BarcodePolygonsView barcodePolygonsView = this;
        void v2 = barcodeOverlayTextFormat;
        Intrinsics.checkNotNullParameter((Object)v2, (String)"context");
        super((Context)v2);
        barcodePolygonsView.barcodeElements = CollectionsKt.emptyList();
        barcodePolygonsView.viewsPool = new ArrayList<View>();
        barcodePolygonsView.processingEnabled = true;
        barcodePolygonsView.mapBarcodeValues = MapsKt.sortedMapOf((arg_0, arg_1) -> BarcodePolygonsView.mapBarcodeValues$lambda$1(BarcodePolygonsView::mapBarcodeValues$lambda$0, arg_0, arg_1), (Pair[])new Pair[0]);
        barcodePolygonsView.defaultPolygonStyle = new BarcodePolygonStyle(true, true, true, 0.0f, 2.0f, -1, -16777216, -1, -16777216, true);
        barcodeOverlayTextFormat = BarcodeOverlayTextFormat.CODE_AND_TYPE;
        barcodePolygonsView.defaultTextViewStyle = new BarcodeTextViewStyle(-1, -16777216, -16777216, -1, barcodeOverlayTextFormat, true);
        barcodePolygonsView.polygonHelper = new PolygonViewHelper();
        barcodePolygonsView.finderRect = new Rect();
        barcodePolygonsView.cameraModule = CameraModule.BACK;
        barcodePolygonsView.stringValueDelegate = new BarcodeStringDelegate(){

            /*
             * WARNING - void declaration
             */
            public String overrideString(String string, BarcodeItem barcodeItem) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"string");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"barcodeItem");
                return string;
            }
        };
        barcodePolygonsView.barcodeAppearanceDelegate = new BarcodeAppearanceDelegate(){

            /*
             * WARNING - void declaration
             */
            public BarcodePolygonStyle getPolygonStyle(BarcodePolygonStyle defaultStyle, BarcodeItem barcodeItem) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"defaultStyle");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"barcodeItem");
                return defaultStyle;
            }

            /*
             * WARNING - void declaration
             */
            public BarcodeTextViewStyle getTextViewStyle(BarcodeTextViewStyle defaultStyle, BarcodeItem barcodeItem) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"defaultStyle");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"barcodeItem");
                return defaultStyle;
            }
        };
        barcodePolygonsView.barcodeItemViewFactory = new BarcodeItemViewFactory(this){
            final /* synthetic */ BarcodePolygonsView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public View createView() {
                Button button;
                Button button2 = button;
                button2(object.this$0.getContext());
                Object object = object.this$0;
                button.setMaxWidth((int)button.getResources().getDimension(R.dimen.barcode_polygon_text_max_width));
                button.setEllipsize(TextUtils.TruncateAt.END);
                button.setBackgroundTintList(ColorStateList.valueOf((int)BarcodePolygonsView.access$getDefaultTextViewStyle$p((BarcodePolygonsView)((Object)object)).getTextContainerColor()));
                Drawable drawable2 = AppCompatResources.getDrawable((Context)button.getContext(), (int)R.drawable.scanbot_arrow_forward_widget);
                if (drawable2 != null) {
                    drawable2.setTint(BarcodePolygonsView.access$getDefaultTextViewStyle$p((BarcodePolygonsView)((Object)object)).getTextColor());
                }
                Button button3 = button2;
                button2.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
                button3.setTextColor(BarcodePolygonsView.access$getDefaultTextViewStyle$p((BarcodePolygonsView)((Object)object)).getTextColor());
                return button3;
            }
        };
        barcodePolygonsView.barcodeItemViewBinder = new BarcodeItemViewBinder(this){
            final /* synthetic */ BarcodePolygonsView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            private final String formattedBarcodeName(BarcodeItem barcodeItem) {
                void var1_1;
                return StringsKt.replace$default((String)barcodeItem.getFormat().name(), (String)"_", (String)" ", (boolean)false, (int)4, null) + "\n" + BarcodeItemKt.getTextWithExtension((BarcodeItem)var1_1);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void bindViewLocal(BarcodeElement barcodeElement) {
                void var1_2;
                BarcodeElement barcodeElement2 = barcodeElement;
                Intrinsics.checkNotNullParameter((Object)barcodeElement2, (String)"barcodeElement");
                View view = barcodeElement2.getView();
                if (view == null) return;
                Drawable[] drawableArray = this.this$0;
                BarcodeTextViewStyle barcodeTextViewStyle = var1_2.getTextStyle();
                if (!(view instanceof Button)) return;
                view = (Button)view;
                float f = barcodeTextViewStyle.getShouldDrawShadows() ? 10.0f : 0.0f;
                view.setElevation(f);
                int n = barcodeTextViewStyle.getTextFormat() == BarcodeOverlayTextFormat.NONE ? 8 : 0;
                view.setVisibility(n);
                n = barcodeTextViewStyle.getTextFormat() == BarcodeOverlayTextFormat.CODE ? 1 : 2;
                view.setMaxLines(n);
                n = barcodeItemViewBinder.WhenMappings.$EnumSwitchMapping$0[barcodeTextViewStyle.getTextFormat().ordinal()];
                if (n != 1) {
                    if (n != 2) {
                        if (n != 3) throw new NoWhenBranchMatchedException();
                        this = super.formattedBarcodeName(var1_2.getBarcodeItem());
                        this = drawableArray.getStringValueDelegate().overrideString((String)this, var1_2.getBarcodeItem());
                    } else {
                        void v1 = var1_2;
                        this = BarcodeItemKt.getTextWithExtension(v1.getBarcodeItem());
                        this = drawableArray.getStringValueDelegate().overrideString((String)this, v1.getBarcodeItem());
                    }
                } else {
                    this = "";
                }
                view.setText((CharSequence)this);
                int n2 = var1_2.getShouldHighlight() ? barcodeTextViewStyle.getTextHighlightedColor() : barcodeTextViewStyle.getTextColor();
                drawableArray = view.getCompoundDrawables();
                Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"getCompoundDrawables(...)");
                for (Drawable drawable2 : drawableArray) {
                    if (drawable2 == null) continue;
                    drawable2.setTint(n2);
                }
                view.setTextColor(n2);
                view.setBackgroundTintList(ColorStateList.valueOf((int)(var1_2.getShouldHighlight() ? barcodeTextViewStyle.getTextContainerHighlightedColor() : barcodeTextViewStyle.getTextContainerColor())));
            }

            /*
             * WARNING - void declaration
             */
            public void bindView(View view, BarcodeItem barcodeItem, BarcodeTextViewStyle style, boolean shouldHighlight) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"view");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"barcodeItem");
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            }
        };
        barcodePolygonsView.barcodeItemPositionHandler = new BarcodeItemViewPositionHandler(){

            /*
             * WARNING - void declaration
             */
            public void adjustPosition(View view, List<? extends PointF> path, RectF bounds) {
                void var2_2;
                void var1_1;
                void var3_3;
                void v0 = var3_3;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"view");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)v0, (String)"bounds");
                var1_1.setX(v0.centerX() - (float)(var1_1.getWidth() / 2));
                view.setY(var3_3.bottom);
            }
        };
        barcodePolygonsView.barcodesResultHandler = (arg_0, arg_1) -> BarcodePolygonsView.barcodesResultHandler$lambda$3(barcodePolygonsView, arg_0, arg_1);
        this.initView((Context)v0, null);
    }

    /*
     * WARNING - void declaration
     */
    public BarcodePolygonsView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void var2_2;
        BarcodeOverlayTextFormat barcodeOverlayTextFormat;
        void v0 = barcodeOverlayTextFormat;
        BarcodePolygonsView barcodePolygonsView = this;
        void v2 = barcodeOverlayTextFormat;
        Intrinsics.checkNotNullParameter((Object)v2, (String)"context");
        super((Context)v2, (AttributeSet)var2_2);
        barcodePolygonsView.barcodeElements = CollectionsKt.emptyList();
        barcodePolygonsView.viewsPool = new ArrayList<View>();
        barcodePolygonsView.processingEnabled = true;
        barcodePolygonsView.mapBarcodeValues = MapsKt.sortedMapOf((arg_0, arg_1) -> BarcodePolygonsView.mapBarcodeValues$lambda$1(BarcodePolygonsView::mapBarcodeValues$lambda$0, arg_0, arg_1), (Pair[])new Pair[0]);
        barcodePolygonsView.defaultPolygonStyle = new BarcodePolygonStyle(true, true, true, 0.0f, 2.0f, -1, -16777216, -1, -16777216, true);
        barcodeOverlayTextFormat = BarcodeOverlayTextFormat.CODE_AND_TYPE;
        barcodePolygonsView.defaultTextViewStyle = new BarcodeTextViewStyle(-1, -16777216, -16777216, -1, barcodeOverlayTextFormat, true);
        barcodePolygonsView.polygonHelper = new PolygonViewHelper();
        barcodePolygonsView.finderRect = new Rect();
        barcodePolygonsView.cameraModule = CameraModule.BACK;
        barcodePolygonsView.stringValueDelegate = new /* invalid duplicate definition of identical inner class */;
        barcodePolygonsView.barcodeAppearanceDelegate = new /* invalid duplicate definition of identical inner class */;
        barcodePolygonsView.barcodeItemViewFactory = new /* invalid duplicate definition of identical inner class */;
        barcodePolygonsView.barcodeItemViewBinder = new /* invalid duplicate definition of identical inner class */;
        barcodePolygonsView.barcodeItemPositionHandler = new /* invalid duplicate definition of identical inner class */;
        barcodePolygonsView.barcodesResultHandler = (arg_0, arg_1) -> BarcodePolygonsView.barcodesResultHandler$lambda$3(barcodePolygonsView, arg_0, arg_1);
        this.initView((Context)v0, (AttributeSet)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void initView(Context context, AttributeSet attrs) {
        this.setWillNotDraw(false);
        if (attrs != null) {
            void var2_2;
            void var1_1;
            this.loadAttributes((Context)var1_1, (AttributeSet)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PointF> mapBarcodePolygonToPointsArray(BarcodeItem barcode, int frameHeight, int frameWidth, int orientation, RectF finderRect, CameraModule cameraModule, boolean analyzerFrameMirrored) {
        ArrayList<PointF> arrayList;
        Object object = barcode.getExtendedQuad();
        ArrayList<PointF> arrayList2 = arrayList;
        arrayList = new ArrayList<PointF>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        int n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void var7_8;
            void var6_7;
            PointF pointF;
            void var4_5;
            Matrix matrix;
            RectF rectF;
            void var2_3;
            void var3_4;
            RectF rectF2;
            void var5_6;
            Object object2 = iterator.next();
            if (n++ < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            void v1 = var5_6;
            object2 = (Point)object2;
            RectF rectF3 = rectF2;
            float f = (float)var3_4;
            float f2 = (float)var2_3;
            rectF2 = new RectF(0.0f, 0.0f, f, f2);
            RectF rectF4 = rectF;
            rectF = new RectF();
            Matrix matrix2 = matrix;
            matrix2();
            matrix2.setRotate((float)var4_5, 0.0f, 0.0f);
            matrix.mapRect(rectF4, rectF3);
            float f3 = v1.top;
            float f4 = v1.left;
            Object object3 = object2;
            Object object4 = ((float)((Point)object3).x + f4) / rectF4.width();
            f3 = ((float)((Point)object3).y + f3) / rectF4.height();
            rectF4 = pointF;
            pointF = new PointF(object4, f3);
            if (var6_7 == CameraModule.FRONT && var7_8 == false) {
                PointF pointF2;
                Matrix matrix3;
                Object object5 = matrix3;
                RectF rectF5 = rectF4;
                Matrix matrix4 = object5;
                matrix4();
                matrix4.setScale(-1.0f, 1.0f, 0.5f, 0.5f);
                object5 = new float[2];
                f3 = rectF5.x;
                float f5 = rectF5.y;
                float[] fArray = new float[2];
                float[] fArray2 = fArray;
                fArray[0] = f3;
                fArray[1] = f5;
                matrix3.mapPoints((float[])object5, fArray2);
                rectF3 = pointF2;
                Object object6 = object5;
                object4 = object6[0];
                pointF2 = new PointF(object4, (float)object6[1]);
            } else {
                PointF pointF3;
                rectF4 = pointF3;
                pointF3 = new PointF(object4, f3);
                rectF3 = rectF4;
            }
            arrayList2.add((PointF)rectF3);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightedFillPaint(Paint $this$highlightedFillPaint, BarcodePolygonStyle polygonStyle) {
        int n;
        void var2_4;
        Paint paint = $this$highlightedFillPaint;
        int n2 = var2_4.getFillHighlightedColor();
        int n3 = n = n2;
        n = n3 >> 16 & 0xFF;
        int n4 = n3 >> 8 & 0xFF;
        int n5 = n3 & 0xFF;
        paint.setColor(Color.argb((int)((int)((double)(n2 >> 24 & 0xFF) * 0.2)), (int)n, (int)n4, (int)n5));
        paint.setPathEffect((PathEffect)new CornerPathEffect(var2_4.getCornerRadius()));
        paint.setStyle(Paint.Style.FILL);
    }

    /*
     * WARNING - void declaration
     */
    private final void fillPaint(Paint $this$fillPaint, BarcodePolygonStyle polygonStyle) {
        int n;
        void var2_4;
        Paint paint = $this$fillPaint;
        int n2 = var2_4.getFillColor();
        int n3 = n = n2;
        n = n3 >> 16 & 0xFF;
        int n4 = n3 >> 8 & 0xFF;
        int n5 = n3 & 0xFF;
        paint.setColor(Color.argb((int)((int)((double)(n2 >> 24 & 0xFF) * 0.2)), (int)n, (int)n4, (int)n5));
        paint.setPathEffect((PathEffect)new CornerPathEffect(var2_4.getCornerRadius()));
        paint.setStyle(Paint.Style.FILL);
    }

    /*
     * WARNING - void declaration
     */
    private final void strokeHighLightedPaint(Paint $this$strokeHighLightedPaint, BarcodePolygonStyle polygonStyle) {
        void var2_2;
        void var1_1;
        Paint paint = $this$strokeHighLightedPaint;
        void v1 = var1_1;
        v1.setColor(var2_2.getStrokeHighlightedColor());
        v1.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(var2_2.getStrokeWidth());
        paint.setAntiAlias(true);
        paint.setPathEffect((PathEffect)new CornerPathEffect(var2_2.getCornerRadius()));
        paint.setStrokeCap(Paint.Cap.SQUARE);
    }

    /*
     * WARNING - void declaration
     */
    private final void strokePaint(Paint $this$strokePaint, BarcodePolygonStyle polygonStyle) {
        void var2_2;
        void var1_1;
        Paint paint = $this$strokePaint;
        void v1 = var1_1;
        v1.setColor(var2_2.getStrokeColor());
        v1.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(var2_2.getStrokeWidth());
        paint.setAntiAlias(true);
        paint.setPathEffect((PathEffect)new CornerPathEffect(var2_2.getCornerRadius()));
        paint.setStrokeCap(Paint.Cap.SQUARE);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadAttributes(Context context, AttributeSet attrs) {
        boolean bl;
        int n;
        void var2_3;
        TypedArray typedArray = context.obtainStyledAttributes((AttributeSet)var2_3, R.styleable.BarcodePolygonsView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        try {
            n = typedArray.getColor(R.styleable.BarcodePolygonsView_polygonFillColor, -1);
            bl = n != 0;
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        TypedArray typedArray2 = typedArray;
        TypedArray typedArray3 = typedArray2;
        TypedArray typedArray4 = typedArray2;
        int n2 = typedArray2.getColor(R.styleable.BarcodePolygonsView_polygonStrokeColor, -1);
        float f = typedArray4.getDimension(R.styleable.BarcodePolygonsView_polygonRoundedCornersRadius, this.getResources().getDimension(R.dimen.polygon_stroke_radius));
        int n3 = typedArray3.getColor(R.styleable.BarcodePolygonsView_polygonFillHighlightedColor, -16777216);
        boolean bl2 = n3 != 0;
        TypedArray typedArray5 = typedArray;
        BarcodePolygonsView barcodePolygonsView = this;
        BarcodePolygonsView barcodePolygonsView2 = barcodePolygonsView;
        BarcodePolygonsView barcodePolygonsView3 = barcodePolygonsView;
        TypedArray typedArray6 = typedArray;
        TypedArray typedArray7 = typedArray6;
        TypedArray typedArray8 = typedArray6;
        TypedArray typedArray9 = typedArray6;
        TypedArray typedArray10 = typedArray6;
        TypedArray typedArray11 = typedArray6;
        TypedArray typedArray12 = typedArray6;
        int n4 = typedArray6.getColor(R.styleable.BarcodePolygonsView_polygonStrokeHighlightedColor, -16777216);
        float f2 = typedArray10.getDimension(R.styleable.BarcodePolygonsView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
        int n5 = typedArray11.getColor(R.styleable.BarcodePolygonsView_textColor, -1);
        int n6 = typedArray12.getColor(R.styleable.BarcodePolygonsView_textHighlightedColor, -16777216);
        int n7 = typedArray8.getColor(R.styleable.BarcodePolygonsView_textContainerColor, -16777216);
        int n8 = typedArray9.getColor(R.styleable.BarcodePolygonsView_textContainerHighlightedColor, -1);
        boolean bl3 = typedArray7.getBoolean(R.styleable.BarcodePolygonsView_drawShadow, false);
        barcodePolygonsView2.defaultPolygonStyle = new BarcodePolygonStyle(true, bl, bl2, f, f2, n2, n4, n, n3, bl3);
        barcodePolygonsView3.defaultTextViewStyle = new BarcodeTextViewStyle(n5, n6, n7, n8, BarcodeOverlayTextFormat.CODE_AND_TYPE, true);
        typedArray5.recycle();
    }

    private final void processNewFrame(List<BarcodeItem> list) {
        Iterator iterator;
        long l = System.currentTimeMillis();
        CollectionsKt.removeAll(this.mapBarcodeValues.entrySet(), arg_0 -> BarcodePolygonsView.processNewFrame$lambda$10((List)((Object)iterator), this, arg_0));
        for (BarcodeItem barcodeItem : list) {
            this.mapBarcodeValues.put(barcodeItem, l + 700L);
        }
        CollectionsKt.removeAll(this.mapBarcodeValues.entrySet(), arg_0 -> BarcodePolygonsView.processNewFrame$lambda$12(l, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean compareBarcodeItems(BarcodeItem key, BarcodeItem item) {
        void var2_2;
        return key.getGlobalIndex() == var2_2.getGlobalIndex();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateShadows(boolean drawShadows, Paint paint, boolean useFill) {
        void var2_3;
        void var1_2;
        void var3_4;
        boolean bl = Build.VERSION.SDK_INT >= 26;
        if (var3_4 == false && var1_2 != false && bl) {
            var2_3.setShadowLayer(35.0f, 0.0f, 0.0f, -16777216);
            return;
        }
        var2_3.clearShadowLayer();
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePolygons(int frameOrientation, List<BarcodeItem> newBarcodes) {
        ArrayList arrayList;
        Object object;
        ArrayList<BarcodeElement> arrayList2;
        ArrayList<BarcodeElement> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<BarcodeElement>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        for (BarcodeItem barcodeItem : newBarcodes) {
            RectF rectF;
            void var4_11;
            BarcodeTextViewStyle barcodeTextViewStyle;
            BarcodePolygonStyle barcodePolygonStyle;
            block8: {
                for (Object t : this.barcodeElements) {
                    barcodePolygonStyle = (BarcodePolygonStyle)t;
                    if (!this.compareBarcodeItems(((BarcodeElement)t).getBarcodeItem(), barcodeItem)) continue;
                    break block8;
                }
                barcodePolygonStyle = null;
            }
            BarcodeElement t = (BarcodeElement)((Object)barcodePolygonStyle);
            if (t == null) {
                BarcodeElement barcodeElement;
                BarcodeElement barcodeElement2 = barcodeElement;
                BarcodePolygonsView barcodePolygonsView = this;
                barcodePolygonStyle = barcodePolygonsView.defaultPolygonStyle;
                barcodeTextViewStyle = barcodePolygonsView.defaultTextViewStyle;
                barcodeElement = new BarcodeElement(barcodeItem, barcodePolygonStyle, barcodeTextViewStyle);
            }
            void v4 = var4_11;
            BarcodePolygonsView barcodePolygonsView = this;
            int n = barcodePolygonsView.frameHeight;
            int n2 = barcodePolygonsView.frameWidth;
            int n3 = barcodePolygonsView.orientation;
            barcodeTextViewStyle = barcodePolygonsView.finderRect;
            RectF rectF2 = rectF;
            rectF = new RectF((Rect)barcodeTextViewStyle);
            barcodeTextViewStyle = barcodePolygonsView.cameraModule;
            boolean bl = barcodePolygonsView.analyzerFrameMirrored;
            var4_11.setPolygon(this.mapBarcodePolygonToPointsArray(barcodeItem, n, n2, n3, rectF2, (CameraModule)barcodeTextViewStyle, bl));
            v4.setBarcodeItem(barcodeItem);
            arrayList3.add((BarcodeElement)v4);
        }
        object = arrayList;
        arrayList = new ArrayList();
        for (Object t : this.barcodeElements) {
            if (arrayList3.contains((BarcodeElement)t)) continue;
            ((ArrayList)object).add(t);
        }
        Object object4 = ViewTreeLifecycleOwner.get((View)this);
        if (object4 != null && (object4 = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)object4)) != null) {
            lge lge2;
            LifecycleOwner lifecycleOwner = object4;
            object4 = lge2;
            lge2 = new lge((ArrayList)object, null);
            object = BuildersKt.launch$default((CoroutineScope)lifecycleOwner, null, null, (Function2)object4, (int)3, null);
        } else {
            object = null;
        }
        BarcodePolygonsView barcodePolygonsView = this;
        barcodePolygonsView.cancelJob = object;
        LoggerProvider.getLogger().d(TAG, "removeAllViews");
        barcodePolygonsView.removeViewsInLayout(0, barcodePolygonsView.getChildCount());
        object = ViewTreeLifecycleOwner.get((View)barcodePolygonsView);
        if (object != null && (object = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)object)) != null) {
            lgb lgb2;
            Object object2 = object;
            object = lgb2;
            lgb2 = new lgb(arrayList3, this, null);
            object = BuildersKt.launch$default((CoroutineScope)object2, null, null, (Function2)object, (int)3, null);
        } else {
            object = null;
        }
        BarcodePolygonsView barcodePolygonsView2 = this;
        barcodePolygonsView2.appearanceJob = object;
        barcodePolygonsView2.barcodeElements = arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    private final Object updatePolygon(BarcodeElement barcodeElement, int index, Continuation<? super Unit> $completion) {
        void var2_2;
        void var1_1;
        Object object = this.barcodeAppearanceDelegate.getTextViewStyle(this.defaultTextViewStyle, var1_1.getBarcodeItem());
        if (object != null) {
            var1_1.setTextStyle((BarcodeTextViewStyle)object);
        }
        if ((object = this.barcodeAppearanceDelegate.getPolygonStyle(this.defaultPolygonStyle, var1_1.getBarcodeItem())) != null) {
            var1_1.setPolygonStyle((BarcodePolygonStyle)object);
        }
        boolean bl = (object = this.barcodeHighlightDelegate) != null && object.shouldHighlight(var1_1.getBarcodeItem());
        var1_1.setShouldHighlight(bl);
        Object object2 = (View)CollectionsKt.getOrNull(this.viewsPool, (int)var2_2);
        if (object2 == null) {
            object2 = this.createClickableView();
            if (object2 != null) {
                this.viewsPool.add((View)object2);
            } else {
                object2 = null;
            }
        }
        if (object2 != null) {
            FrameLayout.LayoutParams layoutParams;
            FrameLayout.LayoutParams layoutParams2 = layoutParams;
            layoutParams = new FrameLayout.LayoutParams(-2, -2);
            this.addView((View)object2, (ViewGroup.LayoutParams)layoutParams2);
            var1_1.setView((View)object2);
        }
        if ((object2 = this.barcodeItemViewBinder) != null && var1_1.getView() != null) {
            object2.bindViewLocal((BarcodeElement)var1_1);
        }
        if (var1_1.getPolygonStyle().getDrawPolygon()) {
            BarcodePolygonsView barcodePolygonsView = this;
            barcodePolygonsView.strokePaint(var1_1.getStrokePaint(), var1_1.getPolygonStyle());
            barcodePolygonsView.strokeHighLightedPaint(var1_1.getStrokeHighlightedPaint(), var1_1.getPolygonStyle());
            barcodePolygonsView.fillPaint(var1_1.getFillPaint(), var1_1.getPolygonStyle());
            barcodePolygonsView.highlightedFillPaint(var1_1.getFillHighlightedPaint(), var1_1.getPolygonStyle());
            barcodePolygonsView.updateShadows(var1_1.getPolygonStyle().getShouldDrawShadows(), var1_1.getStrokePaint(), var1_1.getPolygonStyle().getUseFill());
            barcodePolygonsView.updateShadows(var1_1.getPolygonStyle().getShouldDrawShadows(), var1_1.getStrokeHighlightedPaint(), var1_1.getPolygonStyle().getUseFillHighlighted());
        }
        if (var1_1.getAnimators().isEmpty()) {
            float[] fArray = var1_1.getAnimationPoints();
            object2 = fArray;
            if (fArray == null || (object2 = ArraysKt.asSequence((float[])object2)) == null || (object2 = SequencesKt.mapIndexed((Sequence)object2, (arg_0, arg_1) -> BarcodePolygonsView.updatePolygon$lambda$24((BarcodeElement)var1_1, arg_0, arg_1))) == null || (object2 = SequencesKt.toList((Sequence)object2)) == null) {
                object2 = CollectionsKt.emptyList();
            }
            var1_1.setAnimators((List<SpringAnimation>)object2);
        }
        this.animateToPolygon((BarcodeElement)var1_1);
        return Unit.INSTANCE;
    }

    private final View createClickableView() {
        BarcodeItemViewFactory barcodeItemViewFactory2 = this.barcodeItemViewFactory;
        barcodeItemViewFactory2 = barcodeItemViewFactory2 != null ? barcodeItemViewFactory2.createView() : null;
        if (barcodeItemViewFactory2 != null) {
            BarcodeItemViewFactory barcodeItemViewFactory3 = barcodeItemViewFactory2;
            barcodeItemViewFactory3.setOnClickListener(arg_0 -> BarcodePolygonsView.createClickableView$lambda$29(this, (View)barcodeItemViewFactory2, arg_0));
            return barcodeItemViewFactory3;
        }
        return barcodeItemViewFactory2;
    }

    /*
     * WARNING - void declaration
     */
    private final void animateToPolygon(BarcodeElement barcodeElement) {
        Object object;
        void var1_2;
        if (!barcodeElement.getShouldDrawPolygon()) {
            void v0 = var1_2;
            List<PointF> list = v0.getPolygon();
            object.polygonHelper.polygonToPoints(list, v0.getPoints());
        }
        var1_2.setShouldDrawPolygon(true);
        void v1 = var1_2;
        object = v1.getPolygon();
        object.polygonHelper.polygonToPoints((List)object, v1.getAnimationPoints());
        int n = 0;
        for (Object e : var1_2.getAnimators()) {
            int n2 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ((SpringAnimation)e).animateToFinalPosition(var1_2.getAnimationPoints()[n]);
            n = n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePath(BarcodeElement barcodeElement) {
        RectF rectF;
        ArrayList<PointF> arrayList;
        void var1_1;
        Path path = barcodeElement.getPath();
        float[] fArray = var1_1.getPoints();
        path.rewind();
        float f = fArray[0];
        path.moveTo(f, fArray[1]);
        ArrayList<PointF> arrayList2 = arrayList;
        arrayList = new ArrayList<PointF>();
        for (int i = 2; i < fArray.length; i += 2) {
            PointF pointF;
            PointF pointF2 = pointF;
            float f2 = fArray[i];
            int n = i + 1;
            pointF = new PointF(f2, fArray[n]);
            arrayList2.add(pointF2);
            float f3 = fArray[i];
            path.lineTo(f3, fArray[n]);
        }
        Path path2 = path;
        float f4 = fArray[ArraysKt.getLastIndex((float[])fArray) - 1];
        arrayList2.add(new PointF(f4, fArray[ArraysKt.getLastIndex((float[])fArray)]));
        path2.close();
        RectF rectF2 = rectF;
        path2.computeBounds(new RectF(), true);
        path = var1_1.getView();
        if (path != null) {
            Path path3 = path;
            path3.post(() -> BarcodePolygonsView.updatePath$lambda$33$lambda$32((View)path3, rectF2, this, arrayList2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final int mapBarcodeValues$lambda$0(BarcodeItem o1, BarcodeItem o2) {
        void var1_1;
        return Intrinsics.compare((int)o1.getGlobalIndex(), (int)var1_1.getGlobalIndex());
    }

    /*
     * WARNING - void declaration
     */
    private static final int mapBarcodeValues$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        void var2_2;
        void var1_1;
        return ((Number)$tmp0.invoke((Object)var1_1, (Object)var2_2)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final void barcodesResultHandler$lambda$3$lambda$2(BarcodePolygonsView this$0, List $newValues) {
        void var1_1;
        BarcodePolygonsView barcodePolygonsView = this$0;
        barcodePolygonsView.updatePolygons(barcodePolygonsView.orientation, (List<BarcodeItem>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean barcodesResultHandler$lambda$3(BarcodePolygonsView this$0, Result result, FrameHandler.Frame previewFrame) {
        BarcodePolygonsView barcodePolygonsView;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"result");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"previewFrame");
        if (result instanceof Result.Success && barcodePolygonsView.processingEnabled) {
            barcodePolygonsView.frameWidth = var2_2.getWidth();
            barcodePolygonsView.frameHeight = var2_2.getHeight();
            barcodePolygonsView.orientation = var2_2.getFrameOrientation();
            Rect rect = var2_2.getFinderRect();
            if (rect == null) {
                Rect rect2;
                rect = rect2;
                rect2 = new Rect();
            }
            barcodePolygonsView.finderRect = rect;
            barcodePolygonsView.cameraModule = var2_2.getCameraModule();
            barcodePolygonsView.analyzerFrameMirrored = var2_2.getAnalyzerFrameMirrored();
            if (barcodePolygonsView.frameWidth != 0 && barcodePolygonsView.frameHeight != 0) {
                BarcodePolygonsView barcodePolygonsView2 = barcodePolygonsView;
                barcodePolygonsView2.processNewFrame(((BarcodeScannerResult)((Result.Success)var1_1).getData()).getBarcodes());
                barcodePolygonsView2.post(() -> BarcodePolygonsView.barcodesResultHandler$lambda$3$lambda$2(barcodePolygonsView2, CollectionsKt.toList(barcodePolygonsView2.mapBarcodeValues.keySet())));
            }
        }
        return false;
    }

    private static final void onAttachedToWindow$lambda$8$lambda$7(BarcodePolygonsView this$0, ValueAnimator it) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"it");
        if (this$0.getVisibility() == 0) {
            BarcodePolygonsView barcodePolygonsView;
            iterator = barcodePolygonsView.barcodeElements.iterator();
            while (iterator.hasNext()) {
                barcodePolygonsView.updatePath((BarcodeElement)iterator.next());
            }
            barcodePolygonsView.invalidate();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean processNewFrame$lambda$10(List $list, BarcodePolygonsView this$0, Map.Entry entry) {
        Iterator iterator;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"entry");
        if ($list instanceof Collection && iterator.isEmpty()) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var1_1;
            BarcodeItem barcodeItem = (BarcodeItem)iterator.next();
            if (!super.compareBarcodeItems((BarcodeItem)var2_2.getKey(), barcodeItem)) continue;
            return true;
        }
        return false;
    }

    private static final boolean processNewFrame$lambda$12(long $currentTime, Map.Entry entry) {
        long l;
        Map.Entry entry2 = entry;
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        return ((Number)entry2.getValue()).longValue() <= l;
    }

    /*
     * WARNING - void declaration
     */
    private static final SpringAnimation updatePolygon$lambda$24(BarcodeElement $barcodeElement, int index, float value) {
        void var2_2;
        BarcodeElement barcodeElement;
        void var1_1;
        lgd lgd2;
        lgd lgd3 = lgd2;
        lgd2 = new lgd((int)var1_1);
        SpringAnimation springAnimation = new SpringAnimation((Object)barcodeElement, (FloatPropertyCompat)lgd3, (float)var2_2);
        SpringForce springForce = springAnimation.getSpring();
        springForce.setStiffness(300.0f);
        springForce.setDampingRatio(0.9f);
        return springAnimation;
    }

    private static final void createClickableView$lambda$29(BarcodePolygonsView this$0, View $newView, View it) {
        Object object;
        BarcodeElement barcodeElement;
        Object var3_3;
        block2: {
            for (Object t : this$0.barcodeElements) {
                var3_3 = t;
                if (!Intrinsics.areEqual((Object)((BarcodeElement)t).getView(), (Object)barcodeElement)) continue;
                break block2;
            }
            var3_3 = null;
        }
        barcodeElement = var3_3;
        if (barcodeElement != null && (object = ((BarcodePolygonsView)((Object)object)).polygonValueClickListener) != null) {
            object.onClick(barcodeElement.getBarcodeItem());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void updatePath$lambda$33$lambda$32(View $this_apply, RectF $rectF, BarcodePolygonsView this$0, List $pointsF) {
        void var1_1;
        View view;
        view.setX(var1_1.centerX() - (float)(view.getMeasuredWidth() / 2));
        view.setY(var1_1.centerY() - (float)(view.getMeasuredHeight() / 2));
        BarcodeItemViewPositionHandler barcodeItemViewPositionHandler2 = this$0.barcodeItemPositionHandler;
        if (barcodeItemViewPositionHandler2 != null) {
            void var3_3;
            barcodeItemViewPositionHandler2.adjustPosition(view, (List<? extends PointF>)var3_3, (RectF)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object access$updatePolygon(BarcodePolygonsView $this, BarcodeElement barcodeElement, int index, Continuation $completion) {
        void var3_3;
        void var2_2;
        void var1_1;
        return $this.updatePolygon((BarcodeElement)var1_1, (int)var2_2, (Continuation<? super Unit>)var3_3);
    }

    public static final /* synthetic */ List access$getViewsPool$p(BarcodePolygonsView $this) {
        return $this.viewsPool;
    }

    public static final /* synthetic */ BarcodeTextViewStyle access$getDefaultTextViewStyle$p(BarcodePolygonsView $this) {
        return $this.defaultTextViewStyle;
    }

    public final boolean getProcessingEnabled() {
        return this.processingEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProcessingEnabled(boolean bl) {
        void var1_1;
        this.processingEnabled = var1_1;
    }

    @Nullable
    public final PolygonValueClickListener getPolygonValueClickListener() {
        return this.polygonValueClickListener;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPolygonValueClickListener(@Nullable PolygonValueClickListener polygonValueClickListener) {
        void var1_1;
        this.polygonValueClickListener = var1_1;
    }

    @NotNull
    public final BarcodeStringDelegate getStringValueDelegate() {
        return this.stringValueDelegate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setStringValueDelegate(@NotNull BarcodeStringDelegate barcodeStringDelegate) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.stringValueDelegate = var1_1;
    }

    @NotNull
    public final BarcodeAppearanceDelegate getBarcodeAppearanceDelegate() {
        return this.barcodeAppearanceDelegate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBarcodeAppearanceDelegate(@NotNull BarcodeAppearanceDelegate barcodeAppearanceDelegate2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.barcodeAppearanceDelegate = var1_1;
    }

    @Nullable
    public final BarcodeHighlightDelegate getBarcodeHighlightDelegate() {
        return this.barcodeHighlightDelegate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBarcodeHighlightDelegate(@Nullable BarcodeHighlightDelegate barcodeHighlightDelegate) {
        void var1_1;
        this.barcodeHighlightDelegate = var1_1;
    }

    @Nullable
    public final BarcodeItemViewFactory getBarcodeItemViewFactory() {
        return this.barcodeItemViewFactory;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBarcodeItemViewFactory(@Nullable BarcodeItemViewFactory barcodeItemViewFactory2) {
        void var1_1;
        this.barcodeItemViewFactory = var1_1;
    }

    @Nullable
    public final BarcodeItemViewBinder getBarcodeItemViewBinder() {
        return this.barcodeItemViewBinder;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBarcodeItemViewBinder(@Nullable BarcodeItemViewBinder barcodeItemViewBinder2) {
        void var1_1;
        this.barcodeItemViewBinder = var1_1;
    }

    @Nullable
    public final BarcodeItemViewPositionHandler getBarcodeItemPositionHandler() {
        return this.barcodeItemPositionHandler;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBarcodeItemPositionHandler(@Nullable BarcodeItemViewPositionHandler barcodeItemViewPositionHandler2) {
        void var1_1;
        this.barcodeItemPositionHandler = var1_1;
    }

    @NotNull
    public final BarcodeScannerFrameHandler.ResultHandler getBarcodesResultHandler() {
        return this.barcodesResultHandler;
    }

    public final void resetPolygonState() {
        this.barcodeElements = CollectionsKt.emptyList();
        this.mapBarcodeValues = new LinkedHashMap<BarcodeItem, Long>();
        this.removeAllViews();
    }

    public void onAttachedToWindow() {
        ValueAnimator valueAnimator;
        BarcodePolygonsView barcodePolygonsView = this;
        super.onAttachedToWindow();
        int n = (int)barcodePolygonsView.getDisplay().getRefreshRate();
        ValueAnimator valueAnimator2 = valueAnimator = ObjectAnimator.ofInt((int[])new int[]{n});
        ValueAnimator valueAnimator3 = valueAnimator;
        valueAnimator3.setDuration(1000L);
        valueAnimator3.setRepeatMode(1);
        valueAnimator3.setRepeatCount(-1);
        valueAnimator2.addUpdateListener(arg_0 -> BarcodePolygonsView.onAttachedToWindow$lambda$8$lambda$7(this, arg_0));
        this.frameAnimator = valueAnimator2;
        valueAnimator.start();
    }

    public void onDetachedFromWindow() {
        BarcodePolygonsView barcodePolygonsView = this;
        super.onDetachedFromWindow();
        LoggerProvider.getLogger().d(TAG, " onDetachedFromWindow");
        ValueAnimator valueAnimator = barcodePolygonsView.frameAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        if ((valueAnimator = this.cancelJob) != null) {
            Job.DefaultImpls.cancel$default((Job)valueAnimator, null, (int)1, null);
        }
        if ((this = this.appearanceJob) != null) {
            Job.DefaultImpls.cancel$default((Job)this, null, (int)1, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        BarcodePolygonsView barcodePolygonsView = this;
        super.onSizeChanged((int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4);
        barcodePolygonsView.polygonHelper.setLayout(0, 0, (int)var1_1, (int)var2_2);
    }

    @Nullable
    public final Job getCancelJob() {
        return this.cancelJob;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCancelJob(@Nullable Job job) {
        void var1_1;
        this.cancelJob = var1_1;
    }

    @Nullable
    public final Job getAppearanceJob() {
        return this.appearanceJob;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAppearanceJob(@Nullable Job job) {
        void var1_1;
        this.appearanceJob = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        void var1_1;
        if (event != null && var1_1.getAction() == 0) {
            Object var4_7;
            block5: {
                void v0 = var1_1;
                float f = v0.getX();
                float f2 = v0.getY();
                for (Object t : this.barcodeElements) {
                    RectF rectF;
                    RectF rectF2;
                    var4_7 = t;
                    Path path = ((BarcodeElement)t).getPath();
                    RectF rectF3 = rectF2 = rectF;
                    rectF3();
                    path.computeBounds(rectF3, true);
                    if (!rectF.contains(f, f2)) continue;
                    break block5;
                }
                var4_7 = null;
            }
            BarcodeElement barcodeElement = var4_7;
            if (barcodeElement != null) {
                Object object = this.polygonValueClickListener;
                if (object != null) {
                    object.onClick(barcodeElement.getBarcodeItem());
                }
                if ((object = ViewTreeLifecycleOwner.get((View)this)) != null && (object = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)object)) != null) {
                    lgu lgu2;
                    PolygonValueClickListener polygonValueClickListener = object;
                    object = lgu2;
                    lgu2 = new lgu(this, barcodeElement, null);
                    BuildersKt.launch$default((CoroutineScope)polygonValueClickListener, null, null, (Function2)object, (int)3, null);
                }
                return true;
            }
            return false;
        }
        return super.onTouchEvent((MotionEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onDraw(@NotNull Canvas canvas) {
        void var1_1;
        BarcodePolygonsView barcodePolygonsView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"canvas");
        super.onDraw((Canvas)v1);
        for (BarcodeElement barcodeElement : barcodePolygonsView.barcodeElements) {
            Path path = barcodeElement.getPath();
            if (!barcodeElement.getPolygonStyle().getDrawPolygon() || !barcodeElement.getShouldDrawPolygon()) continue;
            if (barcodeElement.getShouldHighlight()) {
                if (barcodeElement.getPolygonStyle().getUseFillHighlighted()) {
                    var1_1.drawPath(path, barcodeElement.getFillHighlightedPaint());
                }
                var1_1.drawPath(path, barcodeElement.getStrokeHighlightedPaint());
                continue;
            }
            if (barcodeElement.getPolygonStyle().getUseFill()) {
                var1_1.drawPath(path, barcodeElement.getFillPaint());
            }
            var1_1.drawPath(path, barcodeElement.getStrokePaint());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeAppearanceDelegate;", "", "getPolygonStyle", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;", "defaultStyle", "barcodeItem", "Lio/scanbot/sdk/barcode/BarcodeItem;", "getTextViewStyle", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;", "sdk-barcode_release"})
    public static interface BarcodeAppearanceDelegate {
        @NotNull
        public BarcodePolygonStyle getPolygonStyle(@NotNull BarcodePolygonStyle var1, @NotNull BarcodeItem var2);

        @NotNull
        public BarcodeTextViewStyle getTextViewStyle(@NotNull BarcodeTextViewStyle var1, @NotNull BarcodeItem var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020LH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010>R\u0011\u0010A\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010>R\u0011\u0010C\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010>R \u0010E\u001a\b\u0012\u0004\u0012\u00020F0 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010#\"\u0004\bH\u0010%\u00a8\u0006M"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeElement;", "", "barcodeItem", "Lio/scanbot/sdk/barcode/BarcodeItem;", "polygonStyle", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;", "textStyle", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;", "<init>", "(Lio/scanbot/sdk/barcode/BarcodeItem;Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;)V", "getBarcodeItem", "()Lio/scanbot/sdk/barcode/BarcodeItem;", "setBarcodeItem", "(Lio/scanbot/sdk/barcode/BarcodeItem;)V", "getPolygonStyle", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;", "setPolygonStyle", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;)V", "getTextStyle", "()Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;", "setTextStyle", "(Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;)V", "shouldHighlight", "", "getShouldHighlight", "()Z", "setShouldHighlight", "(Z)V", "shouldDrawPolygon", "getShouldDrawPolygon", "setShouldDrawPolygon", "polygon", "", "Landroid/graphics/PointF;", "getPolygon", "()Ljava/util/List;", "setPolygon", "(Ljava/util/List;)V", "path", "Landroid/graphics/Path;", "getPath", "()Landroid/graphics/Path;", "setPath", "(Landroid/graphics/Path;)V", "view", "Landroid/view/View;", "getView", "()Landroid/view/View;", "setView", "(Landroid/view/View;)V", "points", "", "getPoints", "()[F", "setPoints", "([F)V", "animationPoints", "getAnimationPoints", "setAnimationPoints", "fillPaint", "Landroid/graphics/Paint;", "getFillPaint", "()Landroid/graphics/Paint;", "strokeHighlightedPaint", "getStrokeHighlightedPaint", "fillHighlightedPaint", "getFillHighlightedPaint", "strokePaint", "getStrokePaint", "animators", "Landroidx/dynamicanimation/animation/SpringAnimation;", "getAnimators", "setAnimators", "hashCode", "", "toString", "", "sdk-barcode_release"})
    public static final class BarcodeElement {
        @NotNull
        private BarcodeItem barcodeItem;
        @NotNull
        private BarcodePolygonStyle polygonStyle;
        @NotNull
        private BarcodeTextViewStyle textStyle;
        private boolean shouldHighlight;
        private boolean shouldDrawPolygon;
        @NotNull
        private List<? extends PointF> polygon;
        @NotNull
        private Path path;
        @Nullable
        private View view;
        @NotNull
        private float[] points;
        @NotNull
        private float[] animationPoints;
        @NotNull
        private final Paint fillPaint;
        @NotNull
        private final Paint strokeHighlightedPaint;
        @NotNull
        private final Paint fillHighlightedPaint;
        @NotNull
        private final Paint strokePaint;
        @NotNull
        private List<SpringAnimation> animators;

        /*
         * WARNING - void declaration
         */
        public BarcodeElement(@NotNull BarcodeItem barcodeItem, @NotNull BarcodePolygonStyle polygonStyle, @NotNull BarcodeTextViewStyle textStyle) {
            void var3_3;
            void var2_2;
            void var1_1;
            BarcodeElement barcodeElement = this;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"barcodeItem");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"polygonStyle");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"textStyle");
            this.barcodeItem = var1_1;
            this.polygonStyle = var2_2;
            barcodeElement.textStyle = var3_3;
            barcodeElement.polygon = CollectionsKt.emptyList();
            barcodeElement.path = new Path();
            barcodeElement.points = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
            barcodeElement.animationPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
            barcodeElement.fillPaint = new Paint();
            barcodeElement.strokeHighlightedPaint = new Paint();
            barcodeElement.fillHighlightedPaint = new Paint();
            barcodeElement.strokePaint = new Paint();
            barcodeElement.animators = CollectionsKt.emptyList();
        }

        @NotNull
        public final BarcodeItem getBarcodeItem() {
            return this.barcodeItem;
        }

        /*
         * WARNING - void declaration
         */
        public final void setBarcodeItem(@NotNull BarcodeItem barcodeItem) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.barcodeItem = var1_1;
        }

        @NotNull
        public final BarcodePolygonStyle getPolygonStyle() {
            return this.polygonStyle;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPolygonStyle(@NotNull BarcodePolygonStyle barcodePolygonStyle) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.polygonStyle = var1_1;
        }

        @NotNull
        public final BarcodeTextViewStyle getTextStyle() {
            return this.textStyle;
        }

        /*
         * WARNING - void declaration
         */
        public final void setTextStyle(@NotNull BarcodeTextViewStyle barcodeTextViewStyle) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.textStyle = var1_1;
        }

        public final boolean getShouldHighlight() {
            return this.shouldHighlight;
        }

        /*
         * WARNING - void declaration
         */
        public final void setShouldHighlight(boolean bl) {
            void var1_1;
            this.shouldHighlight = var1_1;
        }

        public final boolean getShouldDrawPolygon() {
            return this.shouldDrawPolygon;
        }

        /*
         * WARNING - void declaration
         */
        public final void setShouldDrawPolygon(boolean bl) {
            void var1_1;
            this.shouldDrawPolygon = var1_1;
        }

        @NotNull
        public final List<PointF> getPolygon() {
            return this.polygon;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPolygon(@NotNull List<? extends PointF> list) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.polygon = var1_1;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPath(@NotNull Path path) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.path = var1_1;
        }

        @Nullable
        public final View getView() {
            return this.view;
        }

        /*
         * WARNING - void declaration
         */
        public final void setView(@Nullable View view) {
            void var1_1;
            this.view = var1_1;
        }

        @NotNull
        public final float[] getPoints() {
            return this.points;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPoints(@NotNull float[] fArray) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.points = var1_1;
        }

        @NotNull
        public final float[] getAnimationPoints() {
            return this.animationPoints;
        }

        /*
         * WARNING - void declaration
         */
        public final void setAnimationPoints(@NotNull float[] fArray) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.animationPoints = var1_1;
        }

        @NotNull
        public final Paint getFillPaint() {
            return this.fillPaint;
        }

        @NotNull
        public final Paint getStrokeHighlightedPaint() {
            return this.strokeHighlightedPaint;
        }

        @NotNull
        public final Paint getFillHighlightedPaint() {
            return this.fillHighlightedPaint;
        }

        @NotNull
        public final Paint getStrokePaint() {
            return this.strokePaint;
        }

        @NotNull
        public final List<SpringAnimation> getAnimators() {
            return this.animators;
        }

        /*
         * WARNING - void declaration
         */
        public final void setAnimators(@NotNull List<SpringAnimation> list) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.animators = var1_1;
        }

        public int hashCode() {
            return (BarcodeItemKt.getTextWithExtension(this.barcodeItem) + "_" + this.barcodeItem.getFormat().name()).hashCode();
        }

        @NotNull
        public String toString() {
            return BarcodeItemKt.getTextWithExtension(this.barcodeItem) + "_" + this.barcodeItem.getFormat().name();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeHighlightDelegate;", "", "shouldHighlight", "", "barcodeItem", "Lio/scanbot/sdk/barcode/BarcodeItem;", "sdk-barcode_release"})
    public static interface BarcodeHighlightDelegate {
        public boolean shouldHighlight(@NotNull BarcodeItem var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewBinder;", "", "bindViewLocal", "", "barcodeElement", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeElement;", "bindView", "view", "Landroid/view/View;", "barcodeItem", "Lio/scanbot/sdk/barcode/BarcodeItem;", "style", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;", "shouldHighlight", "", "sdk-barcode_release"})
    public static interface BarcodeItemViewBinder {
        public void bindViewLocal(@NotNull BarcodeElement var1);

        public void bindView(@NotNull View var1, @NotNull BarcodeItem var2, @NotNull BarcodeTextViewStyle var3, boolean var4);

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void bindViewLocal(@NotNull BarcodeItemViewBinder $this, @NotNull BarcodeElement barcodeElement) {
                BarcodeElement barcodeElement2 = barcodeElement;
                Intrinsics.checkNotNullParameter((Object)barcodeElement2, (String)"barcodeElement");
                View view = barcodeElement2.getView();
                if (view != null) {
                    BarcodeTextViewStyle barcodeTextViewStyle;
                    BarcodeItemViewBinder barcodeItemViewBinder2;
                    BarcodeItemViewBinder barcodeItemViewBinder3 = barcodeItemViewBinder2;
                    void v2 = barcodeTextViewStyle;
                    barcodeItemViewBinder2 = v2.getBarcodeItem();
                    barcodeTextViewStyle = v2.getTextStyle();
                    boolean bl = v2.getShouldHighlight();
                    barcodeItemViewBinder3.bindView(view, (BarcodeItem)barcodeItemViewBinder2, barcodeTextViewStyle, bl);
                    return;
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewFactory;", "", "createView", "Landroid/view/View;", "sdk-barcode_release"})
    public static interface BarcodeItemViewFactory {
        @NotNull
        public View createView();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeItemViewPositionHandler;", "", "adjustPosition", "", "view", "Landroid/view/View;", "path", "", "Landroid/graphics/PointF;", "bounds", "Landroid/graphics/RectF;", "sdk-barcode_release"})
    public static interface BarcodeItemViewPositionHandler {
        public void adjustPosition(@NotNull View var1, @NotNull List<? extends PointF> var2, @NotNull RectF var3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b$\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\t\u0010&\u001a\u00020\nH\u00c6\u0003J\t\u0010'\u001a\u00020\nH\u00c6\u0003J\t\u0010(\u001a\u00020\nH\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003Jm\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010+\u001a\u00020\u00032\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\nH\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012\u00a8\u00060"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodePolygonStyle;", "", "drawPolygon", "", "useFill", "useFillHighlighted", "cornerRadius", "", "strokeWidth", "strokeColor", "", "strokeHighlightedColor", "fillColor", "fillHighlightedColor", "shouldDrawShadows", "<init>", "(ZZZFFIIIIZ)V", "getDrawPolygon", "()Z", "setDrawPolygon", "(Z)V", "getUseFill", "getUseFillHighlighted", "getCornerRadius", "()F", "getStrokeWidth", "getStrokeColor", "()I", "getStrokeHighlightedColor", "getFillColor", "getFillHighlightedColor", "getShouldDrawShadows", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "other", "hashCode", "toString", "", "sdk-barcode_release"})
    public static final class BarcodePolygonStyle {
        private boolean drawPolygon;
        private final boolean useFill;
        private final boolean useFillHighlighted;
        private final float cornerRadius;
        private final float strokeWidth;
        private final int strokeColor;
        private final int strokeHighlightedColor;
        private final int fillColor;
        private final int fillHighlightedColor;
        private final boolean shouldDrawShadows;

        /*
         * WARNING - void declaration
         */
        public BarcodePolygonStyle(boolean drawPolygon, boolean useFill, boolean useFillHighlighted, float cornerRadius, float strokeWidth, int strokeColor, int strokeHighlightedColor, int fillColor, int fillHighlightedColor, boolean shouldDrawShadows) {
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.drawPolygon = var1_1;
            this.useFill = var2_2;
            this.useFillHighlighted = var3_3;
            this.cornerRadius = var4_4;
            this.strokeWidth = var5_5;
            this.strokeColor = var6_6;
            this.strokeHighlightedColor = var7_7;
            this.fillColor = var8_8;
            this.fillHighlightedColor = var9_9;
            this.shouldDrawShadows = var10_10;
        }

        public static /* synthetic */ BarcodePolygonStyle copy$default(BarcodePolygonStyle barcodePolygonStyle, boolean bl, boolean bl2, boolean bl3, float f, float f2, int n, int n2, int n3, int n4, boolean bl4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                bl = barcodePolygonStyle.drawPolygon;
            }
            if ((n5 & 2) != 0) {
                bl2 = barcodePolygonStyle.useFill;
            }
            if ((n5 & 4) != 0) {
                bl3 = barcodePolygonStyle.useFillHighlighted;
            }
            if ((n5 & 8) != 0) {
                f = barcodePolygonStyle.cornerRadius;
            }
            if ((n5 & 0x10) != 0) {
                f2 = barcodePolygonStyle.strokeWidth;
            }
            if ((n5 & 0x20) != 0) {
                n = barcodePolygonStyle.strokeColor;
            }
            if ((n5 & 0x40) != 0) {
                n2 = barcodePolygonStyle.strokeHighlightedColor;
            }
            if ((n5 & 0x80) != 0) {
                n3 = barcodePolygonStyle.fillColor;
            }
            if ((n5 & 0x100) != 0) {
                n4 = barcodePolygonStyle.fillHighlightedColor;
            }
            if ((n5 & 0x200) != 0) {
                bl4 = barcodePolygonStyle.shouldDrawShadows;
            }
            return barcodePolygonStyle.copy(bl, bl2, bl3, f, f2, n, n2, n3, n4, bl4);
        }

        public final boolean getDrawPolygon() {
            return this.drawPolygon;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDrawPolygon(boolean bl) {
            void var1_1;
            this.drawPolygon = var1_1;
        }

        public final boolean getUseFill() {
            return this.useFill;
        }

        public final boolean getUseFillHighlighted() {
            return this.useFillHighlighted;
        }

        public final float getCornerRadius() {
            return this.cornerRadius;
        }

        public final float getStrokeWidth() {
            return this.strokeWidth;
        }

        public final int getStrokeColor() {
            return this.strokeColor;
        }

        public final int getStrokeHighlightedColor() {
            return this.strokeHighlightedColor;
        }

        public final int getFillColor() {
            return this.fillColor;
        }

        public final int getFillHighlightedColor() {
            return this.fillHighlightedColor;
        }

        public final boolean getShouldDrawShadows() {
            return this.shouldDrawShadows;
        }

        public final boolean component1() {
            return this.drawPolygon;
        }

        public final boolean component2() {
            return this.useFill;
        }

        public final boolean component3() {
            return this.useFillHighlighted;
        }

        public final float component4() {
            return this.cornerRadius;
        }

        public final float component5() {
            return this.strokeWidth;
        }

        public final int component6() {
            return this.strokeColor;
        }

        public final int component7() {
            return this.strokeHighlightedColor;
        }

        public final int component8() {
            return this.fillColor;
        }

        public final int component9() {
            return this.fillHighlightedColor;
        }

        public final boolean component10() {
            return this.shouldDrawShadows;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BarcodePolygonStyle copy(boolean drawPolygon, boolean useFill, boolean useFillHighlighted, float cornerRadius, float strokeWidth, int strokeColor, int strokeHighlightedColor, int fillColor, int fillHighlightedColor, boolean shouldDrawShadows) {
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            return new BarcodePolygonStyle((boolean)var1_1, (boolean)var2_2, (boolean)var3_3, (float)var4_4, (float)var5_5, (int)var6_6, (int)var7_7, (int)var8_8, (int)var9_9, (boolean)var10_10);
        }

        @NotNull
        public String toString() {
            BarcodePolygonStyle barcodePolygonStyle = this;
            boolean bl = barcodePolygonStyle.useFill;
            boolean bl2 = barcodePolygonStyle.useFillHighlighted;
            float f = barcodePolygonStyle.cornerRadius;
            float f2 = barcodePolygonStyle.strokeWidth;
            int n = barcodePolygonStyle.strokeColor;
            int n2 = barcodePolygonStyle.strokeHighlightedColor;
            int n3 = barcodePolygonStyle.fillColor;
            int n4 = barcodePolygonStyle.fillHighlightedColor;
            boolean bl3 = barcodePolygonStyle.shouldDrawShadows;
            return "BarcodePolygonStyle(drawPolygon=" + this.drawPolygon + ", useFill=" + bl + ", useFillHighlighted=" + bl2 + ", cornerRadius=" + f + ", strokeWidth=" + f2 + ", strokeColor=" + n + ", strokeHighlightedColor=" + n2 + ", fillColor=" + n3 + ", fillHighlightedColor=" + n4 + ", shouldDrawShadows=" + bl3 + ")";
        }

        public int hashCode() {
            BarcodePolygonStyle barcodePolygonStyle = this;
            int n = Boolean.hashCode(barcodePolygonStyle.drawPolygon) * 31;
            n = (Boolean.hashCode(barcodePolygonStyle.useFill) + n) * 31;
            n = (Boolean.hashCode(barcodePolygonStyle.useFillHighlighted) + n) * 31;
            n = (Float.hashCode(barcodePolygonStyle.cornerRadius) + n) * 31;
            n = (Float.hashCode(barcodePolygonStyle.strokeWidth) + n) * 31;
            n = (Integer.hashCode(barcodePolygonStyle.strokeColor) + n) * 31;
            n = (Integer.hashCode(barcodePolygonStyle.strokeHighlightedColor) + n) * 31;
            n = (Integer.hashCode(barcodePolygonStyle.fillColor) + n) * 31;
            n = (Integer.hashCode(barcodePolygonStyle.fillHighlightedColor) + n) * 31;
            return Boolean.hashCode(barcodePolygonStyle.shouldDrawShadows) + n;
        }

        public boolean equals(@Nullable Object other) {
            BarcodePolygonStyle barcodePolygonStyle;
            if (this == barcodePolygonStyle) {
                return true;
            }
            if (!(barcodePolygonStyle instanceof BarcodePolygonStyle)) {
                return false;
            }
            barcodePolygonStyle = barcodePolygonStyle;
            if (this.drawPolygon != barcodePolygonStyle.drawPolygon) {
                return false;
            }
            if (this.useFill != barcodePolygonStyle.useFill) {
                return false;
            }
            if (this.useFillHighlighted != barcodePolygonStyle.useFillHighlighted) {
                return false;
            }
            if (Float.compare(this.cornerRadius, barcodePolygonStyle.cornerRadius) != 0) {
                return false;
            }
            if (Float.compare(this.strokeWidth, barcodePolygonStyle.strokeWidth) != 0) {
                return false;
            }
            if (this.strokeColor != barcodePolygonStyle.strokeColor) {
                return false;
            }
            if (this.strokeHighlightedColor != barcodePolygonStyle.strokeHighlightedColor) {
                return false;
            }
            if (this.fillColor != barcodePolygonStyle.fillColor) {
                return false;
            }
            if (this.fillHighlightedColor != barcodePolygonStyle.fillHighlightedColor) {
                return false;
            }
            return this.shouldDrawShadows == barcodePolygonStyle.shouldDrawShadows;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeStringDelegate;", "", "overrideString", "", "string", "barcodeItem", "Lio/scanbot/sdk/barcode/BarcodeItem;", "sdk-barcode_release"})
    public static interface BarcodeStringDelegate {
        @NotNull
        public String overrideString(@NotNull String var1, @NotNull BarcodeItem var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003JE\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeTextViewStyle;", "", "textColor", "", "textHighlightedColor", "textContainerColor", "textContainerHighlightedColor", "textFormat", "Lio/scanbot/sdk/barcode/ui/BarcodeOverlayTextFormat;", "shouldDrawShadows", "", "<init>", "(IIIILio/scanbot/sdk/barcode/ui/BarcodeOverlayTextFormat;Z)V", "getTextColor", "()I", "getTextHighlightedColor", "getTextContainerColor", "getTextContainerHighlightedColor", "getTextFormat", "()Lio/scanbot/sdk/barcode/ui/BarcodeOverlayTextFormat;", "getShouldDrawShadows", "()Z", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "", "sdk-barcode_release"})
    public static final class BarcodeTextViewStyle {
        private final int textColor;
        private final int textHighlightedColor;
        private final int textContainerColor;
        private final int textContainerHighlightedColor;
        @NotNull
        private final BarcodeOverlayTextFormat textFormat;
        private final boolean shouldDrawShadows;

        /*
         * WARNING - void declaration
         */
        public BarcodeTextViewStyle(int textColor, int textHighlightedColor, int textContainerColor, int textContainerHighlightedColor, @NotNull BarcodeOverlayTextFormat textFormat, boolean shouldDrawShadows) {
            void var6_6;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            void var5_5;
            Intrinsics.checkNotNullParameter((Object)var5_5, (String)"textFormat");
            this.textColor = var1_1;
            this.textHighlightedColor = var2_2;
            this.textContainerColor = var3_3;
            this.textContainerHighlightedColor = var4_4;
            this.textFormat = var5_5;
            this.shouldDrawShadows = var6_6;
        }

        public static /* synthetic */ BarcodeTextViewStyle copy$default(BarcodeTextViewStyle barcodeTextViewStyle, int n, int n2, int n3, int n4, BarcodeOverlayTextFormat barcodeOverlayTextFormat, boolean bl, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = barcodeTextViewStyle.textColor;
            }
            if ((n5 & 2) != 0) {
                n2 = barcodeTextViewStyle.textHighlightedColor;
            }
            if ((n5 & 4) != 0) {
                n3 = barcodeTextViewStyle.textContainerColor;
            }
            if ((n5 & 8) != 0) {
                n4 = barcodeTextViewStyle.textContainerHighlightedColor;
            }
            if ((n5 & 0x10) != 0) {
                barcodeOverlayTextFormat = barcodeTextViewStyle.textFormat;
            }
            if ((n5 & 0x20) != 0) {
                bl = barcodeTextViewStyle.shouldDrawShadows;
            }
            return barcodeTextViewStyle.copy(n, n2, n3, n4, barcodeOverlayTextFormat, bl);
        }

        public final int getTextColor() {
            return this.textColor;
        }

        public final int getTextHighlightedColor() {
            return this.textHighlightedColor;
        }

        public final int getTextContainerColor() {
            return this.textContainerColor;
        }

        public final int getTextContainerHighlightedColor() {
            return this.textContainerHighlightedColor;
        }

        @NotNull
        public final BarcodeOverlayTextFormat getTextFormat() {
            return this.textFormat;
        }

        public final boolean getShouldDrawShadows() {
            return this.shouldDrawShadows;
        }

        public final int component1() {
            return this.textColor;
        }

        public final int component2() {
            return this.textHighlightedColor;
        }

        public final int component3() {
            return this.textContainerColor;
        }

        public final int component4() {
            return this.textContainerHighlightedColor;
        }

        @NotNull
        public final BarcodeOverlayTextFormat component5() {
            return this.textFormat;
        }

        public final boolean component6() {
            return this.shouldDrawShadows;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BarcodeTextViewStyle copy(int textColor, int textHighlightedColor, int textContainerColor, int textContainerHighlightedColor, @NotNull BarcodeOverlayTextFormat textFormat, boolean shouldDrawShadows) {
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)((Object)textFormat), (String)"textFormat");
            return new BarcodeTextViewStyle((int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4, (BarcodeOverlayTextFormat)var5_5, (boolean)var6_6);
        }

        @NotNull
        public String toString() {
            BarcodeTextViewStyle barcodeTextViewStyle = this;
            int n = barcodeTextViewStyle.textHighlightedColor;
            int n2 = barcodeTextViewStyle.textContainerColor;
            int n3 = barcodeTextViewStyle.textContainerHighlightedColor;
            BarcodeOverlayTextFormat barcodeOverlayTextFormat = barcodeTextViewStyle.textFormat;
            boolean bl = barcodeTextViewStyle.shouldDrawShadows;
            return "BarcodeTextViewStyle(textColor=" + this.textColor + ", textHighlightedColor=" + n + ", textContainerColor=" + n2 + ", textContainerHighlightedColor=" + n3 + ", textFormat=" + barcodeOverlayTextFormat + ", shouldDrawShadows=" + bl + ")";
        }

        public int hashCode() {
            BarcodeTextViewStyle barcodeTextViewStyle = this;
            int n = Integer.hashCode(barcodeTextViewStyle.textColor) * 31;
            n = (Integer.hashCode(barcodeTextViewStyle.textHighlightedColor) + n) * 31;
            n = (Integer.hashCode(barcodeTextViewStyle.textContainerColor) + n) * 31;
            n = (Integer.hashCode(barcodeTextViewStyle.textContainerHighlightedColor) + n) * 31;
            n = (((Object)((Object)barcodeTextViewStyle.textFormat)).hashCode() + n) * 31;
            return Boolean.hashCode(barcodeTextViewStyle.shouldDrawShadows) + n;
        }

        public boolean equals(@Nullable Object other) {
            BarcodeTextViewStyle barcodeTextViewStyle;
            if (this == barcodeTextViewStyle) {
                return true;
            }
            if (!(barcodeTextViewStyle instanceof BarcodeTextViewStyle)) {
                return false;
            }
            barcodeTextViewStyle = barcodeTextViewStyle;
            if (this.textColor != barcodeTextViewStyle.textColor) {
                return false;
            }
            if (this.textHighlightedColor != barcodeTextViewStyle.textHighlightedColor) {
                return false;
            }
            if (this.textContainerColor != barcodeTextViewStyle.textContainerColor) {
                return false;
            }
            if (this.textContainerHighlightedColor != barcodeTextViewStyle.textContainerHighlightedColor) {
                return false;
            }
            if (this.textFormat != barcodeTextViewStyle.textFormat) {
                return false;
            }
            return this.shouldDrawShadows == barcodeTextViewStyle.shouldDrawShadows;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$Companion;", "", "<init>", "()V", "defaultFillPaintAlpha", "", "RETAIN_BARCODE_TIMEOUT_MS", "", "TAG", "", "sdk-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$PolygonValueClickListener;", "", "onClick", "", "barcodeItem", "Lio/scanbot/sdk/barcode/BarcodeItem;", "sdk-barcode_release"})
    public static interface PolygonValueClickListener {
        public void onClick(@NotNull BarcodeItem var1);
    }
}

