/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.connectivity.BlobsStorage;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/blob/BlobFactory;", "", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "Lio/scanbot/sdk/connectivity/BlobsStorage;", "blobsStorage", "Landroid/content/res/AssetManager;", "assetManager", "<init>", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/connectivity/BlobsStorage;Landroid/content/res/AssetManager;)V", "Lio/scanbot/sdk/blob/BlobType;", "blobType", "", "Lio/scanbot/sdk/entity/Blob;", "getBlobsForType", "(Lio/scanbot/sdk/blob/BlobType;)Ljava/util/Collection;", "", "isAvailableInAssets", "(Lio/scanbot/sdk/blob/BlobType;)Z", "sdk-base_release"}, xi=48)
public final class BlobFactory {
    public final BlobStoreStrategy wch;
    public final BlobsStorage wcd;
    public final AssetManager wcu;

    /*
     * WARNING - void declaration
     */
    public BlobFactory(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull BlobsStorage blobsStorage, @NotNull AssetManager assetManager) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobsStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"assetManager");
        this.wch = var1_1;
        this.wcd = var2_2;
        this.wcu = var3_3;
    }

    @NotNull
    public final Collection<Blob> getBlobsForType(@NotNull BlobType blobType) {
        Object object;
        File file;
        Object object2;
        BlobType blobType2 = blobType;
        Intrinsics.checkNotNullParameter((Object)((Object)blobType2), (String)"blobType");
        if (blobType2 == BlobType.OCR_BLOBS) {
            File file2;
            object2 = file2;
            file2 = new File(((BlobFactory)object).wcd.ocrBlobsPath().toString());
        } else {
            File file3;
            object2 = file3;
            file3 = new File("", ((BlobType)((Object)file)).getFilename());
        }
        void v3 = file;
        object2 = ((File)object2).getPath();
        file = ((BlobFactory)object).wch.getLocalFileFor((BlobType)((Object)file));
        if (v3.isFolder()) {
            HashSet hashSet;
            BlobFactory blobFactory = object;
            object = hashSet;
            hashSet = new HashSet();
            Object object3 = blobFactory.wcu.list((String)object2);
            if (object3 != null) {
                object3 = ArrayIteratorKt.iterator((Object[])object3);
                while (object3.hasNext()) {
                    File file4;
                    String string = (String)object3.next();
                    Object object4 = file4;
                    file4 = new File((String)object2, string);
                    string = new File(file, string).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    object4 = ((File)object4).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getPath(...)");
                    ((HashSet)object).add(new Blob(string, (String)object4));
                }
            }
            return object;
        }
        object = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getPath(...)");
        Intrinsics.checkNotNull((Object)object2);
        return SetsKt.setOf((Object)new Blob((String)object, (String)object2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isAvailableInAssets(@NotNull BlobType blobType) {
        Object[] objectArray;
        void var1_1;
        block5: {
            BlobType blobType2 = blobType;
            Intrinsics.checkNotNullParameter((Object)((Object)blobType2), (String)"blobType");
            try {
                if (!blobType2.isFolder()) break block5;
                objectArray = objectArray.wcu.list(var1_1.getFilename());
                if (objectArray == null) return false;
                if (objectArray.length == 0) return false;
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        objectArray = objectArray.wcu.list("");
        if (objectArray == null) return false;
        if (!ArraysKt.contains((Object[])objectArray, (Object)var1_1.getFilename())) return false;
        return true;
    }
}

