/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.os.Environment;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.camera.core.ImageProxy;
import io.scanbot.sdk.camera.CameraViewType;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.ScanbotCameraViewConfigurationProvider;
import io.scanbot.sdk.exceptions.camera.CodecFailedException;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.image.SaveImageOptions;
import io.scanbot.sdk.util.ImageUtils;
import io.scanbot.tools.utils.kotlin.NumbersKt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ1\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0006J'\u0010\u0019\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ5\u0010!\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\t\u00a2\u0006\u0004\b!\u0010\"J-\u0010#\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0010\u00a2\u0006\u0004\b#\u0010$J7\u0010+\u001a\u0004\u0018\u00010\u00102\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\t\u00a2\u0006\u0004\b+\u0010,J\u001d\u00102\u001a\u0002012\u0006\u0010.\u001a\u00020-2\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b2\u00103\u00a8\u00064"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraImageUtils;", "", "Landroidx/camera/core/ImageProxy;", "image", "", "imageToJpegByteArray", "(Landroidx/camera/core/ImageProxy;)[B", "Landroid/util/Rational;", "rational", "", "rotation", "rotate", "(Landroid/util/Rational;I)Landroid/util/Rational;", "nv21", "width", "height", "Landroid/graphics/Rect;", "cropRect", "nv21ToJpeg", "([BIILandroid/graphics/Rect;)[B", "Landroid/graphics/Bitmap;", "src", "bitmapToNv21", "(Landroid/graphics/Bitmap;II)[B", "yuv420888toNv21", "nv21ToYuv420888", "([BII)[B", "inverseRational", "(Landroid/util/Rational;)Landroid/util/Rational;", "", "changeOrientation", "origRect", "padding", "calculateFinderRectWithPadding", "(IIZLandroid/graphics/Rect;I)Landroid/graphics/Rect;", "calculateSquareRect", "(IIZLandroid/graphics/Rect;)Landroid/graphics/Rect;", "Lio/scanbot/sdk/camera/FrameHandler$FrameCroppingMode;", "frameCroppingMode", "finderRect", "imageWidth", "imageHeight", "imageOrientation", "calculateModifiedRect", "(Lio/scanbot/sdk/camera/FrameHandler$FrameCroppingMode;Landroid/graphics/Rect;III)Landroid/graphics/Rect;", "Lio/scanbot/sdk/image/ImageRef;", "frame", "", "frameHandlerName", "", "saveFramesSequence", "(Lio/scanbot/sdk/image/ImageRef;Ljava/lang/String;)V", "sdk-camera_release"}, xi=48)
@SourceDebugExtension(value={"SMAP\nCameraImageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraImageUtils.kt\nio/scanbot/sdk/ui/camera/util/CameraImageUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,415:1\n1#2:416\n17123#3,14:417\n*S KotlinDebug\n*F\n+ 1 CameraImageUtils.kt\nio/scanbot/sdk/ui/camera/util/CameraImageUtils\n*L\n408#1:417,14\n*E\n"})
public final class CameraImageUtils {
    @NotNull
    public static final CameraImageUtils INSTANCE = new CameraImageUtils();

    @JvmStatic
    @Nullable
    public static final byte[] imageToJpegByteArray(@NotNull ImageProxy image) {
        Size size;
        Object object;
        ImageProxy imageProxy = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"image");
        byte[] byArray = null;
        int n = imageProxy.getFormat();
        if (n != 35) {
            Size size2;
            if (n != 256) {
                Log.w((String)"CameraImageUtils", (String)("Unrecognized image format: " + object.getFormat()));
                return byArray;
            }
            INSTANCE.getClass();
            ImageProxy.PlaneProxy[] planeProxyArray = object.getPlanes();
            Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"getPlanes(...)");
            ByteBuffer byteBuffer = planeProxyArray[0].getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
            byteBuffer.rewind();
            byArray = new byte[byteBuffer.capacity()];
            byteBuffer.get(byArray);
            Size size3 = size2;
            ImageProxy imageProxy2 = object;
            int n2 = imageProxy2.getWidth();
            size2 = new Size(n2, imageProxy2.getHeight());
            if (!Intrinsics.areEqual((Object)new Size(object.getCropRect().width(), object.getCropRect().height()), (Object)size3)) {
                return ImageUtils.cropByteArray((byte[])byArray, (Rect)object.getCropRect());
            }
            return byArray;
        }
        ImageProxy imageProxy3 = object;
        INSTANCE.getClass();
        byArray = CameraImageUtils.yuv420888toNv21(imageProxy3);
        n = imageProxy3.getWidth();
        int n3 = imageProxy3.getHeight();
        Size size4 = size;
        ImageProxy imageProxy4 = object;
        int n4 = imageProxy4.getWidth();
        size = new Size(n4, imageProxy4.getHeight());
        object = !Intrinsics.areEqual((Object)new Size(object.getCropRect().width(), object.getCropRect().height()), (Object)size4) ? object.getCropRect() : null;
        return CameraImageUtils.nv21ToJpeg(byArray, n, n3, (Rect)object);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Rational rotate(@NotNull Rational rational, int rotation) {
        void var1_1;
        Rational rational2;
        Intrinsics.checkNotNullParameter((Object)rational2, (String)"rational");
        if (rotation != 90 && var1_1 != 270) {
            return rational2;
        }
        return INSTANCE.inverseRational(rational2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] nv21ToJpeg(@NotNull byte[] nv21, int width, int height, @Nullable Rect cropRect) {
        Rect rect;
        void var2_2;
        void var1_1;
        YuvImage yuvImage;
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage(byArray, 17, (int)var1_1, (int)var2_2, null);
        if (cropRect == null) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect(0, 0, (int)var1_1, (int)var2_2);
        }
        if (yuvImage2.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream2)) {
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            return byArray2;
        }
        throw new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
    }

    @JvmStatic
    @NotNull
    public static final byte[] bitmapToNv21(@NotNull Bitmap src, int width, int height) {
        int n;
        Object object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"src");
        if (NumbersKt.isEven((int)width) && NumbersKt.isEven((int)n)) {
            int n2;
            if (object.getWidth() >= n2 && object.getHeight() >= n) {
                void var3_3 = n2 * n;
                Bitmap bitmap = object;
                int[] nArray = new int[var3_3];
                object = nArray;
                bitmap.getPixels(nArray, 0, n2, 0, 0, n2, n);
                INSTANCE.getClass();
                int n3 = 0;
                int n4 = 0;
                void var6_6 = var3_3 * 3 / 2;
                byte[] byArray = new byte[var6_6];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        Bitmap bitmap2 = object[n4];
                        int n5 = (bitmap2 & 0xFF0000) >> 16;
                        int n6 = (bitmap2 & 0xFF00) >> 8;
                        int n7 = bitmap2 & 0xFF;
                        int n8 = n5 * 66;
                        n8 = n6 * 129 + n8;
                        n8 = (n7 * 25 + n8 + 128 >> 8) + 16;
                        int n9 = n5;
                        n5 = (n9 * 112 - n6 * 94 - n7 * 18 + 128 >> 8) + 128;
                        n6 = n9 * -38 - n6 * 74;
                        n6 = (n7 * 112 + n6 + 128 >> 8) + 128;
                        n7 = n3 + 1;
                        if (n8 < 0) {
                            n8 = 0;
                        } else if (n8 > 255) {
                            n8 = 255;
                        }
                        byArray[n3] = (byte)n8;
                        if (i % 2 == 0 && n4 % 2 == 0 && var3_3 < var6_6 - 2) {
                            n3 = var3_3 + true;
                            if (n6 < 0) {
                                n6 = 0;
                            } else if (n6 > 255) {
                                n6 = 255;
                            }
                            byArray[var3_3] = (byte)n6;
                            var3_3 += 2;
                            if (n5 < 0) {
                                n5 = 0;
                            } else if (n5 > 255) {
                                n5 = 255;
                            }
                            byArray[n3] = (byte)n5;
                        }
                        n3 = n4 + 1;
                        int n10 = n3;
                        n3 = n7;
                        n4 = n10;
                    }
                }
                return byArray;
            }
            throw new CodecFailedException("Invalid source Bitmap image!");
        }
        throw new IllegalStateException("bitmapToNv21 needs even width and height of image!");
    }

    @JvmStatic
    @NotNull
    public static final byte[] yuv420888toNv21(@NotNull ImageProxy image) {
        int n;
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        ImageProxy.PlaneProxy planeProxy = imageProxy2.getPlanes()[0];
        ImageProxy imageProxy3 = imageProxy;
        ImageProxy.PlaneProxy planeProxy2 = imageProxy3.getPlanes()[1];
        ImageProxy.PlaneProxy planeProxy3 = imageProxy3.getPlanes()[2];
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
        ByteBuffer byteBuffer2 = planeProxy2.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"getBuffer(...)");
        ByteBuffer byteBuffer3 = planeProxy3.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"getBuffer(...)");
        byteBuffer.rewind();
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        int n4 = imageProxy2.getWidth();
        byte[] byArray = new byte[imageProxy2.getHeight() * n4 / 2 + n2];
        int n5 = imageProxy2.getHeight();
        for (int i = 0; i < n5; ++i) {
            byteBuffer.get(byArray, n3, imageProxy.getWidth());
            n3 = imageProxy.getWidth() + n3;
            n = byteBuffer.position() - imageProxy.getWidth();
            byteBuffer.position(Math.min(n2, planeProxy.getRowStride() + n));
        }
        ImageProxy imageProxy4 = imageProxy;
        int n6 = imageProxy4.getHeight() / 2;
        int n7 = imageProxy4.getWidth() / 2;
        int n8 = planeProxy3.getRowStride();
        n2 = planeProxy2.getRowStride();
        int n9 = planeProxy3.getPixelStride();
        int n10 = planeProxy2.getPixelStride();
        byte[] byArray2 = new byte[n8];
        byte[] byArray3 = new byte[n2];
        for (n = 0; n < n6; ++n) {
            byteBuffer3.get(byArray2, 0, Math.min(n8, byteBuffer3.remaining()));
            byteBuffer2.get(byArray3, 0, Math.min(n2, byteBuffer2.remaining()));
            int n11 = 0;
            int n12 = 0;
            for (int i = 0; i < n7; ++i) {
                int n13 = n3 + 1;
                byArray[n3] = byArray2[n11];
                n3 += 2;
                byArray[n13] = byArray3[n12];
                n11 += n9;
                n12 += n10;
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] nv21ToYuv420888(@NotNull byte[] nv21, int width, int height) {
        void var1_1;
        void var2_2;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        byte[] byArray2 = new byte[(var1_1 *= var2_2) * 3 / 2];
        int n = var1_1 / 2;
        System.arraycopy(nv21, 0, byArray2, 0, (int)var1_1);
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2 + var1_1;
            int n3 = n2 + 1;
            byArray2[n2] = byArray[n3];
            byArray2[n3] = byArray[n2];
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rational inverseRational(@NotNull Rational rational) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)rational, (String)"rational");
        void v0 = var1_2;
        int n = v0.getDenominator();
        return new Rational(n, v0.getNumerator());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rect calculateFinderRectWithPadding(int width, int height, boolean changeOrientation, @NotNull Rect origRect, int padding) {
        int n;
        int n2;
        int n3;
        int n4;
        void var4_5;
        Rect rect = origRect;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"origRect");
        if (rect.width() == var4_5.height()) {
            return var4_5;
        }
        void v1 = var4_5;
        int n5 = v1.left - n4;
        int n6 = v1.top - n4;
        int n7 = v1.right + n4;
        n4 = v1.bottom + n4;
        int n8 = n3 != 0 ? n2 : n;
        if (n3 == 0) {
            n = n2;
        }
        if (n5 >= 0 && n6 >= 0 && n7 <= n8 && n4 <= n) {
            return new Rect(n5, n6, n7, n4);
        }
        n2 = 0;
        n3 = 0;
        int n9 = 0;
        int n10 = 0;
        if (n5 < 0) {
            n2 = Math.abs(n5);
        }
        if (n6 < 0) {
            n3 = Math.abs(n6);
        }
        if (n7 > n8) {
            n10 = n7 - n8;
        }
        if (n4 > n) {
            n9 = n4 - n;
        }
        n5 = n5 + n2 - n10;
        n = n6 + n3 - n9;
        n2 = n7 - n10 + n2;
        n3 = n4 - n9 + n3;
        return new Rect(n5, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rect calculateSquareRect(int width, int height, boolean changeOrientation, @NotNull Rect origRect) {
        int n;
        int n2;
        int n3;
        void var4_5;
        Rect rect = origRect;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"origRect");
        if (rect.width() == var4_5.height()) {
            return var4_5;
        }
        void v1 = var4_5;
        int n4 = RangesKt.coerceAtMost((int)Math.max(v1.height(), var4_5.width()), (int)Math.min(n3, n2)) / 2;
        int n5 = v1.centerX();
        int n6 = v1.centerY();
        int n7 = n6;
        int n8 = n4;
        int n9 = n5;
        int n10 = n4;
        int n11 = n4;
        n4 = n5 - n4;
        n5 = n7 - n11;
        n7 = n9 + n10;
        int n12 = n6 + n8;
        int n13 = n != 0 ? n2 : n3;
        if (n == 0) {
            n3 = n2;
        }
        if (n4 >= 0 && n5 >= 0 && n7 <= n13 && n12 <= n3) {
            return new Rect(n4, n5, n7, n12);
        }
        n2 = 0;
        n = 0;
        int n14 = 0;
        int n15 = 0;
        if (n4 < 0) {
            n2 = Math.abs(n4);
        }
        if (n5 < 0) {
            n = Math.abs(n5);
        }
        if (n7 > n13) {
            n15 = n7 - n13;
        }
        if (n12 > n3) {
            n14 = n12 - n3;
        }
        n4 = n4 + n2 - n15;
        n3 = n5 + n - n14;
        n2 = n7 - n15 + n2;
        n = n12 - n14 + n;
        return new Rect(n4, n3, n2, n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Rect calculateModifiedRect(@NotNull FrameHandler.FrameCroppingMode frameCroppingMode, @NotNull Rect finderRect, int imageWidth, int imageHeight, int imageOrientation) {
        void var4_6;
        void var3_5;
        void var5_7;
        Object object;
        void var2_4;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)n, (String)"frameCroppingMode");
        Intrinsics.checkNotNullParameter((Object)var2_4, (String)"finderRect");
        if (frameCroppingMode instanceof FrameHandler.FrameCroppingMode.CropToFinder) {
            return var2_4;
        }
        if (n instanceof FrameHandler.FrameCroppingMode.CropWithPadding) {
            CameraImageUtils cameraImageUtils = object;
            void v1 = n;
            object = 90;
            n = 270;
            boolean bl = CollectionsKt.listOf((Object[])new Integer[]{object, n}).contains((int)var5_7);
            int n2 = ((FrameHandler.FrameCroppingMode.CropWithPadding)v1).getPadding();
            return cameraImageUtils.calculateFinderRectWithPadding((int)var3_5, (int)var4_6, bl, (Rect)var2_4, n2);
        }
        if (n instanceof FrameHandler.FrameCroppingMode.FullFrame) {
            return null;
        }
        if (n instanceof FrameHandler.FrameCroppingMode.SquareToFrameCropping) {
            Object object2 = object;
            object = 90;
            n = 270;
            return ((CameraImageUtils)object2).calculateSquareRect((int)var3_5, (int)var4_6, CollectionsKt.listOf((Object[])new Integer[]{object, n}).contains((int)var5_7), (Rect)var2_4);
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveFramesSequence(@NotNull ImageRef frame, @NotNull String frameHandlerName) {
        void var2_2;
        Object[] objectArray;
        File file;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)frameHandlerName, (String)"frameHandlerName");
        Object object = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        File file2 = file;
        if (!new File((File)object, "camera_frames").exists()) {
            file2.mkdirs();
        }
        if ((object = (object = ScanbotCameraViewConfigurationProvider.INSTANCE.getCameraViewType()) instanceof CameraViewType.CameraX ? (CameraViewType.CameraX)object : null) == null) {
            CameraViewType.CameraX cameraX;
            object = cameraX;
            cameraX = new CameraViewType.CameraX(null, false, false, false, null, false, 0, 127, null);
        }
        if ((objectArray = file2.listFiles()) != null) {
            if (objectArray.length != object.getSaveDebugFramesSequenceCount()) {
                objectArray = null;
            }
            if (objectArray != null) {
                if (objectArray.length == 0) {
                    object = null;
                } else {
                    object = objectArray[0];
                    int n = ArraysKt.getLastIndex((Object[])objectArray);
                    if (n != 0) {
                        String string = ((File)object).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        Long l = StringsKt.toLongOrNull((String)StringsKt.substringBefore$default((String)string, (String)"_", null, (int)2, null));
                        long l2 = l != null ? l : Long.MAX_VALUE;
                        int n2 = 1;
                        if (1 <= n) {
                            while (true) {
                                Object object2 = objectArray[n2];
                                String string2 = ((File)object2).getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                                Long l3 = StringsKt.toLongOrNull((String)StringsKt.substringBefore$default((String)string2, (String)"_", null, (int)2, null));
                                long l4 = l3 != null ? l3 : Long.MAX_VALUE;
                                if (l2 > l4) {
                                    l2 = l4;
                                    object = object2;
                                }
                                if (n2 == n) break;
                                ++n2;
                            }
                        }
                    }
                }
                if (object != null) {
                    ((File)object).delete();
                }
            }
        }
        var1_1.saveImage(file2 + "/" + System.currentTimeMillis() + "_" + (String)var2_2 + ".png", new SaveImageOptions(0, null, null, 7, null));
    }
}

