/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.security.crypto.EncryptedFile;
import androidx.security.crypto.MasterKey;
import io.scanbot.common.Result;
import io.scanbot.common.ReturnBlockScope;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.image.EncodeImageOptions;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.FileUtilsKt;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010)\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0017H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/scanbot/sdk/persistence/fileio/EncryptedFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "useEncryption", "", "getUseEncryption", "()Z", "mainKey", "Landroidx/security/crypto/MasterKey;", "writeImage", "", "bitmap", "Landroid/graphics/Bitmap;", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "", "destination", "Ljava/io/File;", "image", "Lio/scanbot/sdk/image/ImageRef;", "encodeImageOptions", "Lio/scanbot/sdk/image/EncodeImageOptions;", "readImage", "source", "options", "Landroid/graphics/BitmapFactory$Options;", "sourceUri", "Landroid/net/Uri;", "read", "", "write", "byteArray", "copyRaw", "encryptedSource", "copy", "move", "openFileOutputStream", "Ljava/io/OutputStream;", "destinationFile", "openFileInputStream", "Ljava/io/InputStream;", "sourceFile", "scanbot-sdk-crypto-persistence_release"})
@SourceDebugExtension(value={"SMAP\nEncryptedFileIOProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptedFileIOProcessor.kt\nio/scanbot/sdk/persistence/fileio/EncryptedFileIOProcessor\n+ 2 SourceFile\nio/scanbot/common/ResultKt\n*L\n1#1,156:1\n103#2,11:157\n*S KotlinDebug\n*F\n+ 1 EncryptedFileIOProcessor.kt\nio/scanbot/sdk/persistence/fileio/EncryptedFileIOProcessor\n*L\n51#1:157,11\n*E\n"})
public final class EncryptedFileIOProcessor
implements FileIOProcessor {
    @NotNull
    private final Context context;
    private final boolean useEncryption;
    @NotNull
    private final MasterKey mainKey;

    /*
     * WARNING - void declaration
     */
    public EncryptedFileIOProcessor(@NotNull Context context) {
        void var1_1;
        EncryptedFileIOProcessor encryptedFileIOProcessor = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        encryptedFileIOProcessor.context = var1_1;
        encryptedFileIOProcessor.useEncryption = true;
        MasterKey masterKey = new MasterKey.Builder((Context)var1_1).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"build(...)");
        encryptedFileIOProcessor.mainKey = masterKey;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        ByteArrayOutputStream byteArrayOutputStream;
        void var4_5;
        void var2_3;
        void var1_2;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)var2_3, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var4_5.delete();
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        EncryptedFileIOProcessor encryptedFileIOProcessor = encryptedFileIOProcessor2;
        byteArrayOutputStream2();
        EncryptedFileIOProcessor encryptedFileIOProcessor2 = null;
        try {
            void var3_4;
            var1_2.compress((Bitmap.CompressFormat)var2_3, (int)var3_4, (OutputStream)byteArrayOutputStream2);
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)byteArrayOutputStream2, (Throwable)throwable);
                throw throwable2;
            }
        }
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        encryptedFileIOProcessor.write(byArray, (File)var4_5);
        EncryptedFileIOProcessor encryptedFileIOProcessor3 = encryptedFileIOProcessor2;
        CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)((Object)encryptedFileIOProcessor3));
    }

    /*
     * WARNING - void declaration
     */
    public void writeImage(@NotNull ImageRef image, @NotNull EncodeImageOptions encodeImageOptions, @NotNull File destination) {
        block8: {
            void var3_3;
            void var2_2;
            Object object;
            File file = destination;
            Intrinsics.checkNotNullParameter((Object)object, (String)"image");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"encodeImageOptions");
            Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
            if (file.exists()) {
                var3_3.delete();
            }
            if ((object = object.encodeImage((EncodeImageOptions)var2_2)) instanceof Result.Success) {
                Throwable throwable2;
                Result.Success success;
                new ReturnBlockScope();
                encryptedFileIOProcessor.write((byte[])((Result.Success)object).getData(), (File)var3_3);
                EncryptedFileIOProcessor encryptedFileIOProcessor = success;
                try {
                    try {
                        success = new Result.Success((Object)Unit.INSTANCE);
                        new Result.Success((Object)encryptedFileIOProcessor);
                        return;
                    }
                    catch (Throwable throwable2) {
                    }
                }
                catch (Result.Failure failure) {
                    break block8;
                }
                object = throwable2.getMessage();
                if (object == null) {
                    object = "Unknown error";
                }
                encryptedFileIOProcessor = new Result.UnknownError((String)object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public synchronized Bitmap readImage(@NotNull File source, @Nullable BitmapFactory.Options options) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
        Uri uri = Uri.fromFile((File)v0);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(...)");
        return this.readImage(uri, (BitmapFactory.Options)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public synchronized Bitmap readImage(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (new File(throwable.getPath()).exists()) {
            Bitmap bitmap;
            InputStream inputStream = ((EncryptedFileIOProcessor)((Object)inputStream)).openFileInputStream(new File(throwable.getPath()));
            throwable = null;
            try {
                void var2_2;
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)var2_2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                try {
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable);
            return bitmap;
        }
        throw new SourceFileDoesNotExistException();
    }

    @Nullable
    public synchronized byte[] read(@NotNull File source) {
        File file = source;
        Intrinsics.checkNotNullParameter((Object)file, (String)"source");
        if (file.exists()) {
            byte[] byArray;
            Throwable throwable;
            InputStream inputStream = ((EncryptedFileIOProcessor)((Object)inputStream)).openFileInputStream(new File(((File)((Object)throwable)).getPath()));
            throwable = null;
            try {
                byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                try {
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable);
            return byArray;
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void write(@NotNull byte[] byteArray, @NotNull File destination) {
        void var2_2;
        void var1_1;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var2_2.delete();
        }
        OutputStream outputStream = this.openFileOutputStream((File)var2_2);
        outputStream.write((byte[])var1_1);
        outputStream.flush();
        outputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void copyRaw(@NotNull File encryptedSource, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"encryptedSource");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        if (encryptedSource.exists()) {
            FileUtilsKt.copyToFileAndClose((InputStream)this.openFileInputStream((File)var1_1), (File)var2_2);
            return;
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(@NotNull File source, @NotNull File destination) {
        Throwable throwable622222;
        NoSuchAlgorithmException noSuchAlgorithmException222222;
        Throwable throwable2;
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"source");
        Intrinsics.checkNotNullParameter((Object)throwable2, (String)"destination");
        if (!source.exists()) {
            throw new IOException("Source file does not exist");
        }
        inputStream = ((EncryptedFileIOProcessor)((Object)outputStream)).openFileInputStream((File)((Object)inputStream));
        OutputStream outputStream = ((EncryptedFileIOProcessor)((Object)outputStream)).openFileOutputStream((File)((Object)throwable2));
        throwable2 = null;
        Throwable throwable3 = null;
        {
            catch (NoSuchAlgorithmException noSuchAlgorithmException222222) {}
        }
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
        CloseableKt.closeFinally((Closeable)outputStream, throwable3);
        CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable2);
        return;
        catch (Throwable throwable4) {
            throwable2 = throwable4;
            try {
                throw throwable4;
            }
            catch (Throwable throwable5) {
                try {
                    CloseableKt.closeFinally((Closeable)outputStream, (Throwable)throwable2);
                    throw throwable5;
                }
                catch (Throwable throwable622222) {}
            }
        }
        try {
            throw throwable622222;
        }
        catch (Throwable throwable7) {
            CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable622222);
            throw throwable7;
        }
        LoggerProvider.getLogger().logException((Throwable)noSuchAlgorithmException222222);
    }

    /*
     * WARNING - void declaration
     */
    public void move(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        this.copy((File)var1_1, (File)var2_2);
        source.delete();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public synchronized OutputStream openFileOutputStream(@NotNull File destinationFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        EncryptedFileIOProcessor encryptedFileIOProcessor = encryptedFileIOProcessor2;
        EncryptedFileIOProcessor encryptedFileIOProcessor2 = encryptedFileIOProcessor.context;
        MasterKey masterKey = encryptedFileIOProcessor.mainKey;
        EncryptedFile.FileEncryptionScheme fileEncryptionScheme = EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB;
        EncryptedFile encryptedFile = new EncryptedFile.Builder((Context)encryptedFileIOProcessor2, (File)var1_1, masterKey, fileEncryptionScheme).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"build(...)");
        FileOutputStream fileOutputStream = encryptedFile.openFileOutput();
        Intrinsics.checkNotNullExpressionValue((Object)fileOutputStream, (String)"openFileOutput(...)");
        return fileOutputStream;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public synchronized InputStream openFileInputStream(@NotNull File sourceFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        EncryptedFileIOProcessor encryptedFileIOProcessor = encryptedFileIOProcessor2;
        EncryptedFileIOProcessor encryptedFileIOProcessor2 = encryptedFileIOProcessor.context;
        MasterKey masterKey = encryptedFileIOProcessor.mainKey;
        EncryptedFileIOProcessor encryptedFileIOProcessor3 = encryptedFileIOProcessor2;
        encryptedFileIOProcessor2 = EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB;
        encryptedFileIOProcessor2 = new EncryptedFile.Builder((Context)encryptedFileIOProcessor3, (File)var1_1, masterKey, (EncryptedFile.FileEncryptionScheme)encryptedFileIOProcessor2).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFileIOProcessor2, (String)"build(...)");
        return new BufferedInputStream(encryptedFileIOProcessor2.openFileInput());
    }
}

