/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.arguments;

import androidx.annotation.Keep;
import io.scanbot.sdk.common.ByteArrayJson;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperError;
import io.scanbot.sdk_wrapper.extensions.SBStringExtensionKt;
import io.scanbot.sdk_wrapper.extensions.SBUriExtensionKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk_wrapper/arguments/SBImageInput;", "", "imageFileUri", "", "uniqueId", "buffer", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "imageRef", "Lio/scanbot/sdk/image/ImageRef;", "getImageRef", "()Lio/scanbot/sdk/image/ImageRef;", "imageRef$delegate", "Lkotlin/Lazy;", "barcode-sdk-wrapper_release"})
@Keep
public final class SBImageInput {
    @NotNull
    private final String imageFileUri;
    @NotNull
    private final String uniqueId;
    @NotNull
    private final String buffer;
    @NotNull
    private final transient Lazy imageRef$delegate;

    public SBImageInput(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"imageFileUri");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"buffer");
        this.imageFileUri = string;
        this.uniqueId = string2;
        this.buffer = string3;
        this.imageRef$delegate = LazyKt.lazy(() -> SBImageInput.imageRef_delegate$lambda$0(this));
    }

    public /* synthetic */ SBImageInput(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        this(string, string2, string3);
    }

    private static final ImageRef imageRef_delegate$lambda$0(SBImageInput sBImageInput) {
        if (!StringsKt.isBlank((CharSequence)sBImageInput.uniqueId)) {
            return ImageRef.CREATOR.deserialize(sBImageInput.uniqueId);
        }
        if (!StringsKt.isBlank((CharSequence)sBImageInput.imageFileUri)) {
            return SBUriExtensionKt.toImageRef$default(SBStringExtensionKt.toValidUri(sBImageInput.imageFileUri), null, 1, null);
        }
        if (!StringsKt.isBlank((CharSequence)sBImageInput.buffer)) {
            return ImageRef.CREATOR.fromEncodedBuffer$default((ImageRef.CREATOR)ImageRef.CREATOR, (byte[])ByteArrayJson.INSTANCE.fromBase64(sBImageInput.buffer), null, (int)2, null);
        }
        throw new SBWrapperError.DecodingError("image from source");
    }

    public SBImageInput() {
        this(null, null, null, 7, null);
    }

    @NotNull
    public final ImageRef getImageRef() {
        return (ImageRef)this.imageRef$delegate.getValue();
    }
}

