/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.PerformanceHintManager;
import android.util.Log;
import io.scanbot.common.util.NativeLogger;
import io.scanbot.common.util.PerformanceHintSessionAdapter;
import io.scanbot.common.util.TensorFlowUtils;
import io.scanbot.sap.IScanbotSDKLicenseErrorHandler;
import io.scanbot.sap.SDKLicenseErrorHandler;
import io.scanbot.sdk.Initializable;
import io.scanbot.sdk.SDKLicenseErrorHandlerImpl;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.ScanbotSdkInitializerCommonApi;
import io.scanbot.sdk.SdkInitializer;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.di.SdkStorageModule;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.documentscanner.DocumentScannerConfiguration;
import io.scanbot.sdk.documentscanner.DocumentScannerEngineMode;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.ida;
import io.scanbot.sdk.idm;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.licensing.LicenseInfo;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractorSettings;
import io.scanbot.sdk.persistence.FileStorageSettings;
import io.scanbot.sdk.persistence.fileio.CoreStreamProvider;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.PageStorageSettings;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.util.log.DebugLog;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.log.StubLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 G2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0002GHB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010-\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u00100\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u00101\u001a\u00020 J\u001a\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00062\n\b\u0002\u00104\u001a\u0004\u0018\u000105J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0006J\u0016\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u000e\u00108\u001a\u00020\u00002\u0006\u00101\u001a\u000209J\u0010\u0010:\u001a\u00020;2\u0006\u0010.\u001a\u00020/H\u0016J\b\u0010<\u001a\u00020\u001eH\u0002J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/H\u0002J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010A\u001a\u00020&J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0006H\u0016J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020FR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/SdkInitializer;", "Lio/scanbot/sdk/ScanbotSdkInitializerCommonApi;", "<init>", "()V", "enableNativeLogging", "", "useLog", "getUseLog", "()Z", "setUseLog", "(Z)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "getLogger", "()Lio/scanbot/sdk/util/log/Logger;", "setLogger", "(Lio/scanbot/sdk/util/log/Logger;)V", "license", "", "ocrBlobsPath", "sdkFilesDirectory", "Ljava/io/File;", "prepareOCRLanguagesBlobs", "allowXnnpackAcceleration", "allowGpuAcceleration", "enablePerformanceHintApi", "precompileGpuMlModels", "precompilingGpuMlModelsCallback", "Lkotlin/Function0;", "", "documentScannerEngineMode", "Lio/scanbot/sdk/documentscanner/DocumentScannerEngineMode;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "licenseErrorHandler", "Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;", "documentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "pdfImagesExtractorSettings", "Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "fileStorageSettings", "Lio/scanbot/sdk/persistence/FileStorageSettings;", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "withLogging", "application", "Landroid/app/Application;", "useOcrSettings", "type", "useFileEncryption", "enableFileEncryption", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "enable", "precompilingCallback", "pdfImagesExtractorType", "Lio/scanbot/sdk/pdf/PdfImagesExtractor$Type;", "initialize", "Lio/scanbot/sdk/licensing/LicenseInfo;", "loadNativeLibraries", "prepareBlobs", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "prepareTensorFlow", "extractor", "setPerformanceHintApiEnabled", "enabled", "usePageStorageSettings", "pageStorageSettings", "Lio/scanbot/sdk/persistence/page/PageStorageSettings;", "Companion", "PrepareBlobsTask", "sdk-bundle_release"})
@SourceDebugExtension(value={"SMAP\nScanbotSDKInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotSDKInitializer.kt\nio/scanbot/sdk/ScanbotSDKInitializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n1#2:399\n*E\n"})
public final class ScanbotSDKInitializer
implements SdkInitializer,
ScanbotSdkInitializerCommonApi<ScanbotSDKInitializer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean initialized;
    @NotNull
    private static final ExecutorCoroutineDispatcher singleThreadDispatcher;
    private boolean enableNativeLogging;
    private boolean useLog;
    @Nullable
    private Logger logger;
    @Nullable
    private String license;
    @Nullable
    private String ocrBlobsPath;
    @Nullable
    private File sdkFilesDirectory;
    private boolean prepareOCRLanguagesBlobs;
    private boolean allowXnnpackAcceleration = true;
    private boolean allowGpuAcceleration = true;
    private boolean enablePerformanceHintApi = true;
    private boolean precompileGpuMlModels;
    private Function0<Unit> precompilingGpuMlModelsCallback;
    @NotNull
    private DocumentScannerEngineMode documentScannerEngineMode = DocumentScannerEngineMode.ML;
    @NotNull
    private OcrSettings ocrSettings = new OcrSettings.Builder().build();
    @Nullable
    private IScanbotSDKLicenseErrorHandler licenseErrorHandler;
    @Nullable
    private DocumentDraftExtractor documentDraftExtractor;
    @NotNull
    private PdfImagesExtractorSettings pdfImagesExtractorSettings = new PdfImagesExtractorSettings(PdfImagesExtractor.Type.ANDROID_PDF_WRITER);
    @NotNull
    private FileStorageSettings fileStorageSettings = new FileStorageSettings.Builder().useFileEncryption(false).build();
    @NotNull
    private final CoroutineScope mainScope = CoroutineScopeKt.MainScope();

    public static /* synthetic */ ScanbotSDKInitializer useFileEncryption$default(ScanbotSDKInitializer scanbotSDKInitializer, boolean bl, FileIOProcessor fileIOProcessor, int n, Object object) {
        if ((n & 2) != 0) {
            fileIOProcessor = null;
        }
        return scanbotSDKInitializer.useFileEncryption(bl, fileIOProcessor);
    }

    public static /* synthetic */ ScanbotSDKInitializer precompileGpuMlModels$default(ScanbotSDKInitializer scanbotSDKInitializer, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = ScanbotSDKInitializer::precompileGpuMlModels$lambda$1;
        }
        return scanbotSDKInitializer.precompileGpuMlModels((Function0<Unit>)function0);
    }

    private final void loadNativeLibraries() {
        System.loadLibrary("tflite");
        System.loadLibrary("scanbotsdk");
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareBlobs(ScanbotSDK scanbotSDK) {
        void var1_1;
        ida ida2;
        ida ida3 = ida2;
        ida2 = new ida(this, (ScanbotSDK)var1_1, null);
        BuildersKt.launch$default((CoroutineScope)this.mainScope, (CoroutineContext)singleThreadDispatcher, null, (Function2)ida3, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareTensorFlow(Application application) {
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        boolean bl = scanbotSDKInitializer.allowXnnpackAcceleration;
        TensorFlowUtils.Companion.prepareTensorFlow(bl, scanbotSDKInitializer.allowGpuAcceleration);
        if (this.precompileGpuMlModels) {
            void var1_1;
            idm idm2;
            idm idm3 = idm2;
            idm2 = new idm((Application)var1_1, this, null);
            BuildersKt.launch$default((CoroutineScope)this.mainScope, (CoroutineContext)singleThreadDispatcher, null, (Function2)idm3, (int)2, null);
            return;
        }
    }

    private static final Unit precompileGpuMlModels$lambda$1() {
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static boolean isInitialized() {
        return Companion.isInitialized();
    }

    public static final /* synthetic */ Function0 access$getPrecompilingGpuMlModelsCallback$p(ScanbotSDKInitializer $this) {
        return $this.precompilingGpuMlModelsCallback;
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        singleThreadDispatcher = ExecutorsKt.from((ExecutorService)executorService);
    }

    public final boolean getUseLog() {
        return this.useLog;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUseLog(boolean bl) {
        void var1_1;
        this.useLog = var1_1;
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLogger(@Nullable Logger logger) {
        void var1_1;
        this.logger = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScanbotSDKInitializer withLogging(boolean useLog, boolean enableNativeLogging) {
        void var2_2;
        void var1_1;
        if (useLog) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        ScanbotSDKInitializer scanbotSDKInitializer = scanbotSDKInitializer3;
        scanbotSDKInitializer.useLog = var1_1;
        scanbotSDKInitializer.enableNativeLogging = var2_2;
        if (var1_1 == false) {
            StubLogger stubLogger;
            ScanbotSDKInitializer scanbotSDKInitializer2 = scanbotSDKInitializer3;
            ScanbotSDKInitializer scanbotSDKInitializer3 = stubLogger;
            stubLogger = new StubLogger();
            scanbotSDKInitializer2.logger = scanbotSDKInitializer3;
            return scanbotSDKInitializer2;
        }
        return scanbotSDKInitializer3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer license(@NotNull Application application, @NotNull String license) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"license");
        this.license = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer licenseErrorHandler(@NotNull IScanbotSDKLicenseErrorHandler licenseErrorHandler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"licenseErrorHandler");
        this.licenseErrorHandler = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer ocrBlobsPath(@NotNull Application application, @NotNull String ocrBlobsPath) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"ocrBlobsPath");
        this.ocrBlobsPath = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer prepareOCRLanguagesBlobs(boolean prepareOCRLanguagesBlobs) {
        void var1_1;
        this.prepareOCRLanguagesBlobs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer useOcrSettings(@NotNull OcrSettings ocrSettings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"ocrSettings");
        this.ocrSettings = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer documentScannerEngineMode(@NotNull DocumentScannerEngineMode type) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"type");
        this.documentScannerEngineMode = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer useFileEncryption(boolean enableFileEncryption, @Nullable FileIOProcessor fileIOProcessor) {
        void var1_1;
        FileStorageSettings.Builder builder = new FileStorageSettings.Builder().useFileEncryption((boolean)var1_1);
        if (fileIOProcessor != null) {
            void var2_3;
            builder.useCustomFileIOProcessor((FileIOProcessor)var2_3);
        }
        ScanbotSDKInitializer scanbotSDKInitializer = scanbotSDKInitializer2;
        ScanbotSDKInitializer scanbotSDKInitializer2 = builder.build();
        scanbotSDKInitializer.fileStorageSettings = scanbotSDKInitializer2;
        SdkStorageModule.Companion.setFileStorageSettings((FileStorageSettings)scanbotSDKInitializer2);
        return scanbotSDKInitializer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer allowXnnpackAcceleration(boolean enable) {
        void var1_1;
        this.allowXnnpackAcceleration = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer allowGpuAcceleration(boolean enable) {
        void var1_1;
        this.allowGpuAcceleration = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer precompileGpuMlModels(@NotNull Function0<Unit> precompilingCallback) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"precompilingCallback");
        this.precompilingGpuMlModelsCallback = var1_1;
        this.precompileGpuMlModels = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer pdfImagesExtractorType(@NotNull PdfImagesExtractor.Type type) {
        void var1_1;
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"type");
        scanbotSDKInitializer.pdfImagesExtractorSettings = scanbotSDKInitializer.pdfImagesExtractorSettings.copy((PdfImagesExtractor.Type)var1_1);
        return scanbotSDKInitializer;
    }

    @NotNull
    public LicenseInfo initialize(@NotNull Application application) {
        DocumentScannerConfiguration documentScannerConfiguration;
        ScanbotSDK.Configuration configuration;
        ScanbotSDK scanbotSDK;
        FileIOProcessor fileIOProcessor;
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"application");
        Object object = this_.logger;
        if (object == null) {
            if (this_.useLog) {
                DebugLog debugLog;
                object = debugLog;
                debugLog = new DebugLog((Context)fileIOProcessor);
            } else {
                StubLogger stubLogger;
                object = stubLogger;
                stubLogger = new StubLogger();
            }
        }
        ScanbotSDKInitializer scanbotSDKInitializer = this_;
        LoggerProvider.setLogger((Logger)object);
        scanbotSDKInitializer.loadNativeLibraries();
        object = LoggerProvider.getLogger();
        if (scanbotSDKInitializer.enableNativeLogging) {
            NativeLogger.setNativeLogger((Logger)object);
        }
        ScanbotSDKInitializer scanbotSDKInitializer2 = this_;
        Logger logger = object;
        SapSingleton.initializeSapManager((Context)fileIOProcessor, (String)this_.license);
        SapSingleton.getInstance().setLicenseErrorHandler((SDKLicenseErrorHandler)new SDKLicenseErrorHandlerImpl(this_.licenseErrorHandler, object));
        initialized = true;
        Object object2 = object = scanbotSDK;
        object = configuration;
        ScanbotSDKInitializer scanbotSDKInitializer3 = this_;
        Object object3 = scanbotSDKInitializer3.ocrBlobsPath;
        File file = scanbotSDKInitializer3.sdkFilesDirectory;
        DocumentDraftExtractor documentDraftExtractor = scanbotSDKInitializer3.documentDraftExtractor;
        OcrSettings ocrSettings = scanbotSDKInitializer3.ocrSettings;
        PdfImagesExtractorSettings pdfImagesExtractorSettings = scanbotSDKInitializer3.pdfImagesExtractorSettings;
        String string = object3;
        object3 = documentScannerConfiguration;
        documentScannerConfiguration = new DocumentScannerConfiguration(this_.documentScannerEngineMode, null, null, null, 14, null);
        configuration = new ScanbotSDK.Configuration(string, file, documentDraftExtractor, ocrSettings, pdfImagesExtractorSettings, (DocumentScannerConfiguration)object3);
        object2((Context)fileIOProcessor, (ScanbotSDK.Configuration)object);
        this_.prepareBlobs((ScanbotSDK)object2);
        this_.prepareTensorFlow((Application)fileIOProcessor);
        ScanbotSDKInitializer this_ = scanbotSDK.getLicenseInfo();
        logger.i("ScanbotSDKInitializer", this_.getLicenseStatusMessage());
        if (scanbotSDKInitializer2.enablePerformanceHintApi && Build.VERSION.SDK_INT >= 31) {
            object = PerformanceHintSessionAdapter.Companion;
            object3 = fileIOProcessor.getSystemService("performance_hint");
            object3 = object3 instanceof PerformanceHintManager ? (PerformanceHintManager)object3 : null;
            object.setPerformanceHintManager((PerformanceHintManager)object3);
        }
        if ((fileIOProcessor = new ScanbotSDK((Application)fileIOProcessor).fileIOProcessor()).getUseEncryption()) {
            ImageRef.CREATOR.setStorageCryptingProvider((CoreStreamProvider)fileIOProcessor);
        }
        ImageRef.CREATOR.registerPlatformImageDecoders();
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer documentDraftExtractor(@NotNull DocumentDraftExtractor extractor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"extractor");
        this.documentDraftExtractor = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer sdkFilesDirectory(@NotNull Application application, @NotNull File sdkFilesDirectory) {
        void var2_2;
        void var1_1;
        File file = sdkFilesDirectory;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)file, (String)"sdkFilesDirectory");
        if (!file.exists() && !var2_2.mkdirs()) {
            throw new IOException("Can't create custom SDK files directory, please provide the absolute path by using either the File(getFilesDir(), \"custom_dir/path\") or File(getExternalFilesDir(null), \"custom_dir/path\"");
        }
        this.sdkFilesDirectory = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScanbotSDKInitializer logger(@NotNull Logger logger) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"logger");
        this.logger = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScanbotSDKInitializer setPerformanceHintApiEnabled(boolean enabled) {
        void var1_1;
        this.enablePerformanceHintApi = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer usePageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pageStorageSettings");
        SdkStorageModule.Companion.setPageStorageSettings((PageStorageSettings)var1_1);
        return this;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$Companion;", "Lio/scanbot/sdk/Initializable;", "<init>", "()V", "initialized", "", "singleThreadDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "isInitialized", "sdk-bundle_release"})
    public static final class Companion
    implements Initializable {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        public boolean isInitialized() {
            return initialized;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ.\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\n\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001f\u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0082\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask;", "", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "<init>", "(Lio/scanbot/sdk/ScanbotSDKInitializer;Lio/scanbot/sdk/ScanbotSDK;)V", "getScanbotSDK", "()Lio/scanbot/sdk/ScanbotSDK;", "prepareBlobs", "", "fetchBlobs", "types", "", "Lio/scanbot/sdk/blob/BlobType;", "blobFactory", "Lio/scanbot/sdk/blob/BlobFactory;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "logger", "Lio/scanbot/sdk/util/log/Logger;", "blobs", "", "Lio/scanbot/sdk/entity/Blob;", "cleanupDeprecatedBlobs", "cleanupBlob", "blobLazySafeGetter", "Lkotlin/Function0;", "Ljava/io/File;", "isDirectory", "", "sdk-bundle_release"})
    @SourceDebugExtension(value={"SMAP\nScanbotSDKInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotSDKInitializer.kt\nio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask\n*L\n1#1,398:1\n380#1,16:399\n380#1,16:415\n380#1,16:431\n380#1,16:447\n380#1,16:463\n380#1,16:479\n380#1,16:495\n380#1,16:511\n380#1,16:527\n380#1,16:543\n380#1,16:559\n380#1,16:575\n380#1,16:591\n*S KotlinDebug\n*F\n+ 1 ScanbotSDKInitializer.kt\nio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask\n*L\n363#1:399,16\n364#1:415,16\n365#1:431,16\n366#1:447,16\n367#1:463,16\n368#1:479,16\n369#1:495,16\n370#1:511,16\n371#1:527,16\n372#1:543,16\n373#1:559,16\n374#1:575,16\n375#1:591,16\n*E\n"})
    public final class PrepareBlobsTask {
        @NotNull
        private final ScanbotSDK scanbotSDK;
        final /* synthetic */ ScanbotSDKInitializer this$0;

        /*
         * WARNING - void declaration
         */
        public PrepareBlobsTask(@NotNull ScanbotSDKInitializer this$0, ScanbotSDK scanbotSDK) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"scanbotSDK");
            this.this$0 = var1_1;
            this.scanbotSDK = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private final void fetchBlobs(List<? extends BlobType> types, BlobFactory blobFactory, BlobManager blobManager, Logger logger) {
            void var3_3;
            void var4_4;
            ArrayList<Blob> arrayList;
            ArrayList<Blob> arrayList2 = arrayList;
            arrayList = new ArrayList<Blob>();
            for (BlobType blobType : types) {
                try {
                    void var2_2;
                    arrayList2.addAll(var2_2.getBlobsForType(blobType));
                }
                catch (IOException iOException) {
                    var4_4.logException((Throwable)iOException);
                    var4_4.e("PrepareBlobsTask", "Could not fetch " + blobType + " blobs!");
                }
            }
            this.fetchBlobs(arrayList2, (BlobManager)var3_3, (Logger)var4_4);
        }

        /*
         * WARNING - void declaration
         */
        private final void fetchBlobs(Collection<Blob> blobs, BlobManager blobManager, Logger logger) {
            for (Blob blob : blobs) {
                try {
                    void var2_2;
                    var2_2.fetch(blob);
                }
                catch (IOException iOException) {
                    void var3_3;
                    var3_3.logException((Throwable)iOException);
                    var3_3.e("PrepareBlobsTask", "Could not fetch blob! /n Blob local path: " + blob.getLocalPath() + " /n Blob remote path: " + blob.getRemotePath());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void cleanupDeprecatedBlobs(BlobManager blobManager) {
            void var1_1;
            try {
                blobManager.getDocumentDetectorModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getBarcodeBinarizationModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getFilterPredictionModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getBarcodeScanningModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getMrzCascadeFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getMrzTrainedDataFile().delete();
            }
            catch (IOException iOException) {}
            try {
                FilesKt.deleteRecursively((File)var1_1.getIdCardScannerModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                FilesKt.deleteRecursively((File)var1_1.getTextPatternScannerModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                FilesKt.deleteRecursively((File)var1_1.getDcModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                var1_1.getBlurEstimatorModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getCheckDigitPredictionModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getBanksDataFile().delete();
            }
            catch (IOException iOException) {}
            try {
                FilesKt.deleteRecursively((File)var1_1.getImageProcessorModelsFolderFile());
            }
            catch (IOException iOException) {}
        }

        private final void cleanupBlob(Function0<? extends File> blobLazySafeGetter, boolean isDirectory) {
            File file;
            boolean $i$f$cleanupBlob = false;
            try {
                file = (File)blobLazySafeGetter.invoke();
            }
            catch (IOException e) {
                return;
            }
            File blobFile = file;
            try {
                boolean bl = isDirectory ? FilesKt.deleteRecursively((File)blobFile) : blobFile.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @NotNull
        public final ScanbotSDK getScanbotSDK() {
            return this.scanbotSDK;
        }

        public final void prepareBlobs() {
            PrepareBlobsTask prepareBlobsTask = this;
            BlobManager blobManager = prepareBlobsTask.scanbotSDK.createBlobManager();
            BlobFactory blobFactory = prepareBlobsTask.scanbotSDK.createBlobFactory();
            Logger logger = LoggerProvider.getLogger();
            if (prepareBlobsTask.this$0.prepareOCRLanguagesBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object[])new BlobType[]{BlobType.OCR_BLOBS, BlobType.PDF_FONT}), blobFactory, blobManager, logger);
            }
            this.cleanupDeprecatedBlobs(blobManager);
        }
    }
}

