/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.bitmap;

import android.graphics.Bitmap;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/util/bitmap/ImageQualityOptimizer;", "", "<init>", "()V", "optimizeImage", "Landroid/graphics/Bitmap;", "bitmap", "widthInches", "", "heightInches", "maxRequiredDpi", "", "requiredDpi", "PaperFormat", "sdk-bundle_release"})
public final class ImageQualityOptimizer {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap optimizeImage(@NotNull Bitmap bitmap, float widthInches, float heightInches, long maxRequiredDpi) {
        float f;
        float f2;
        void var3_4;
        void var1_2;
        void v0 = var1_2;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"bitmap");
        int n = v0.getHeight();
        int n2 = var1_2.getWidth();
        f2 = Math.round((float)Math.max(n, n2) / Math.max((float)var3_4, f2));
        f2 = (float)maxRequiredDpi / f2;
        if (f >= 1.0f) {
            return var1_2;
        }
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)var1_2, (int)Math.round((float)n2 * f2), (int)Math.round((float)n * f2), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createScaledBitmap(...)");
        return bitmap2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap optimizeImage(@NotNull Bitmap bitmap, long requiredDpi) {
        void var2_3;
        void var1_2;
        void v0 = var1_2;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"bitmap");
        PaperFormat paperFormat = PaperFormat.A4;
        float f = paperFormat.getWidthInches();
        return this.optimizeImage((Bitmap)v0, f, paperFormat.getHeightInches(), (long)var2_3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/util/bitmap/ImageQualityOptimizer$PaperFormat;", "", "widthInches", "", "heightInches", "<init>", "(Ljava/lang/String;IFF)V", "getWidthInches", "()F", "getHeightInches", "A1", "A2", "A3", "A4", "A5", "US_LETTER", "US_LEGAL", "sdk-bundle_release"})
    public static enum PaperFormat {
        A1(23.4f, 33.1f),
        A2(16.5f, 23.4f),
        A3(11.7f, 16.5f),
        A4(8.3f, 11.7f),
        A5(5.8f, 8.3f),
        US_LETTER(8.5f, 11.0f),
        US_LEGAL(8.5f, 14.0f);

        private static final /* synthetic */ EnumEntries $ENTRIES;
        private final float widthInches;
        private final float heightInches;

        /*
         * WARNING - void declaration
         */
        private PaperFormat(float widthInches, float heightInches) {
            void var4_4;
            void var3_3;
            this.widthInches = var3_3;
            this.heightInches = var4_4;
        }

        @NotNull
        public static EnumEntries<PaperFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        public final float getWidthInches() {
            return this.widthInches;
        }

        public final float getHeightInches() {
            return this.heightInches;
        }
    }
}

