/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import android.util.Log;
import com.android.mms.exif.CountedDataInputStream;
import com.android.mms.exif.ExifInterface;
import com.android.mms.exif.ExifInvalidFormatException;
import com.android.mms.exif.ExifTag;
import com.android.mms.exif.JpegHeader;
import com.android.mms.exif.Rational;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;

public class ExifParser {
    private static final boolean LOGV = false;
    private static final String TAG = "ExifParser";
    public static final int EVENT_START_OF_IFD = 0;
    public static final int EVENT_NEW_TAG = 1;
    public static final int EVENT_VALUE_OF_REGISTERED_TAG = 2;
    public static final int EVENT_COMPRESSED_IMAGE = 3;
    public static final int EVENT_UNCOMPRESSED_STRIP = 4;
    public static final int EVENT_END = 5;
    public static final int OPTION_IFD_0 = 1;
    public static final int OPTION_IFD_1 = 2;
    public static final int OPTION_IFD_EXIF = 4;
    public static final int OPTION_IFD_GPS = 8;
    public static final int OPTION_IFD_INTEROPERABILITY = 16;
    public static final int OPTION_THUMBNAIL = 32;
    protected static final int EXIF_HEADER = 1165519206;
    protected static final short EXIF_HEADER_TAIL = 0;
    protected static final short LITTLE_ENDIAN_TAG = 18761;
    protected static final short BIG_ENDIAN_TAG = 19789;
    protected static final short TIFF_HEADER_TAIL = 42;
    protected static final int TAG_SIZE = 12;
    protected static final int OFFSET_SIZE = 2;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    protected static final int DEFAULT_IFD0_OFFSET = 8;
    private static final short TAG_EXIF_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_EXIF_IFD);
    private static final short TAG_GPS_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_GPS_IFD);
    private static final short TAG_INTEROPERABILITY_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_INTEROPERABILITY_IFD);
    private static final short TAG_JPEG_INTERCHANGE_FORMAT = ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT);
    private static final short TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
    private static final short TAG_STRIP_OFFSETS = ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS);
    private static final short TAG_STRIP_BYTE_COUNTS = ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_BYTE_COUNTS);
    private final CountedDataInputStream mTiffStream;
    private final int mOptions;
    private int mIfdStartOffset = 0;
    private int mNumOfTagInIfd = 0;
    private int mIfdType;
    private ExifTag mTag;
    private ImageEvent mImageEvent;
    private int mStripCount;
    private ExifTag mStripSizeTag;
    private ExifTag mJpegSizeTag;
    private boolean mNeedToParseOffsetsInCurrentIfd;
    private boolean mContainExifData = false;
    private int mApp1End;
    private int mOffsetToApp1EndFromSOF = 0;
    private byte[] mDataAboveIfd0;
    private int mIfd0Position;
    private int mTiffStartPosition;
    private final ExifInterface mInterface;
    private final TreeMap<Integer, Object> mCorrespondingEvent;

    private boolean isIfdRequested(int ifdType) {
        switch (ifdType) {
            default: {
                return false;
            }
            case 4: {
                return (this.mOptions & 8) != 0;
            }
            case 3: {
                return (this.mOptions & 0x10) != 0;
            }
            case 2: {
                return (this.mOptions & 4) != 0;
            }
            case 1: {
                return (this.mOptions & 2) != 0;
            }
            case 0: 
        }
        return (this.mOptions & 1) != 0;
    }

    private boolean isThumbnailRequested() {
        return (this.mOptions & 0x20) != 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExifParser(InputStream inputStream, int options, ExifInterface iRef) {
        StringBuilder stringBuilder;
        void var2_3;
        CountedDataInputStream countedDataInputStream;
        void var1_1;
        StringBuilder stringBuilder2;
        TreeMap treeMap;
        TreeMap treeMap2 = treeMap;
        treeMap = new TreeMap();
        ((ExifParser)object).mCorrespondingEvent = treeMap2;
        if (inputStream == null) throw new IOException("Null argument inputStream to ExifParser");
        ((ExifParser)object).mInterface = stringBuilder2;
        ((ExifParser)object).mContainExifData = ((ExifParser)object).seekTiffData((InputStream)var1_1);
        CountedDataInputStream countedDataInputStream2 = countedDataInputStream;
        ((ExifParser)object).mTiffStream = new CountedDataInputStream((InputStream)var1_1);
        ((ExifParser)object).mOptions = var2_3;
        if (!((ExifParser)object).mContainExifData) return;
        ((ExifParser)object).parseTiffHeader();
        long l = countedDataInputStream2.readUnsignedInt();
        if (l <= Integer.MAX_VALUE) {
            int n;
            ((ExifParser)object).mIfd0Position = n = (int)l;
            ((ExifParser)object).mIfdType = 0;
            if (!((ExifParser)object).isIfdRequested(0) && !((ExifParser)object).needToParseOffsetsInCurrentIfd()) return;
            ((ExifParser)object).registerIfd(0, l);
            if (l == 8L) return;
            ExifParser exifParser = object;
            byte[] byArray = new byte[n - 8];
            Object object = byArray;
            exifParser.mDataAboveIfd0 = byArray;
            exifParser.read((byte[])object);
            return;
        }
        stringBuilder2 = stringBuilder;
        stringBuilder2("Invalid offset ");
        throw new ExifInvalidFormatException(stringBuilder.append(l).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static ExifParser parse(InputStream inputStream, int options, ExifInterface iRef) {
        void var2_2;
        void var1_1;
        InputStream inputStream2;
        return new ExifParser(inputStream2, (int)var1_1, (ExifInterface)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ExifParser parse(InputStream inputStream, ExifInterface iRef) {
        void var1_1;
        InputStream inputStream2;
        return new ExifParser(inputStream2, 63, (ExifInterface)var1_1);
    }

    private boolean needToParseOffsetsInCurrentIfd() {
        int n = this.mIfdType;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return false;
                }
                return this.isIfdRequested(3);
            }
            return this.isThumbnailRequested();
        }
        return this.isIfdRequested(2) || this.isIfdRequested(4) || this.isIfdRequested(3) || this.isIfdRequested(1);
        {
        }
    }

    /*
     * WARNING - void declaration
     */
    private void skipTo(int offset) {
        void var1_1;
        this.mTiffStream.skipTo((long)var1_1);
        while (!this.mCorrespondingEvent.isEmpty() && this.mCorrespondingEvent.firstKey() < var1_1) {
            this.mCorrespondingEvent.pollFirstEntry();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerIfd(int ifdType, long offset) {
        void var1_1;
        void var2_2;
        this.mCorrespondingEvent.put((int)var2_2, new IfdEvent((int)var1_1, this.isIfdRequested((int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private void registerCompressedImage(long offset) {
        void var1_1;
        this.mCorrespondingEvent.put((int)var1_1, new ImageEvent(3));
    }

    /*
     * WARNING - void declaration
     */
    private void registerUncompressedStrip(int stripIndex, long offset) {
        void var1_1;
        void var2_2;
        this.mCorrespondingEvent.put((int)var2_2, new ImageEvent(4, (int)var1_1));
    }

    private ExifTag readTag() {
        ExifParser exifParser = this_;
        int n = exifParser.mTiffStream.readShort();
        short s = exifParser.mTiffStream.readShort();
        long l = exifParser.mTiffStream.readUnsignedInt();
        if (l <= Integer.MAX_VALUE) {
            ExifTag exifTag;
            if (!ExifTag.isValidType(s)) {
                ExifParser exifParser2 = this_;
                Short this_ = (short)n;
                Short s2 = s;
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = this_;
                objectArray[1] = s2;
                Log.w((String)TAG, (String)String.format("Tag %04x: Invalid data type %d", objectArray2));
                exifParser2.mTiffStream.skip(4L);
                return null;
            }
            int n2 = (int)l;
            int n3 = ((ExifParser)((Object)this_)).mIfdType;
            boolean bl = n2 != 0;
            ExifTag exifTag2 = exifTag;
            exifTag2((short)n, s, n2, n3, bl);
            n = exifTag2.getDataSize();
            if (n > 4) {
                long l2 = ((ExifParser)((Object)this_)).mTiffStream.readUnsignedInt();
                if (l2 <= Integer.MAX_VALUE) {
                    if (l2 < (long)((ExifParser)((Object)this_)).mIfd0Position && s == 7) {
                        ExifTag exifTag3 = exifTag;
                        byte[] byArray = new byte[n2];
                        System.arraycopy(((ExifParser)((Object)this_)).mDataAboveIfd0, (int)l2 - 8, byArray, 0, n2);
                        exifTag3.setValue(byArray);
                        return exifTag3;
                    }
                    ExifTag exifTag4 = exifTag;
                    exifTag4.setOffset((int)l2);
                    return exifTag4;
                }
                throw new ExifInvalidFormatException("offset is larger then Integer.MAX_VALUE");
            }
            ExifTag exifTag5 = exifTag;
            Short s3 = this_;
            ExifTag exifTag6 = exifTag;
            boolean bl2 = exifTag6.hasDefinedCount();
            exifTag6.setHasDefinedCount(false);
            ((ExifParser)((Object)this_)).readFullTagValue(exifTag6);
            exifTag.setHasDefinedCount(bl2);
            ((ExifParser)((Object)s3)).mTiffStream.skip(4 - n);
            exifTag5.setOffset(((ExifParser)((Object)s3)).mTiffStream.getReadByteCount() - 4);
            return exifTag5;
        }
        throw new ExifInvalidFormatException("Number of component is larger then Integer.MAX_VALUE");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void checkOffsetOrImageTag(ExifTag tag) {
        int n;
        void var1_1;
        if (tag.getComponentCount() == 0) {
            return;
        }
        int n2 = var1_1.getTagId();
        int n3 = var1_1.getIfd();
        if (n2 == TAG_EXIF_IFD && this.checkAllowed(n3, n = ExifInterface.TAG_EXIF_IFD)) {
            if (!this.isIfdRequested(2)) {
                if (!this.isIfdRequested(3)) return;
            }
            long l = var1_1.getValueAt(0);
            this.registerIfd(2, l);
            return;
        }
        if (n2 == TAG_GPS_IFD && this.checkAllowed(n3, n = ExifInterface.TAG_GPS_IFD)) {
            if (!this.isIfdRequested(4)) return;
            long l = var1_1.getValueAt(0);
            this.registerIfd(4, l);
            return;
        }
        if (n2 == TAG_INTEROPERABILITY_IFD && this.checkAllowed(n3, n = ExifInterface.TAG_INTEROPERABILITY_IFD)) {
            if (!this.isIfdRequested(3)) return;
            long l = var1_1.getValueAt(0);
            this.registerIfd(3, l);
            return;
        }
        if (n2 == TAG_JPEG_INTERCHANGE_FORMAT && this.checkAllowed(n3, n = ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT)) {
            if (!this.isThumbnailRequested()) return;
            long l = var1_1.getValueAt(0);
            this.registerCompressedImage(l);
            return;
        }
        if (n2 == TAG_JPEG_INTERCHANGE_FORMAT_LENGTH && this.checkAllowed(n3, n = ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH)) {
            if (!this.isThumbnailRequested()) return;
            this.mJpegSizeTag = var1_1;
            return;
        }
        if (n2 == TAG_STRIP_OFFSETS && this.checkAllowed(n3, n = ExifInterface.TAG_STRIP_OFFSETS)) {
            if (!this.isThumbnailRequested()) return;
            if (!var1_1.hasValue()) {
                this.mCorrespondingEvent.put(var1_1.getOffset(), new ExifTagEvent((ExifTag)var1_1, false));
                return;
            }
        } else {
            if (n2 != TAG_STRIP_BYTE_COUNTS) return;
            n2 = ExifInterface.TAG_STRIP_BYTE_COUNTS;
            if (!this.checkAllowed(n3, n2)) return;
            if (!this.isThumbnailRequested()) return;
            if (!var1_1.hasValue()) return;
            this.mStripSizeTag = var1_1;
            return;
        }
        n2 = 0;
        while (n2 < var1_1.getComponentCount()) {
            if (var1_1.getDataType() == 3) {
                var3_8 = var1_1.getValueAt(n2);
                this.registerUncompressedStrip(n2, var3_8);
            } else {
                var3_8 = var1_1.getValueAt(n2);
                this.registerUncompressedStrip(n2, var3_8);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkAllowed(int ifd, int tagId) {
        void var1_2;
        void var2_3;
        int n = this.mInterface.getTagInfo().get((int)var2_3);
        if (n == 0) {
            return false;
        }
        return ExifInterface.isIfdAllowed(n, (int)var1_2);
    }

    private void parseTiffHeader() {
        block6: {
            block5: {
                short s;
                block4: {
                    s = this.mTiffStream.readShort();
                    if (18761 != s) break block4;
                    this.mTiffStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                    break block5;
                }
                if (19789 != s) break block6;
                this.mTiffStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            if (this.mTiffStream.readShort() == 42) {
                return;
            }
            throw new ExifInvalidFormatException("Invalid TIFF header");
        }
        throw new ExifInvalidFormatException("Invalid TIFF header");
    }

    /*
     * WARNING - void declaration
     */
    private boolean seekTiffData(InputStream inputStream) {
        void var1_1;
        CountedDataInputStream countedDataInputStream;
        CountedDataInputStream countedDataInputStream2 = countedDataInputStream;
        if (new CountedDataInputStream((InputStream)var1_1).readShort() == -40) {
            int n = countedDataInputStream2.readShort();
            while (n != -39 && !JpegHeader.isSofMarker((short)n)) {
                long l;
                int n2 = n;
                n = countedDataInputStream2.readUnsignedShort();
                if (n2 == -31 && n >= 8) {
                    short s = countedDataInputStream2.readShort();
                    n -= 6;
                    if (countedDataInputStream2.readInt() == 1165519206 && s == 0) {
                        int n3;
                        this.mTiffStartPosition = n3 = countedDataInputStream2.getReadByteCount();
                        this.mApp1End = n;
                        this.mOffsetToApp1EndFromSOF = n3 + n;
                        return true;
                    }
                }
                if (n >= 2 && (l = (long)(n - 2)) == countedDataInputStream2.skip(l)) {
                    n = countedDataInputStream2.readShort();
                    continue;
                }
                Log.w((String)TAG, (String)"Invalid JPEG format.");
                return false;
            }
            return false;
        }
        throw new ExifInvalidFormatException("Invalid JPEG format");
    }

    public int next() {
        int n;
        if (!this.mContainExifData) {
            return 5;
        }
        int n2 = this.mTiffStream.getReadByteCount();
        if (n2 < (n = this.mNumOfTagInIfd * 12 + (this.mIfdStartOffset + 2))) {
            ExifTag exifTag;
            this.mTag = exifTag = this.readTag();
            if (exifTag == null) {
                return this.next();
            }
            if (this.mNeedToParseOffsetsInCurrentIfd) {
                this.checkOffsetOrImageTag(exifTag);
            }
            return 1;
        }
        if (n2 == n) {
            if (this.mIfdType == 0) {
                long l = this.readUnsignedLong();
                if ((this.isIfdRequested(1) || this.isThumbnailRequested()) && l != 0L) {
                    this.registerIfd(1, l);
                }
            } else {
                n2 = 4;
                if (this.mCorrespondingEvent.size() > 0) {
                    n2 = this.mCorrespondingEvent.firstEntry().getKey() - this.mTiffStream.getReadByteCount();
                }
                if (n2 < 4) {
                    Log.w((String)TAG, (String)("Invalid size of link to next IFD: " + n2));
                } else {
                    long l = this.readUnsignedLong();
                    if (l != 0L) {
                        StringBuilder stringBuilder;
                        StringBuilder stringBuilder2 = stringBuilder;
                        stringBuilder2("Invalid link to next IFD: ");
                        Log.w((String)TAG, (String)stringBuilder.append(l).toString());
                    }
                }
            }
        }
        while (this.mCorrespondingEvent.size() != 0) {
            Object object = this.mCorrespondingEvent.pollFirstEntry();
            Object object2 = object.getValue();
            try {
                this.skipTo(object.getKey());
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)("Failed to skip to data at: " + object.getKey() + " for " + object2.getClass().getName() + ", the file may be broken."));
                continue;
            }
            if (object2 instanceof IfdEvent) {
                int n3;
                Map.Entry<Integer, Object> entry = object;
                object = (IfdEvent)object2;
                this.mIfdType = ((IfdEvent)object).ifd;
                this.mNumOfTagInIfd = this.mTiffStream.readUnsignedShort();
                this.mIfdStartOffset = n3 = entry.getKey().intValue();
                if (this.mNumOfTagInIfd * 12 + n3 + 2 > this.mApp1End) {
                    Log.w((String)TAG, (String)("Invalid size of IFD " + this.mIfdType));
                    return 5;
                }
                this.mNeedToParseOffsetsInCurrentIfd = this.needToParseOffsetsInCurrentIfd();
                if (((IfdEvent)object).isRequested) {
                    return 0;
                }
                this.skipRemainingTagsInCurrentIfd();
                continue;
            }
            if (object2 instanceof ImageEvent) {
                this.mImageEvent = (ImageEvent)object2;
                return this.mImageEvent.type;
            }
            object = (ExifTagEvent)object2;
            this.mTag = ((ExifTagEvent)object).tag;
            if (this.mTag.getDataType() != 7) {
                this.readFullTagValue(this.mTag);
                this.checkOffsetOrImageTag(this.mTag);
            }
            if (!((ExifTagEvent)object).isRequested) continue;
            return 2;
        }
        return 5;
    }

    public void skipRemainingTagsInCurrentIfd() {
        ExifParser exifParser = this;
        int n = exifParser.mIfdStartOffset + 2;
        n = exifParser.mNumOfTagInIfd * 12 + n;
        int n2 = exifParser.mTiffStream.getReadByteCount();
        if (n2 <= n) {
            if (this.mNeedToParseOffsetsInCurrentIfd) {
                while (n2 < n) {
                    ExifTag exifTag;
                    this.mTag = exifTag = this.readTag();
                    n2 += 12;
                    if (exifTag == null) continue;
                    this.checkOffsetOrImageTag(exifTag);
                }
            } else {
                this.skipTo(n);
            }
            ExifParser exifParser2 = this;
            long l = exifParser2.readUnsignedLong();
            if (exifParser2.mIfdType == 0 && (this.isIfdRequested(1) || this.isThumbnailRequested()) && l > 0L) {
                this.registerIfd(1, l);
                return;
            }
        }
    }

    public ExifTag getTag() {
        return this.mTag;
    }

    public int getTagCountInCurrentIfd() {
        return this.mNumOfTagInIfd;
    }

    public int getCurrentIfd() {
        return this.mIfdType;
    }

    public int getStripIndex() {
        return this.mImageEvent.stripIndex;
    }

    public int getStripCount() {
        return this.mStripCount;
    }

    public int getStripSize() {
        ExifTag this_ = ((ExifParser)((Object)this_)).mStripSizeTag;
        if (this_ == null) {
            return 0;
        }
        return (int)this_.getValueAt(0);
    }

    public int getCompressedImageSize() {
        ExifTag this_ = ((ExifParser)((Object)this_)).mJpegSizeTag;
        if (this_ == null) {
            return 0;
        }
        return (int)this_.getValueAt(0);
    }

    /*
     * WARNING - void declaration
     */
    public void registerForTagValue(ExifTag tag) {
        if (tag.getOffset() >= this.mTiffStream.getReadByteCount()) {
            void var1_1;
            this.mCorrespondingEvent.put(var1_1.getOffset(), new ExifTagEvent((ExifTag)var1_1, true));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void readFullTagValue(ExifTag tag) {
        void var1_1;
        int n = tag.getDataType();
        if (n == 2 || n == 7 || n == 1) {
            n = var1_1.getComponentCount();
            if (((ExifParser)object).mCorrespondingEvent.size() > 0 && ((ExifParser)object).mCorrespondingEvent.firstEntry().getKey() < ((ExifParser)object).mTiffStream.getReadByteCount() + n) {
                Map.Entry<Integer, Object> entry = ((ExifParser)object).mCorrespondingEvent.firstEntry().getValue();
                if (entry instanceof ImageEvent) {
                    Log.w((String)TAG, (String)("Thumbnail overlaps value for tag: \n" + var1_1.toString()));
                    entry = ((ExifParser)object).mCorrespondingEvent.pollFirstEntry();
                    Log.w((String)TAG, (String)("Invalid thumbnail offset: " + entry.getKey()));
                } else {
                    if (entry instanceof IfdEvent) {
                        Log.w((String)TAG, (String)("Ifd " + ((IfdEvent)((Object)entry)).ifd + " overlaps value for tag: \n" + var1_1.toString()));
                    } else if (entry instanceof ExifTagEvent) {
                        Log.w((String)TAG, (String)("Tag value for tag: \n" + ((ExifTagEvent)((Object)entry)).tag.toString() + " overlaps value for tag: \n" + var1_1.toString()));
                    }
                    int n2 = ((ExifParser)object).mCorrespondingEvent.firstEntry().getKey() - ((ExifParser)object).mTiffStream.getReadByteCount();
                    Log.w((String)TAG, (String)("Invalid size of tag: \n" + var1_1.toString() + " setting count to: " + n2));
                    var1_1.forceSetComponentCount(n2);
                }
            }
        }
        switch (var1_1.getDataType()) {
            default: {
                return;
            }
            case 10: {
                int n3 = var1_1.getComponentCount();
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = ((ExifParser)object).readRational();
                }
                var1_1.setValue(rationalArray);
                return;
            }
            case 9: {
                int n4 = var1_1.getComponentCount();
                int[] nArray = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = ((ExifParser)object).readLong();
                }
                var1_1.setValue(nArray);
                return;
            }
            case 5: {
                int n5 = var1_1.getComponentCount();
                Rational[] rationalArray = new Rational[n5];
                for (int i = 0; i < n5; ++i) {
                    rationalArray[i] = ((ExifParser)object).readUnsignedRational();
                }
                var1_1.setValue(rationalArray);
                return;
            }
            case 4: {
                int n6 = var1_1.getComponentCount();
                long[] lArray = new long[n6];
                for (int i = 0; i < n6; ++i) {
                    long l;
                    lArray[i] = l = ((ExifParser)object).readUnsignedLong();
                }
                var1_1.setValue(lArray);
                return;
            }
            case 3: {
                int n7 = var1_1.getComponentCount();
                int[] nArray = new int[n7];
                for (int i = 0; i < n7; ++i) {
                    nArray[i] = ((ExifParser)object).readUnsignedShort();
                }
                var1_1.setValue(nArray);
                return;
            }
            case 2: {
                var1_1.setValue(((ExifParser)object).readString(var1_1.getComponentCount()));
                return;
            }
            case 1: 
            case 7: 
        }
        ExifParser exifParser = object;
        byte[] byArray = new byte[var1_1.getComponentCount()];
        Object object = byArray;
        exifParser.read(byArray);
        var1_1.setValue((byte[])object);
    }

    public int getOffsetToExifEndFromSOF() {
        return this.mOffsetToApp1EndFromSOF;
    }

    public int getTiffStartPosition() {
        return this.mTiffStartPosition;
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] buffer, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.mTiffStream.read((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] buffer) {
        void var1_1;
        return this.mTiffStream.read((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String readString(int n) {
        void var1_1;
        return this.readString((int)var1_1, US_ASCII);
    }

    /*
     * WARNING - void declaration
     */
    public String readString(int n, Charset charset) {
        if (n > 0) {
            void var2_2;
            void var1_1;
            return this.mTiffStream.readString((int)var1_1, (Charset)var2_2);
        }
        return "";
    }

    public int readUnsignedShort() {
        return this.mTiffStream.readShort() & 0xFFFF;
    }

    public long readUnsignedLong() {
        return (long)this.readLong() & 0xFFFFFFFFL;
    }

    public Rational readUnsignedRational() {
        ExifParser exifParser = this;
        long l = exifParser.readUnsignedLong();
        long l2 = exifParser.readUnsignedLong();
        return new Rational(l, l2);
    }

    public int readLong() {
        return this.mTiffStream.readInt();
    }

    public Rational readRational() {
        ExifParser exifParser = this;
        int n = exifParser.readLong();
        int n2 = exifParser.readLong();
        long l = n;
        long l2 = n2;
        return new Rational(l, l2);
    }

    public ByteOrder getByteOrder() {
        return this.mTiffStream.getByteOrder();
    }

    public static class IfdEvent {
        int ifd;
        boolean isRequested;

        /*
         * WARNING - void declaration
         */
        public IfdEvent(int ifd, boolean isInterestedIfd) {
            void var2_2;
            void var1_1;
            this.ifd = var1_1;
            this.isRequested = var2_2;
        }
    }

    public static class ImageEvent {
        int stripIndex;
        int type;

        /*
         * WARNING - void declaration
         */
        public ImageEvent(int type) {
            void var1_1;
            this.stripIndex = 0;
            this.type = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ImageEvent(int type, int stripIndex) {
            void var2_2;
            void var1_1;
            this.type = var1_1;
            this.stripIndex = var2_2;
        }
    }

    public static class ExifTagEvent {
        ExifTag tag;
        boolean isRequested;

        /*
         * WARNING - void declaration
         */
        public ExifTagEvent(ExifTag tag, boolean isRequireByUser) {
            void var2_2;
            void var1_1;
            this.tag = var1_1;
            this.isRequested = var2_2;
        }
    }
}

