/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.qnac;
import com.commonsware.cwac.camera.qnc;
import com.commonsware.cwac.camera.qnd;
import com.commonsware.cwac.camera.qndl;
import com.commonsware.cwac.camera.qnf;
import com.commonsware.cwac.camera.qnfm;
import com.commonsware.cwac.camera.qng;
import com.commonsware.cwac.camera.qni;
import com.commonsware.cwac.camera.qnj;
import com.commonsware.cwac.camera.qnk;
import com.commonsware.cwac.camera.qnl;
import com.commonsware.cwac.camera.qnm;
import com.commonsware.cwac.camera.qnn;
import com.commonsware.cwac.camera.qnnd;
import com.commonsware.cwac.camera.qno;
import com.commonsware.cwac.camera.qnoo;
import com.commonsware.cwac.camera.qnq;
import com.commonsware.cwac.camera.qnu;
import com.commonsware.cwac.camera.qnui;
import com.commonsware.cwac.camera.qnv;
import com.commonsware.cwac.camera.qnva;
import com.commonsware.cwac.camera.qny;
import java.io.IOException;

public abstract class qnrh
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] qnf;
    public static final Handler qnm;
    protected qnva previewStrategy;
    public Camera.Size qny;
    public Camera qnw = null;
    protected boolean inPreview = false;
    public qny qnv = null;
    public final qni qnd = null;
    public int qng = -1;
    public int qnr = -1;
    public int qnp = -1;
    public MediaRecorder qnq = null;
    public Camera.Parameters qnc = null;
    public boolean qnl = false;
    public boolean qnt = false;
    public qnm qnn;
    public int qna;
    public WindowManager qne;
    public boolean qnh = false;
    public boolean qnj = false;

    public qnrh(Context context) {
        super(context);
        qni qni2;
        qni qni3 = qni2;
        qni2 = new qni(this, context);
        this.qnd = qni3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        qnrh qnrh2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)qnrh2.qnp, (Camera.CameraInfo)cameraInfo2);
        if (qnrh2.qnh && !this.qnj) {
            qnrh qnrh3 = this;
            qnrh3.qnr = qnrh3.qny(qnrh3.qne.getDefaultDisplay().getOrientation());
        } else {
            this.qnr = cameraInfo2.facing == 1 ? (360 - this.qng) % 360 : this.qng;
        }
        if (this.qnr % 90 != 0) {
            this.qnr = 0;
        }
        var1_1.setRotation(this.qnr);
    }

    static {
        HandlerThread handlerThread;
        qnf = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        qnm = new Handler(handlerThread2.getLooper());
    }

    public qny getCameraHost() {
        return this.qnv;
    }

    public void setCameraHost(qny host) {
        qnfm qnfm2;
        qnva qnva2;
        this.qnv = qnva2;
        if (((qnoo)host.getDeviceProfile()).qnw) {
            qndl qndl2;
            qnva2 = qndl2;
            qndl2 = new qndl(this);
            this.previewStrategy = qnva2;
            return;
        }
        qnva2 = qnfm2;
        qnfm2 = new qnfm(this);
        this.previewStrategy = qnva2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.qnw;
        if (camera != null && this.qnc == null) {
            try {
                this.qnc = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.qnc;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        qnm.post((Runnable)new qnn(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        qnm.post((Runnable)new qnj(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        qnm.post((Runnable)new qnf(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.qnw;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.qnc = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.qny();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.qne = (WindowManager)this.getContext().getSystemService("window");
        if (this.qnh && !this.qnj) {
            this.qnd.enable();
        }
        this.qny();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.qnn == null) {
            qnm qnm2;
            object = qnm2;
            qnm2 = new qnm(this, this.getContext());
            this.qnn = object;
        }
        if (this.qnn.canDetectOrientation()) {
            this.qnn.enable();
        }
        if (this.qnh) {
            this.qny();
            if (!this.qnj) {
                this.qnd.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.qnd.qny = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.qnw().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        qnrh qnrh2 = this;
        qnrh2.addView(qnrh2.previewStrategy.qnw());
        qnm.post((Runnable)new qnk(this));
    }

    public void onPause() {
        qnm.post((Runnable)new qnq((qnrh)((Object)object)));
        if (object.previewStrategy.qnw() != null) {
            qnrh qnrh2 = object;
            qnrh2.removeView(qnrh2.previewStrategy.qnw());
        }
        qnrh qnrh3 = object;
        qnrh3.qnd.disable();
        Object object = qnrh3.qnn;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            qnm.post((Runnable)new qno(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.qny;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.qny;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.qny;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.qny;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.qng;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        qnrh qnrh2 = this;
        qnrh2.qnh = true;
        qnrh2.qnj = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        qnrh qnrh2 = this;
        qnrh2.qnh = true;
        qnrh2.qnj = var1_1;
    }

    public void unlockOrientation() {
        this.qnh = false;
        this.qnj = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        qnrh qnrh2 = this;
        qnrh2.qnd.disable();
        qnrh2.post(new qnu(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        qnnd qnnd2;
        qnnd qnnd3 = qnnd2;
        qnnd3(this.getCameraHost());
        qnnd3.qnw = var1_1;
        qnnd2.qnv = var2_2;
        this.takePicture(qnnd2);
    }

    public abstract void takePicture(qnnd var1);

    public boolean isRecording() {
        return this.qnq != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.qng;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.qnw.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.qnw.setParameters(parameters);
            this.stopPreview();
            this.qnw.unlock();
            parameters = mediaRecorder;
            try {
                this.qnq = parameters;
                new MediaRecorder().setCamera(this.qnw);
                this.getCameraHost().configureRecorderAudio(this.qnp, this.qnq);
                this.qnq.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.qnp, this.qnq);
                this.getCameraHost().configureRecorderOutput(this.qnp, this.qnq);
                this.qnq.setOrientationHint(this.qnr);
                this.previewStrategy.qny(this.qnq);
                this.qnq.prepare();
                this.qnq.start();
                return;
            }
            catch (IOException iOException) {
                this.qnq.release();
                this.qnq = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            qnrh qnrh2 = this;
            MediaRecorder mediaRecorder = qnrh2.qnq;
            this.qnq = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            qnrh2.qnw.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.qnt = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.qnc.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        qnm.post((Runnable)new qnv(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public qnac zoomTo(int level) {
        if (this_.qnw != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new qnac(this_.qnw, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.qnw != null && !this.qnl && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.qnw.startFaceDetection();
            this.qnl = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.qnw) != null && this.qnl) {
            camera.stopFaceDetection();
            this.qnl = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        qnm.post((Runnable)new qnd(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        qnm.post((Runnable)new qng(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.qnw;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        qnrh this_ = this_.qnw;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        qnrh qnrh2 = qnui2;
        cameraInfo2();
        Camera.getCameraInfo((int)qnrh2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        qnui qnui2 = qnrh2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return qnui2.qny(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        qnm.post((Runnable)new qnc(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            qnl qnl2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.qnw == null) break block7;
                        try {
                            boolean bl;
                            qnrh qnrh2 = this;
                            parameters = qnrh2.getCameraParameters();
                            if (qnrh2.qny == null) {
                                void var2_3;
                                this.qny = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.qny;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    qnrh qnrh3 = this;
                    qnrh3.setCameraParametersSync(qnrh3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            qnrh qnrh4 = this;
            qnl qnl3 = qnl2;
            qnl2 = new qnl(this);
            qnrh4.post(qnl3);
            qnrh4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.qnw;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void qnw() {
        block3: {
            if (this.qnw == null) break block3;
            try {
                qnrh qnrh2 = this;
                qnrh2.inPreview = false;
                qnrh2.getCameraHost().autoFocusUnavailable();
                qnrh2.qnw.setPreviewCallback(null);
                qnrh2.qnw.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void qny() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.qne.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.qnp, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.qng = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.qnw != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.qnw();
            }
            try {
                this.qnw.setDisplayOrientation(this.qng);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int qny(int n) {
        Camera.CameraInfo cameraInfo;
        qnrh qnrh2 = qnrh3;
        qnrh qnrh3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)qnrh2.qnp, (Camera.CameraInfo)qnrh3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)qnrh3).facing == 1) {
            return (((Camera.CameraInfo)qnrh3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)qnrh3).orientation + n) % 360;
    }
}

