package io.scanbot.tools.utils.kotlin

import java.io.File

/** Ensures that the file exists. If it does not exist, creates all necessary parent directories and the file itself. */
fun File.ensureFile(): File {
   if (exists().not()) {
      parentFile?.mkdirs()
      createNewFile()
   }
   return this
}

/** Ensures that a new file is created. If a file already exists at the path, it is deleted first. */
fun File.ensureNewFile(): File {
   if (exists()) delete()
   else parentFile?.mkdirs()

   createNewFile()
   return this
}

/** Ensures that the directory exists. If it does not exist, creates all necessary parent directories. */
fun File.ensureDir(): File {
   if (exists().not()) mkdirs()
   return this
}

/** Ensures that a new directory is created. If a directory already exists at the path, it is deleted first. */
fun File.ensureNewDir(): File {
   if (exists()) deleteRecursively()
   mkdirs()
   return this
}
