/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.creditcard.CreditCardScanner;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.creditcard.configuration.CreditCardNativeConfiguration;
import io.scanbot.sdk.ui_v2.creditcard.configuration.CreditCardScannerScreenConfiguration;
import io.scanbot.sdk.ui_v2.creditcard.screen.BaseCreditCardViewModel;
import io.scanbot.sdk.ui_v2.di.components.CreditCardCameraComponent;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.modules.CreditCardModule;
import io.scanbot.sdk.ui_v2.di.modules.CreditCardModule_ProvideCreditCardScannerConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.CreditCardModule_ProvideCreditCardViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.CreditCardModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerCreditCardCameraComponent {
    private DaggerCreditCardCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CreditCardModule creditCardModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder creditCardModule(CreditCardModule creditCardModule) {
            this.creditCardModule = (CreditCardModule)Preconditions.checkNotNull((Object)creditCardModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public CreditCardCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.creditCardModule, CreditCardModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new CreditCardCameraComponentImpl(this.creditCardModule, this.viewModelFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class CreditCardCameraComponentImpl
    implements CreditCardCameraComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final CreditCardCameraComponentImpl creditCardCameraComponentImpl = this;
        private Provider<CreditCardScannerScreenConfiguration> provideCreditCardScannerConfiguration$rtu_ui_v2_bundle_releaseProvider;
        private Provider<CreditCardNativeConfiguration> provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider;
        private Provider<CreditCardScanner> creditCardScannerProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<ViewModel> provideCreditCardViewModelProvider;

        private CreditCardCameraComponentImpl(CreditCardModule creditCardModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(creditCardModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(BaseCreditCardViewModel.class, this.provideCreditCardViewModelProvider);
        }

        private ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(CreditCardModule creditCardModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideCreditCardScannerConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)CreditCardModule_ProvideCreditCardScannerConfiguration$rtu_ui_v2_bundle_releaseFactory.create(creditCardModuleParam));
            this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)CreditCardModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory.create(creditCardModuleParam));
            this.creditCardScannerProvider = new CreditCardScannerProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.provideCreditCardViewModelProvider = CreditCardModule_ProvideCreditCardViewModelFactory.create(creditCardModuleParam, this.provideCreditCardScannerConfiguration$rtu_ui_v2_bundle_releaseProvider, this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider, this.creditCardScannerProvider, this.provideBarcodeCameraViewModelProvider, this.provideContextProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class CreditCardScannerProvider
        implements Provider<CreditCardScanner> {
            private final SDKUIComponent sDKUIComponent;

            CreditCardScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public CreditCardScanner get() {
                return (CreditCardScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.creditCardScanner());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

