/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.check.CheckScanner;
import io.scanbot.sdk.ui_v2.check.configuration.CheckNativeConfiguration;
import io.scanbot.sdk.ui_v2.check.configuration.CheckScannerScreenConfiguration;
import io.scanbot.sdk.ui_v2.check.screen.BaseCheckScannerViewModel;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.CheckCameraComponent;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.modules.CheckModule;
import io.scanbot.sdk.ui_v2.di.modules.CheckModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.CheckModule_ProvideScannerConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.CheckModule_ProvideViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerCheckCameraComponent {
    private DaggerCheckCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CheckModule checkModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder checkModule(CheckModule checkModule) {
            this.checkModule = (CheckModule)Preconditions.checkNotNull((Object)checkModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public CheckCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.checkModule, CheckModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new CheckCameraComponentImpl(this.checkModule, this.viewModelFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class CheckCameraComponentImpl
    implements CheckCameraComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final CheckCameraComponentImpl checkCameraComponentImpl = this;
        private Provider<CheckScannerScreenConfiguration> provideScannerConfiguration$rtu_ui_v2_bundle_releaseProvider;
        private Provider<CheckNativeConfiguration> provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider;
        private Provider<CheckScanner> checkScannerProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<ViewModel> provideViewModelProvider;

        private CheckCameraComponentImpl(CheckModule checkModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(checkModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(BaseCheckScannerViewModel.class, this.provideViewModelProvider);
        }

        private ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(CheckModule checkModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideScannerConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)CheckModule_ProvideScannerConfiguration$rtu_ui_v2_bundle_releaseFactory.create(checkModuleParam));
            this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)CheckModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory.create(checkModuleParam));
            this.checkScannerProvider = new CheckScannerProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.provideViewModelProvider = CheckModule_ProvideViewModelFactory.create(checkModuleParam, this.provideScannerConfiguration$rtu_ui_v2_bundle_releaseProvider, this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider, this.checkScannerProvider, this.provideBarcodeCameraViewModelProvider, this.provideContextProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class CheckScannerProvider
        implements Provider<CheckScanner> {
            private final SDKUIComponent sDKUIComponent;

            CheckScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public CheckScanner get() {
                return (CheckScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.checkScanner());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

