/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.document.operations.setup;

import android.app.Application;
import android.net.Uri;
import android.util.Log;
import androidx.core.net.UriKt;
import com.google.gson.Gson;
import io.scanbot.sdk.ScanbotSDKInitializer;
import io.scanbot.sdk.licensing.LicenseInfo;
import io.scanbot.sdk.persistence.CameraImageFormat;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.document.SBDWrapper;
import io.scanbot.sdk_wrapper.document.operations.setup.SBDSdkConfiguration;
import io.scanbot.sdk_wrapper.document.operations.setup.ScanbotSDKInitializerExtensionKt;
import io.scanbot.sdk_wrapper.enums.SBSDKType;
import io.scanbot.sdk_wrapper.extensions.SBJSONExtensionKt;
import io.scanbot.sdk_wrapper.interfaces.SBResultDelegate;
import io.scanbot.sdk_wrapper.utils.SBStorageUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk_wrapper/document/operations/setup/SBDSetupOperations;", "", "<init>", "()V", "initializeSdk", "", "application", "Landroid/app/Application;", "configurationAsJSON", "Lorg/json/JSONObject;", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBResultDelegate;", "(Landroid/app/Application;Lorg/json/JSONObject;Lio/scanbot/sdk_wrapper/interfaces/SBResultDelegate;)Lkotlin/Unit;", "cleanup", "document-sdk-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBDSetupOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBDSetupOperations.kt\nio/scanbot/sdk_wrapper/document/operations/setup/SBDSetupOperations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class SBDSetupOperations {
    @NotNull
    public static final SBDSetupOperations INSTANCE = new SBDSetupOperations();

    private SBDSetupOperations() {
    }

    @JvmStatic
    @Nullable
    public static final Unit initializeSdk(@NotNull Application application, @NotNull JSONObject jSONObject, @NotNull SBResultDelegate sBResultDelegate) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJSON");
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        application = () -> SBDSetupOperations.a(application, jSONObject, sBResultDelegate);
        return (Unit)SBWrapper.INSTANCE.runFunction$document_sdk_wrapper_release((LicenseInfo)null, sBResultDelegate, false, false, application);
    }

    @JvmStatic
    public static final void cleanup(@NotNull SBResultDelegate sBResultDelegate) {
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        LicenseInfo licenseInfo = SBDWrapper.INSTANCE.getLicenseInfoOrReject$document_sdk_wrapper_release(sBResultDelegate);
        if (licenseInfo == null) {
            return;
        }
        LicenseInfo licenseInfo2 = licenseInfo;
        licenseInfo = () -> SBDSetupOperations.a(sBResultDelegate);
        SBWrapper.runFunction$document_sdk_wrapper_release$default(SBWrapper.INSTANCE, licenseInfo2, sBResultDelegate, false, false, (Function0)licenseInfo, 12, null);
    }

    private static final Unit a(Application application, JSONObject object, SBResultDelegate sBResultDelegate) {
        JSONObject jSONObject = object;
        object = SBWrapper.INSTANCE;
        ((SBWrapper)object).setApplication$document_sdk_wrapper_release(application);
        ((SBWrapper)object).setSdkType$document_sdk_wrapper_release(SBSDKType.DS);
        SBDWrapper sBDWrapper = SBDWrapper.INSTANCE;
        Gson gson = sBDWrapper.getGsonBuilder$document_sdk_wrapper_release().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        SBWrapper.gson = gson;
        SBDSdkConfiguration sBDSdkConfiguration = SBJSONExtensionKt.deserialize(jSONObject, SBDSdkConfiguration.class);
        if (sBDSdkConfiguration.getLoggingEnabled()) {
            Log.i((String)((SBWrapper)object).getLoggerTag$document_sdk_wrapper_release(), (String)"Wrapper v8.0.0.1");
        }
        ScanbotSDKInitializer scanbotSDKInitializer = ScanbotSDKInitializerExtensionKt.fromWrapperConfig(new ScanbotSDKInitializer(), sBDSdkConfiguration);
        Uri uri = sBDSdkConfiguration.getStorageBaseDirectoryUri();
        if (uri != null) {
            SBStorageUtils sBStorageUtils = SBStorageUtils.INSTANCE;
            sBStorageUtils.setBaseNativeStorageDirectory$document_sdk_wrapper_release(UriKt.toFile((Uri)uri));
            Uri uri2 = uri.buildUpon().appendPath("scanbot_sdk_wrapper").build();
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"build(...)");
            sBStorageUtils.setBaseWrapperDirectory$document_sdk_wrapper_release(UriKt.toFile((Uri)uri2));
        } else {
            SBStorageUtils sBStorageUtils = SBStorageUtils.INSTANCE;
            sBStorageUtils.setBaseNativeStorageDirectory$document_sdk_wrapper_release(new File(application.getFilesDir(), "scanbot-sdk"));
            sBStorageUtils.setBaseWrapperDirectory$document_sdk_wrapper_release(new File(application.getFilesDir(), "scanbot_sdk_wrapper"));
        }
        application = scanbotSDKInitializer.initialize(application);
        sBDSdkConfiguration = sBDSdkConfiguration.getStorageImageFormat();
        if (sBDSdkConfiguration != null) {
            sBDWrapper.setStorageImageFormat$document_sdk_wrapper_release((CameraImageFormat)sBDSdkConfiguration);
        }
        ((SBWrapper)object).setWrapperInitializationAndSendResult$document_sdk_wrapper_release((LicenseInfo)application, sBResultDelegate);
        return Unit.INSTANCE;
    }

    private static final void b(SBResultDelegate sBResultDelegate) {
        SBDWrapper sBDWrapper;
        SBDWrapper sBDWrapper2;
        SBDWrapper sBDWrapper3;
        try {
            SBDWrapper sBDWrapper4 = SBDWrapper.INSTANCE;
            sBDWrapper3 = sBDWrapper4;
            sBDWrapper2 = sBDWrapper4;
            sBDWrapper = sBDWrapper4;
            sBDWrapper4.getCleaner$document_sdk_wrapper_release().cleanUpSnappedDocumentsData();
        }
        catch (Throwable throwable) {
            SBResultDelegate.Companion.sendFailureOnMainThread$document_sdk_wrapper_release(sBResultDelegate, throwable);
            return;
        }
        sBDWrapper3.getCleaner$document_sdk_wrapper_release().cleanUpAllDraftPagesData();
        sBDWrapper2.getLegacyPageFileStorage$document_sdk_wrapper_release().removeAll();
        SBStorageUtils.INSTANCE.cleanupWrapperStorage$document_sdk_wrapper_release();
        sBDWrapper.getDocumentApi$document_sdk_wrapper_release().deleteAllDocuments().getOrThrow();
        SBResultDelegate.Companion.sendSuccessOnMainThread$document_sdk_wrapper_release(sBResultDelegate);
    }

    private static final Unit a(SBResultDelegate sBResultDelegate) {
        SBWrapper sBWrapper = SBWrapper.INSTANCE;
        LoggerProvider.getLogger().i(sBWrapper.getLoggerTag$document_sdk_wrapper_release(), "Cleaning storage folder ...");
        sBWrapper.getThreadPool$document_sdk_wrapper_release().execute(() -> SBDSetupOperations.b(sBResultDelegate));
        return Unit.INSTANCE;
    }
}

