/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.common.util;

import android.os.Build;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lio/scanbot/common/util/TensorFlowUtils;", "", "<init>", "()V", "Companion", "core-common_release"})
public final class TensorFlowUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> MODELS_WITHOUT_GPU_PROGRAM_CACHING;
    @NotNull
    private static final List<String> MODELS_WITHOUT_GPU_ACCELERATION;
    @NotNull
    private static final List<String> BRANDS_WITHOUT_GPU_ACCELERATION;

    @JvmStatic
    public static final void prepareTensorFlow(boolean allowXnnpackAcceleration, boolean allowGpuAcceleration) {
        Companion.prepareTensorFlow(allowXnnpackAcceleration, allowGpuAcceleration);
    }

    @JvmStatic
    private static final native void allowXnnpackAcceleration(boolean var0);

    @JvmStatic
    private static final native void allowGpuAcceleration(boolean var0);

    @JvmStatic
    private static final native void allowGpuProgramCaching(boolean var0);

    @JvmStatic
    public static final native void precompilePrograms(@NotNull String var0);

    static {
        Object[] objectArray = new String[]{"SAMSUNG_SM-S908", "SAMSUNG_SM-S906", "SAMSUNG_SM-S901"};
        MODELS_WITHOUT_GPU_PROGRAM_CACHING = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"CAT_S52", "BLACKVIEW_BV4900", "REDMI_ANGELICA", "REDMI_ANGELICAN", "REDMI_M2006C3MNG", "REDMI_M2006C3MG", "REDMI_DANDELION", "REDMI_220233L2G", "REDMI_M2006C3LC", "REDMI_M2006C3LG", "REDMI_M2006C3LI", "REDMI_M2006C3LVG", "REDMI_CATTAIL", "REDMI_M2006C3MII", "REDMI_GALAHAD", "REDMI_M2004J19C", "REDMI_M2004J19G", "REDMI_M2010J19SI", "SAMSUNG_SM-G530FZ"};
        MODELS_WITHOUT_GPU_ACCELERATION = CollectionsKt.listOf((Object[])objectArray);
        BRANDS_WITHOUT_GPU_ACCELERATION = CollectionsKt.listOf((Object)"WIKO");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\u0011\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0083 J\u0011\u0010\r\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0083 J\u0011\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0083 J\u0011\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0087 R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/scanbot/common/util/TensorFlowUtils$Companion;", "", "<init>", "()V", "MODELS_WITHOUT_GPU_PROGRAM_CACHING", "", "", "MODELS_WITHOUT_GPU_ACCELERATION", "BRANDS_WITHOUT_GPU_ACCELERATION", "prepareTensorFlow", "", "allowXnnpackAcceleration", "", "allowGpuAcceleration", "getDeviceModelByBrandName", "getDeviceModelName", "getDeviceBrandName", "enable", "allowGpuProgramCaching", "precompilePrograms", "codeCacheDirPath", "core-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void prepareTensorFlow(boolean allowXnnpackAcceleration, boolean allowGpuAcceleration) {
            String deviceBrandModel = this.getDeviceModelByBrandName();
            String deviceBrand = this.getDeviceBrandName();
            if (MODELS_WITHOUT_GPU_PROGRAM_CACHING.contains(deviceBrandModel)) {
                this.allowGpuProgramCaching(false);
            }
            if (BRANDS_WITHOUT_GPU_ACCELERATION.contains(deviceBrand) || MODELS_WITHOUT_GPU_ACCELERATION.contains(deviceBrandModel) || Build.VERSION.SDK_INT <= 22) {
                this.allowGpuAcceleration(false);
            } else {
                this.allowGpuAcceleration(allowGpuAcceleration);
            }
            this.allowXnnpackAcceleration(allowXnnpackAcceleration);
        }

        private final String getDeviceModelByBrandName() {
            return this.getDeviceBrandName() + "_" + this.getDeviceModelName();
        }

        private final String getDeviceModelName() {
            String string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return string2;
        }

        private final String getDeviceBrandName() {
            String string = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return string2;
        }

        @JvmStatic
        private final void allowXnnpackAcceleration(boolean enable) {
            TensorFlowUtils.allowXnnpackAcceleration(enable);
        }

        @JvmStatic
        private final void allowGpuAcceleration(boolean enable) {
            TensorFlowUtils.allowGpuAcceleration(enable);
        }

        @JvmStatic
        private final void allowGpuProgramCaching(boolean enable) {
            TensorFlowUtils.allowGpuProgramCaching(enable);
        }

        @JvmStatic
        public final void precompilePrograms(@NotNull String codeCacheDirPath) {
            TensorFlowUtils.precompilePrograms(codeCacheDirPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

