/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.CallbackInfo;
import com.amazon.identity.auth.device.authorization.ScopesHelper;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.RequestedScope;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;

public class AuthorizationHelper {
    private static final String HOST_TYPE = "host.type";
    private static final String LOG_TAG = AuthorizationHelper.class.getName();
    private static final String HTTPS = "https";
    private TokenVendor mTokenVendor = new TokenVendor();

    public void authorize(final Context context, String packageName, final String clientId, String[] requestedScopes, final boolean isBrowserFlow, final AuthorizationListener listener) throws AuthError {
        if (ThreadUtils.isRunningOnMainThread()) {
            MAPLog.e(LOG_TAG, "authorize started on main thread");
            throw new IllegalStateException("authorize started on main thread");
        }
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(packageName, context);
        String appId = appInfo.getAppFamilyId();
        List<RequestedScope> cachedScopes = this.mTokenVendor.getCachedScopes(null, appId, context);
        List<String> scopeList = this.getCommonScopesForAuthorization(context, requestedScopes, cachedScopes, appId);
        final String[] allScopes = scopeList.toArray(new String[scopeList.size()]);
        Bundle results = Bundle.EMPTY;
        if (cachedScopes == null || cachedScopes.size() == 0) {
            results = this.getResultsFromAuthorizationService(context, appId, clientId, allScopes, listener);
        }
        if (!(results.containsKey("AUTH_ERROR_EXECEPTION") || results.containsKey(AuthzConstants.BUNDLE_KEY.AUTHORIZE.val) || results.containsKey(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val))) {
            ProfileDataSource.getInstance(context).deleteAllRows();
            Handler myHandler = new Handler(Looper.getMainLooper());
            final UUID requestId = UUID.randomUUID();
            MAPLog.pii(LOG_TAG, "Created UUID for request", "uuid=" + requestId);
            myHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (isBrowserFlow) {
                            AuthorizationHelper.this.authorizeWithBrowser(context, context.getPackageName(), clientId, allScopes, requestId, listener);
                        } else {
                            listener.onError(new AuthError("WebView is not allowed for Authorization", AuthError.ERROR_TYPE.ERROR_BAD_PARAM));
                        }
                    }
                    catch (AuthError e) {
                        listener.onError(e);
                    }
                }
            });
        } else {
            results.setClassLoader(context.getClassLoader());
            if (results.containsKey(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val)) {
                listener.onCancel(results);
            } else if (results.containsKey("AUTH_ERROR_EXECEPTION")) {
                listener.onError(AuthError.extractError(results));
            } else {
                DatabaseHelper.clearAuthorizationState(context);
                Bundle bundle = new Bundle();
                bundle.putString(AuthzConstants.BUNDLE_KEY.AUTHORIZE.val, "authorized via service");
                listener.onSuccess(bundle);
            }
        }
    }

    private void authorizeWithBrowser(Context context, String packageName, String clientId, String[] scopes, UUID requestId, AuthorizationListener listener) throws AuthError {
        CallbackInfo callbackInfo = new CallbackInfo(Calendar.getInstance().getTime(), requestId.toString(), clientId, scopes, listener);
        CallbackInfo.addCallbackInfo(callbackInfo);
        String oauth2Url = AuthorizationHelper.getOAuth2Url(context, packageName, clientId, scopes, requestId.toString(), true);
        Intent webBrowserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)oauth2Url));
        webBrowserIntent.setFlags(0x40000000);
        MAPLog.i(LOG_TAG, "Starting External Browser");
        context.startActivity(webBrowserIntent);
    }

    private List<String> getCommonScopesForAuthorization(Context context, String[] requestedScopes, List<RequestedScope> cachedScopes, String appId) {
        List<String> requestedScopesList = Arrays.asList(requestedScopes);
        ArrayList<String> commonScopes = new ArrayList<String>();
        commonScopes.addAll(requestedScopesList);
        if (cachedScopes != null) {
            for (RequestedScope cachedScope : cachedScopes) {
                String cachedScopeName = cachedScope.getScopeValue();
                if (commonScopes.contains(cachedScopeName)) continue;
                commonScopes.add(cachedScopeName);
            }
        }
        return commonScopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle getResultsFromAuthorizationService(Context context, String appId, String clientId, String[] scopes, AuthorizationListener listener) throws AuthError {
        Bundle result = new Bundle();
        try {
            AmazonAuthorizationServiceInterface service = ThirdPartyServiceHelper.getRemoteAndroidService(context);
            if (service != null) {
                Bundle options = null;
                result = service.authorize(options, context.getPackageName(), scopes);
                if (result == null) {
                    Bundle bundle = new Bundle();
                    return bundle;
                }
                result.setClassLoader(context.getClassLoader());
            }
        }
        catch (RemoteException e) {
            ThirdPartyServiceHelper.clearCachedService(context);
            MAPLog.i(LOG_TAG, "RemoteException on authorize. " + e.getMessage());
        }
        finally {
            ThirdPartyServiceHelper.unbind(context);
        }
        return result;
    }

    void doExchange(final Context context, final Bundle response, final AuthorizationListener listener) {
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            @Override
            public void run() {
                if (response != null) {
                    String code = response.getString("code");
                    if (!TextUtils.isEmpty((CharSequence)code)) {
                        String clientId = response.getString("clientId");
                        String redirectUri = response.getString("redirectUri");
                        Object[] resultScopes = response.getStringArray("scope");
                        MAPLog.pii(LOG_TAG, "Params extracted from OAuth2 response", "code=" + code + "clientId=" + clientId + " redirectUri=" + redirectUri + " scopes=" + Arrays.toString(resultScopes));
                        AuthorizationHelper.this.startExchange(context, clientId, redirectUri, code, (String[])resultScopes, listener);
                        return;
                    }
                    listener.onError(new AuthError("Response bundle from Authorization was empty", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE));
                }
                listener.onError(new AuthError("Response bundle from Authorization was null", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE));
            }
        });
    }

    private void startExchange(Context context, String clientId, String redirectUri, String code, String[] scopes, AuthorizationListener listener) {
        if (ThreadUtils.isRunningOnMainThread()) {
            MAPLog.e(LOG_TAG, "code for token exchange started on main thread");
            throw new IllegalStateException("authorize started on main thread");
        }
        MAPLog.i(LOG_TAG, "Inside getToken AsyncTask - Attempting endpoint");
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(context.getPackageName(), context);
        String appId = appInfo.getAppFamilyId();
        try {
            Bundle result = this.mTokenVendor.vendNewTokensFromCode(code, clientId, appId, redirectUri, scopes, context);
            listener.onSuccess(result);
        }
        catch (IOException e) {
            listener.onError(new AuthError("Failed to exchange code for token", e, AuthError.ERROR_TYPE.ERROR_IO));
        }
        catch (AuthError e) {
            MAPLog.e(LOG_TAG, "Failed doing code for token exchange " + e.getMessage());
            listener.onError(e);
        }
    }

    public static String getOAuth2Url(Context context, String packageName, String clientId, String[] scopes, String requestId, boolean doRememberMe) throws AuthError {
        URL url = null;
        String host = AuthorizationHelper.getHost(context, packageName);
        String endPoint = AuthorizationHelper.getEndPoint() + AuthorizationHelper.getQueryString(context, packageName, clientId, scopes, requestId, doRememberMe);
        try {
            url = new URL(HTTPS, host, endPoint);
        }
        catch (MalformedURLException e) {
            throw new AuthError("MalformedURLException", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        MAPLog.pii(LOG_TAG, "Generating OAUTH2 URL", "url=" + url.toString());
        return url.toString();
    }

    private static String getRedirectUri(String packageName) {
        String rediectUri = "amzn://" + packageName;
        MAPLog.pii(LOG_TAG, "Generating Redirect URI", "rediectUri=" + rediectUri);
        return rediectUri;
    }

    private static String getHost(Context context, String packageName) {
        return AuthorizationHelper.getHostType(context, packageName) + ".amazon.com";
    }

    private static String getEndPoint() {
        return "/ap/oa";
    }

    private static String getQueryString(Context context, String packageName, String clientId, String[] scopes, String requestId, boolean doRememberMe) {
        StringBuffer sb = new StringBuffer("?");
        String redirectUri = AuthorizationHelper.getRedirectUri(packageName);
        sb.append(AuthorizationHelper.getUrlEncodedQuery("response_type", "code"));
        sb.append("&");
        sb.append(AuthorizationHelper.getUrlEncodedQuery("redirect_uri", redirectUri));
        sb.append("&");
        sb.append(AuthorizationHelper.getUrlEncodedQuery("client_id", clientId));
        sb.append("&");
        if (doRememberMe) {
            sb.append(AuthorizationHelper.getUrlEncodedQuery("amzn_respectRmrMeAuthState", "1"));
            sb.append("&");
            sb.append(AuthorizationHelper.getUrlEncodedQuery("amzn_showRmrMe", "1"));
            sb.append("&");
            sb.append(AuthorizationHelper.getUrlEncodedQuery("amzn_rmrMeDefaultSelected", "1"));
            sb.append("&");
        }
        sb.append(AuthorizationHelper.getUrlEncodedQuery("state", "clientId=" + clientId + "&" + "redirectUri" + "=" + redirectUri + "&" + "clientRequestId" + "=" + requestId.toString()));
        sb.append("&");
        String scopeString = ScopesHelper.getScopesString(scopes);
        sb.append(AuthorizationHelper.getUrlEncodedQuery("scope", scopeString));
        return sb.toString();
    }

    private static String getUrlEncodedQuery(String name, String value) {
        StringBuilder sb = new StringBuilder(name);
        sb.append("=");
        sb.append(URLEncoder.encode(value));
        return sb.toString();
    }

    private static String getHostType(Context context, String packageName) {
        String hostType = "www";
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(packageName, 128);
            if (appInfo.metaData != null && appInfo.metaData.containsKey(HOST_TYPE)) {
                hostType = appInfo.metaData.getString(HOST_TYPE);
                MAPLog.pii(LOG_TAG, "Host Type", "hostType=" + hostType + " package=" + packageName);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            MAPLog.d(LOG_TAG, "No host type found in package " + packageName);
        }
        return hostType;
    }
}

