/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.InvalidTokenAuthError;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.TokenHelper;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.Profile;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.IOException;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class ProfileHelper {
    private static final String TAG = ProfileHelper.class.getName();
    private static final String PROFILE_SCOPE = "profile";
    private static ServerCommunication mServerCommunication = new ServerCommunication();

    public static void getProfile(final Context context, String packageName, final APIListener listener) {
        String[] profileScope = new String[]{PROFILE_SCOPE};
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        final AppInfo appInfo = appIdentifier.getAppInfo(packageName, context);
        if (appInfo == null) {
            listener.onError(new AuthError("App info is null", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
            return;
        }
        try {
            TokenHelper.getToken(context, packageName, appInfo.getClientId(), profileScope, new APIListener(){

                @Override
                public void onSuccess(Bundle response) {
                    String authzToken = response.getString(AuthzConstants.BUNDLE_KEY.TOKEN.val);
                    if (TextUtils.isEmpty((CharSequence)authzToken)) {
                        ProfileDataSource.getInstance(context).deleteAllRows();
                        MAPLog.e(TAG, "Not authorized for getProfile");
                        listener.onSuccess(ProfileHelper.createResponseBundle(null));
                        return;
                    }
                    Bundle profileBundle = ProfileHelper.getProfileLocal(context, appInfo.getAppFamilyId());
                    if (profileBundle != null) {
                        MAPLog.pii(TAG, "Returning local profile information", profileBundle.toString());
                        listener.onSuccess(ProfileHelper.createResponseBundle(profileBundle));
                        return;
                    }
                    try {
                        JSONObject profileResponse = ProfileHelper.getProfileRemote(context, authzToken);
                        MAPLog.d(TAG, "Returning remote profile information");
                        listener.onSuccess(ProfileHelper.createResponseBundle(ProfileHelper.createProfileBundle(profileResponse)));
                        ProfileHelper.updateProfileLocal(context, appInfo.getAppFamilyId(), profileResponse);
                    }
                    catch (IOException ioe) {
                        MAPLog.e(TAG, ioe.getMessage(), ioe);
                        listener.onError(new AuthError(ioe.getMessage(), AuthError.ERROR_TYPE.ERROR_IO));
                    }
                    catch (InvalidTokenAuthError e) {
                        MAPLog.e(TAG, "Invalid token sent to the server. Cleaning up local state");
                        DatabaseHelper.clearAuthorizationState(context);
                        listener.onError(e);
                    }
                    catch (AuthError ae) {
                        MAPLog.e(TAG, ae.getMessage());
                        listener.onError(ae);
                    }
                    catch (JSONException jsone) {
                        MAPLog.e(TAG, jsone.getMessage(), jsone);
                        listener.onError(new AuthError(jsone.getMessage(), AuthError.ERROR_TYPE.ERROR_JSON));
                    }
                }

                @Override
                public void onError(AuthError e) {
                    listener.onError(e);
                }
            });
        }
        catch (AuthError e) {
            listener.onError(e);
        }
    }

    private static Bundle getProfileLocal(Context context, String appId) {
        MAPLog.d(TAG, "Accessing local profile information");
        ProfileDataSource profileDataSource = ProfileDataSource.getInstance(context);
        Profile profile = profileDataSource.getProfile(appId);
        if (profile == null || profile.hasExpired()) {
            MAPLog.d(TAG, "Local profile information does not exist, or has expired");
            return null;
        }
        try {
            return profile.getDataAsBundle();
        }
        catch (AuthError e) {
            MAPLog.d(TAG, "Local profile information invalid");
            return null;
        }
    }

    private static JSONObject getProfileRemote(Context context, String authzToken) throws IOException, AuthError {
        MAPLog.d(TAG, "Fetching remote profile information");
        return mServerCommunication.getProfile(context, authzToken);
    }

    private static void updateProfileLocal(Context context, String appId, JSONObject profileData) {
        MAPLog.d(TAG, "Updating local profile information");
        ProfileDataSource profileDataSource = ProfileDataSource.getInstance(context);
        profileDataSource.deleteAllRows();
        profileDataSource.insertRow(new Profile(appId, profileData.toString()));
    }

    private static Bundle createProfileBundle(JSONObject profileData) throws JSONException {
        Bundle profileBundle = new Bundle();
        Iterator profileItr = profileData.keys();
        while (profileItr.hasNext()) {
            String profileKey = (String)profileItr.next();
            profileBundle.putString(profileKey, profileData.getString(profileKey));
        }
        MAPLog.pii(TAG, "Profile Information", profileBundle.toString());
        return profileBundle;
    }

    private static Bundle createResponseBundle(Bundle profileBundle) {
        Bundle responseBundle = new Bundle();
        responseBundle.putBundle(AuthzConstants.BUNDLE_KEY.PROFILE.val, profileBundle);
        return responseBundle;
    }

    static void setServerCommunication(ServerCommunication serverCommunication) {
        mServerCommunication = serverCommunication;
    }
}

