/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.text.TextUtils;
import com.amazon.identity.auth.device.utils.MAPLog;

public final class ScopesHelper {
    private static final String LOG_TAG = ScopesHelper.class.getName();
    private static final String SEPARATOR = " ";
    private static final String ESCAPE_LITERAL_REGEX_PLUS = "\\+";

    private ScopesHelper() {
    }

    public static String getScopesString(String[] scopes) {
        return TextUtils.join((CharSequence)SEPARATOR, (Object[])scopes);
    }

    public static String[] getScopesFromString(String scopeString) {
        MAPLog.i(LOG_TAG, "Extracting scope string array from " + scopeString);
        if (scopeString.contains(SEPARATOR)) {
            return TextUtils.split((String)scopeString, (String)SEPARATOR);
        }
        return TextUtils.split((String)scopeString, (String)ESCAPE_LITERAL_REGEX_PLUS);
    }
}

