/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.os.Bundle;
import android.os.IInterface;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.APIKeyDecoder;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.AmazonServiceListener;
import com.amazon.identity.auth.device.authorization.ThirdPartyAuthorizationServiceConnection;
import com.amazon.identity.auth.device.utils.MAPLog;
import com.amazon.identity.auth.device.utils.MAPVersion;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThirdPartyServiceHelper {
    private static final String LOG_TAG = ThirdPartyServiceHelper.class.getName();
    private static final String HOST_TYPE = "host.type";
    static String DEVO_FINGERPRINT = "2e0b46f8d04a06ac187a2eb0429558fe";
    private static String PROD_FINGERPRINT = "97e83c003bded24445aefd4c72dc4b85";
    private static final String BINDING_ERROR_MESSAGE = "Binding to authorization service has timed out!";
    private static final String AUTHORIZATION_SERVICE_INTENT_ACTION_NAME = "com.amazon.identity.auth.device.authorization.MapAuthorizationService";
    private static final long CONNECTION_TIMEOUT = 10L;
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInterface getAuthorizationServiceInstance(Context context) throws AuthError {
        assert (Looper.myLooper() != Looper.getMainLooper());
        MAPLog.d(LOG_TAG, "getAuthorizationServiceInstance");
        Object object = lock;
        synchronized (object) {
            MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
            if (mapServiceInfo != null) {
                ThirdPartyServiceHelper.safeUnbind(context, mapServiceInfo.getConnection(), mapServiceInfo.getServiceIntent());
                boolean bindSuccessful = this.bindHighestVersionedService(context);
                if (bindSuccessful) {
                    return mapServiceInfo.getService();
                }
                HighestVersionedService.setMAPServiceInfo(null);
            }
        }
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent();
        intent.setAction(AUTHORIZATION_SERVICE_INTENT_ACTION_NAME);
        List intentServices = packageManager.queryIntentServices(intent, 0);
        MAPLog.i(LOG_TAG, "Number of services found : " + intentServices.size());
        List<MAPServiceInfo> mapServiceInfoList = this.getAllAuthorizationServices(context, intentServices);
        HighestVersionedService.setMAPServiceInfo(this.findAuthorizationService(mapServiceInfoList));
        if (HighestVersionedService.getMAPServiceInfo() == null) {
            MAPLog.i(LOG_TAG, "Returning no service to use");
            return null;
        }
        this.bindHighestVersionedService(context);
        MAPLog.i(LOG_TAG, "Returning service to use");
        return HighestVersionedService.getMAPServiceInfo().getService();
    }

    List<MAPServiceInfo> getAllAuthorizationServices(Context context, List<ResolveInfo> intentServices) throws AuthError {
        ArrayList<MAPServiceInfo> mapServiceInfoList = new ArrayList<MAPServiceInfo>();
        for (ResolveInfo resolveInfo : intentServices) {
            try {
                MAPLog.i(LOG_TAG, "Verifying signature for pkg=" + resolveInfo.serviceInfo.applicationInfo.packageName);
                PackageInfo pkgSignatureInfo = context.getPackageManager().getPackageInfo(resolveInfo.serviceInfo.applicationInfo.packageName, 64);
                Signature[] signatures = pkgSignatureInfo.signatures;
                if (signatures.length == 1) {
                    if (!this.isDevoFingerprint(context, signatures) && !ThirdPartyServiceHelper.isSameSignatureFingerprint(PROD_FINGERPRINT, signatures[0])) {
                        MAPLog.pii(LOG_TAG, "Security check failure", "Signature is incorrect.");
                        continue;
                    }
                } else {
                    MAPLog.pii(LOG_TAG, "Security count failure", "Signature count (" + signatures.length + ") is incorrect.");
                    continue;
                }
                ComponentName componentName = new ComponentName(resolveInfo.serviceInfo.applicationInfo.packageName, resolveInfo.serviceInfo.name);
                Bundle metaDataBundle = context.getPackageManager().getServiceInfo((ComponentName)componentName, (int)128).metaData;
                if (metaDataBundle == null) continue;
                boolean isPrimary = metaDataBundle.getBoolean("map.primary");
                String version = metaDataBundle.getString("map.version");
                if (TextUtils.isEmpty((CharSequence)version) && !isPrimary) continue;
                MAPVersion mapVersion = isPrimary ? MAPVersion.VERSION_ZERO : new MAPVersion(version);
                ThirdPartyAuthorizationServiceConnection serviceConnection = new ThirdPartyAuthorizationServiceConnection();
                MAPServiceInfo mapServiceInfo = new MAPServiceInfo(mapVersion, null, serviceConnection, isPrimary, resolveInfo, new Intent().setComponent(componentName));
                if (isPrimary) {
                    mapServiceInfoList.clear();
                    mapServiceInfoList.add(mapServiceInfo);
                    break;
                }
                mapServiceInfoList.add(mapServiceInfo);
            }
            catch (PackageManager.NameNotFoundException e1) {
                MAPLog.pii(LOG_TAG, "NameNotFoundException.", "msg=" + e1.getMessage());
            }
        }
        return mapServiceInfoList;
    }

    boolean isDevoFingerprint(Context context, Signature[] signatures) {
        return !ThirdPartyServiceHelper.isProduction(context) && ThirdPartyServiceHelper.isSameSignatureFingerprint(DEVO_FINGERPRINT, signatures[0]);
    }

    static boolean isSameSignatureFingerprint(String fingerprint, Signature signature) {
        try {
            String sigFingerprint = APIKeyDecoder.getSignatureFingerprint("X.509", signature);
            MAPLog.pii(LOG_TAG, "Expected fingerprint", "Fingerprint=" + fingerprint);
            MAPLog.pii(LOG_TAG, "Extracted fingerprint", "Fingerprint=" + sigFingerprint);
            return fingerprint.equals(sigFingerprint);
        }
        catch (CertificateException e) {
            MAPLog.pii(LOG_TAG, "CertificateException getting Fingerprint. ", e.getMessage());
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            MAPLog.pii(LOG_TAG, "NoSuchAlgorithmException getting Fingerprint. ", e.getMessage());
            return false;
        }
        catch (IOException e) {
            MAPLog.pii(LOG_TAG, "IOException getting Fingerprint. ", e.getMessage());
            return false;
        }
    }

    boolean bindHighestVersionedService(Context context) throws AuthError {
        block5: {
            if (HighestVersionedService.isServiceCacheStale()) {
                return false;
            }
            final MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
            ServiceInfo serviceInfo = ((MAPServiceInfo)mapServiceInfo).getResolveInfo().serviceInfo;
            ComponentName componentName = new ComponentName(serviceInfo.applicationInfo.packageName, serviceInfo.name);
            final Intent serviceIntent = new Intent();
            serviceIntent.setComponent(componentName);
            final ThirdPartyAuthorizationServiceConnection serviceConnection = new ThirdPartyAuthorizationServiceConnection();
            final CountDownLatch latch = new CountDownLatch(1);
            serviceConnection.setServiceListener(new AmazonServiceListener(){

                @Override
                public void onBindSuccess(IInterface serviceInterface) {
                    mapServiceInfo.setService(serviceInterface);
                    mapServiceInfo.setConnection(serviceConnection);
                    mapServiceInfo.setServiceIntent(serviceIntent);
                    latch.countDown();
                }

                @Override
                public void onBindError(AuthError authError) {
                    mapServiceInfo.setService(null);
                    mapServiceInfo.setConnection(null);
                    mapServiceInfo.setServiceIntent(null);
                    MAPLog.i(LOG_TAG, "Bind - error");
                    latch.countDown();
                }
            });
            boolean success = context.bindService(serviceIntent, (ServiceConnection)serviceConnection, 1);
            if (success) {
                try {
                    MAPLog.i(LOG_TAG, "Awaiting latch");
                    if (!latch.await(10L, TimeUnit.SECONDS)) {
                        MAPLog.w(LOG_TAG, "Unable to establish bind within timelimit = 10");
                        HighestVersionedService.setMAPServiceInfo(null);
                        throw new AuthError(BINDING_ERROR_MESSAGE, AuthError.ERROR_TYPE.ERROR_THREAD);
                    }
                    break block5;
                }
                catch (InterruptedException e) {
                    MAPLog.pii(LOG_TAG, "InterruptedException", "msg+=" + e.getMessage());
                    HighestVersionedService.setMAPServiceInfo(null);
                    throw new AuthError(BINDING_ERROR_MESSAGE, e, AuthError.ERROR_TYPE.ERROR_THREAD);
                }
            }
            HighestVersionedService.setMAPServiceInfo(null);
            MAPLog.w(LOG_TAG, "Bind Service " + serviceIntent.getComponent().flattenToString() + "unsuccessful");
        }
        return true;
    }

    MAPServiceInfo findAuthorizationService(List<MAPServiceInfo> mapServiceInfoList) {
        MAPLog.i(LOG_TAG, "Number of MAP services to compare = " + mapServiceInfoList.size());
        MAPServiceInfo serviceResult = null;
        for (MAPServiceInfo mapServiceInfo : mapServiceInfoList) {
            if (mapServiceInfo.isPrimary()) {
                MAPLog.i(LOG_TAG, "Returning Primary Service");
                return mapServiceInfo;
            }
            if (serviceResult == null) {
                serviceResult = mapServiceInfo;
                continue;
            }
            if (mapServiceInfo.getMapVersion().compare(serviceResult.getMapVersion()) <= 0) continue;
            serviceResult = mapServiceInfo;
        }
        return serviceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unbind(Context context) {
        Object object = lock;
        synchronized (object) {
            MAPLog.i(LOG_TAG, "Unbinding Highest Versioned Service");
            MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
            if (mapServiceInfo != null && mapServiceInfo.getConnection() != null) {
                ThirdPartyServiceHelper.safeUnbind(context, mapServiceInfo.getConnection(), mapServiceInfo.getServiceIntent());
                mapServiceInfo.setService(null);
                mapServiceInfo.setConnection(null);
                mapServiceInfo.setServiceIntent(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCachedService(Context context) {
        Object object = lock;
        synchronized (object) {
            MAPLog.i(LOG_TAG, "Clearing Highest Versioned Service");
            MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
            if (mapServiceInfo != null) {
                ThirdPartyServiceHelper.safeUnbind(context, mapServiceInfo.getConnection(), mapServiceInfo.getServiceIntent());
                HighestVersionedService.setMAPServiceInfo(null);
            }
        }
    }

    private static void safeUnbind(Context context, ServiceConnection connection, Intent serviceIntent) {
        String packageName = null;
        if (serviceIntent != null) {
            packageName = serviceIntent.getComponent().getPackageName();
        }
        MAPLog.d(LOG_TAG, "Unbinding pkg=" + packageName);
        try {
            if (connection != null) {
                context.unbindService(connection);
            }
        }
        catch (IllegalArgumentException e) {
            Log.w((String)LOG_TAG, (String)String.format("IllegalArgumentException is received during unbinding from %s. Ignored.", packageName));
        }
    }

    public static AmazonAuthorizationServiceInterface getRemoteAndroidService(Context context) throws AuthError {
        ThirdPartyServiceHelper helper = new ThirdPartyServiceHelper();
        MAPLog.i(LOG_TAG, "Inside getRemoteAndroidService AsyncTask - Attempting remote service");
        return (AmazonAuthorizationServiceInterface)helper.getAuthorizationServiceInstance(context);
    }

    static boolean isProduction(Context context) {
        boolean value = false;
        if (context != null) {
            MAPLog.i(LOG_TAG, "Attempting to parse third party info from meta data");
            try {
                ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                if (appInfo.metaData != null) {
                    value = !appInfo.metaData.containsKey(HOST_TYPE);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                MAPLog.pii(LOG_TAG, "NameNotFoundException", "key=host.type  " + e.getMessage());
            }
        }
        return value;
    }

    class MAPServiceInfo {
        private final MAPVersion mMapVersion;
        private IInterface mService;
        private ThirdPartyAuthorizationServiceConnection mConnection;
        private Intent mServiceIntent;
        private final boolean mIsPrimary;
        private final ResolveInfo mResolveInfo;

        public MAPServiceInfo(MAPVersion mapVersion, IInterface service, ThirdPartyAuthorizationServiceConnection connection, boolean isPrimary, ResolveInfo resolveInfo, Intent serviceIntent) {
            this.mMapVersion = mapVersion;
            this.mService = service;
            this.setConnection(connection);
            this.mIsPrimary = isPrimary;
            this.mResolveInfo = resolveInfo;
            this.mServiceIntent = serviceIntent;
        }

        public MAPVersion getMapVersion() {
            return this.mMapVersion;
        }

        public void setService(IInterface service) {
            this.mService = service;
        }

        public IInterface getService() {
            return this.mService;
        }

        public ThirdPartyAuthorizationServiceConnection getConnection() {
            return this.mConnection;
        }

        public boolean isPrimary() {
            return this.mIsPrimary;
        }

        private ResolveInfo getResolveInfo() {
            return this.mResolveInfo;
        }

        private void setConnection(ThirdPartyAuthorizationServiceConnection mConnection) {
            this.mConnection = mConnection;
        }

        public void setServiceIntent(Intent serviceIntent) {
            this.mServiceIntent = serviceIntent;
        }

        public Intent getServiceIntent() {
            return this.mServiceIntent;
        }
    }

    static class HighestVersionedService {
        static MAPServiceInfo mapServiceInfo = null;
        static long serviceDiscoveryTimestamp = 0L;

        HighestVersionedService() {
        }

        public static MAPServiceInfo getMAPServiceInfo() {
            return mapServiceInfo;
        }

        static void setMAPServiceInfo(MAPServiceInfo serviceInfo) {
            mapServiceInfo = serviceInfo;
            serviceDiscoveryTimestamp = serviceInfo == null ? 0L : new Date().getTime();
        }

        static boolean isServiceCacheStale() {
            if (mapServiceInfo == null) {
                return true;
            }
            long now = new Date().getTime();
            return now > serviceDiscoveryTimestamp + 86400000L;
        }
    }

    public static final class TOKEN_KEYS {
        public static final String ACCESS_ATZ_TOKEN = "accessAtzToken";
        public static final String ACCESS_ATZ_EXPIRES_IN = "accessAtzToken.expiries_in";
        public static final String REFRESH_ATZ_TOKEN = "refreshAtzToken";
    }
}

