/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.amazon.identity.auth.device.AccountManagerConstants;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.ProfileHelper;
import com.amazon.identity.auth.device.endpoint.AbstractTokenRequest;
import com.amazon.identity.auth.device.endpoint.ProfileResponse;
import com.amazon.identity.auth.device.endpoint.TokenResponse;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;

public class ProfileRequest
extends AbstractTokenRequest {
    private static final String LOG_TAG = ProfileHelper.class.getName();
    private static final String PROFILE_ENDPOINT = "/user/profile";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final String AUTHORIZATION = "Authorization";
    private static final String API_PREFIX = "api";
    private String mAuthzToken;
    private final Context mContext;
    public static final String API_PREFIX_DEVO = "api.integ";
    public static final String API_PREFIX_PRE_PROD = "api.pre-prod";

    public ProfileRequest(String appName, String appVersion, String libVersion, Bundle options, String authzToken, Context context) {
        super(appName, appVersion, libVersion, options);
        this.mAuthzToken = authzToken;
        this.mContext = context;
    }

    @Override
    protected TokenResponse generateTokenResponse(HttpResponse httpResponse) {
        return new ProfileResponse(httpResponse);
    }

    @Override
    protected void addRequestInfoParameters() throws AuthError {
    }

    @Override
    public String getEndPoint() {
        return PROFILE_ENDPOINT;
    }

    @Override
    public void initializeHeaders() throws AuthError {
        super.initializeHeaders();
        this.addHeader((Header)new BasicHeader(AUTHORIZATION, BEARER_PREFIX + this.mAuthzToken));
    }

    @Override
    public String getDomain() {
        return ".amazon.com";
    }

    @Override
    public String getHost(Bundle options) {
        String prefix = null;
        this.updateAppState();
        switch (DefaultLibraryInfo.getOverrideLibraryState()) {
            case FORCE_DEVO: {
                prefix = API_PREFIX_DEVO;
                break;
            }
            case FORCE_PRE_PROD: {
                prefix = API_PREFIX_PRE_PROD;
                break;
            }
            default: {
                prefix = API_PREFIX;
            }
        }
        String host = prefix + this.getDomain();
        MAPLog.i(LOG_TAG, "host for request: " + host);
        return host;
    }

    @Override
    public HttpRequestBase getRequest() throws AuthError {
        return new HttpGet(this.getRequestUrl());
    }

    @Override
    protected void consumeRequestContent() throws IOException {
    }

    @Override
    protected void updateEntity() throws UnsupportedEncodingException, IOException {
    }

    private void updateAppState() {
        String hostType = this.getHostType(this.mContext, this.mContext.getPackageName());
        if ("development".equalsIgnoreCase(hostType)) {
            DefaultLibraryInfo.setOverrideAppState(AccountManagerConstants.OVERIDE_APP_STATE.FORCE_DEVO);
        } else if ("gamma".equalsIgnoreCase(hostType)) {
            DefaultLibraryInfo.setOverrideAppState(AccountManagerConstants.OVERIDE_APP_STATE.FORCE_PRE_PROD);
        }
    }

    private String getHostType(Context context, String packageName) {
        String hostType = "www";
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(packageName, 128);
            if (appInfo.metaData != null) {
                hostType = appInfo.metaData.getString("host.type");
                MAPLog.d(LOG_TAG, "Host Type " + hostType + " found in package " + packageName);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            MAPLog.d(LOG_TAG, "No host type found in package " + packageName);
        }
        return hostType;
    }
}

