/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.InvalidTokenAuthError;
import com.amazon.identity.auth.device.endpoint.AbstractJSONTokenResponse;
import com.amazon.identity.auth.device.token.Token;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class ProfileResponse
extends AbstractJSONTokenResponse {
    private static final String LOG_TAG = ProfileResponse.class.getName();
    private JSONObject profileResponse;

    @Override
    protected JSONObject extractResponseJSONObject(JSONObject jsonObject) throws JSONException {
        return jsonObject;
    }

    public ProfileResponse(HttpResponse response) {
        super(response);
    }

    @Override
    protected void doParse(JSONObject jResponse) throws IOException, JSONException, AuthError {
        this.profileResponse = jResponse;
    }

    @Override
    public Token createPrimaryToken(String token, long expiresIn) {
        return null;
    }

    public JSONObject getProfileResponse() {
        return this.profileResponse;
    }

    @Override
    protected void handleJSONError(JSONObject jResponse) throws AuthError, JSONException {
        block5: {
            String error = null;
            try {
                error = jResponse.getString("error");
                if (!TextUtils.isEmpty((CharSequence)error)) {
                    String description = jResponse.getString("error_description");
                    if (this.isInsufficientScope(error, description)) {
                        MAPLog.pii(LOG_TAG, "Insufficient scope in token in exchange.", "info=" + jResponse);
                        throw new AuthError("Insufficient Scope. Authorization not valid for the requested scopes", AuthError.ERROR_TYPE.ERROR_INVALID_SCOPE);
                    }
                    if (this.isInvalidToken(error, description)) {
                        MAPLog.pii(LOG_TAG, "Invalid Token in exchange.", "info=" + jResponse);
                        throw new InvalidTokenAuthError("Invalid Token in exchange. " + jResponse);
                    }
                    MAPLog.pii(LOG_TAG, "Server error doing authorization exchange.", "info=" + jResponse);
                    throw new AuthError("Server error doing authorization exchange. " + jResponse, AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
                }
            }
            catch (JSONException e) {
                if (TextUtils.isEmpty((CharSequence)error)) break block5;
                throw new AuthError("Server Error : " + error, AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
            }
        }
    }

    private boolean isInsufficientScope(String error, String description) {
        return "insufficient_scope".equals(error);
    }

    private boolean isInvalidToken(String error, String description) {
        return "invalid_token".equals(error) || "invalid_request".equals(error) && !TextUtils.isEmpty((CharSequence)description) && description.contains("access_token");
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }
}

