/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.SimpleDeviceProfile;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;

public abstract class DeviceProfile {
    private static volatile DeviceProfile SINGLETON = null;

    public abstract boolean useTextureView();

    public abstract boolean portraitFFCFlipped();

    public abstract int getMinPictureHeight();

    public abstract int getMaxPictureHeight();

    public abstract boolean doesZoomActuallyWork(boolean var1);

    public abstract int getDefaultOrientation();

    public abstract boolean useDeviceOrientation();

    public abstract int getPictureDelay();

    public abstract CameraHost.RecordingHint getDefaultRecordingHint();

    public static synchronized DeviceProfile getInstance(Context ctxt) {
        if (SINGLETON == null) {
            int resource;
            SINGLETON = "motorola".equalsIgnoreCase(Build.MANUFACTURER) && "XT890_rtgb".equals(Build.PRODUCT) ? new SimpleDeviceProfile.MotorolaRazrI() : ((resource = DeviceProfile.findResource(ctxt)) != 0 ? new SimpleDeviceProfile().load((XmlPullParser)ctxt.getResources().getXml(resource)) : new SimpleDeviceProfile());
        }
        return SINGLETON;
    }

    private static int findResource(Context ctxt) {
        Resources res = ctxt.getResources();
        StringBuilder buf = new StringBuilder("cwac_camera_profile_");
        buf.append(DeviceProfile.clean(Build.MANUFACTURER));
        int mfrResult = res.getIdentifier(buf.toString(), "xml", ctxt.getPackageName());
        buf.append("_");
        buf.append(DeviceProfile.clean(Build.PRODUCT));
        int result = res.getIdentifier(buf.toString(), "xml", ctxt.getPackageName());
        return result == 0 ? mfrResult : result;
    }

    private static String clean(String input) {
        return input.replaceAll("[\\W]", "_").toLowerCase(Locale.US);
    }

    public boolean isCustomRom() {
        return this.usesTestKeys() || this.isCyanogenMod() || this.isOmni() || this.isAchiDroid() || this.isMIUI() || this.isSlimKat();
    }

    private boolean isCyanogenMod() {
        return System.getProperty("os.version").contains("cyanogenmod") || System.getProperty("os.version").contains("-CM-") || Build.HOST.contains("cyanogenmod") || Build.HOST.contains("-CM-");
    }

    private boolean isOmni() {
        return System.getProperty("os.version").contains("OMNI") || Build.HOST.contains("omnirom");
    }

    private boolean isAchiDroid() {
        return Build.HOST.contains("ArchiDroid");
    }

    private boolean isMIUI() {
        return Build.ID.contains("MIUI") || Build.HOST.contains("miui");
    }

    private boolean isSlimKat() {
        return System.getProperty("os.version").contains("Slim_Kat") || Build.HOST.contains("slimautobuild");
    }

    private boolean usesTestKeys() {
        return Build.FINGERPRINT.contains("test-keys");
    }
}

