/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.hardware.Camera;
import android.media.MediaRecorder;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.commonsware.cwac.camera.CameraView;
import com.commonsware.cwac.camera.PreviewStrategy;
import java.io.IOException;

class SurfacePreviewStrategy
implements PreviewStrategy,
SurfaceHolder.Callback {
    private final CameraView cameraView;
    private SurfaceView preview = null;
    private SurfaceHolder previewHolder = null;

    SurfacePreviewStrategy(CameraView cameraView) {
        this.cameraView = cameraView;
        this.preview = new SurfaceView(cameraView.getContext());
        this.previewHolder = this.preview.getHolder();
        this.previewHolder.setType(3);
        this.previewHolder.addCallback((SurfaceHolder.Callback)this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.cameraView.previewCreated();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.cameraView.initPreview(width, height);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.previewHolder.removeCallback((SurfaceHolder.Callback)this);
        this.cameraView.previewDestroyed();
    }

    @Override
    public void attach(Camera camera) throws IOException {
        camera.setPreviewDisplay(this.previewHolder);
    }

    @Override
    public void attach(MediaRecorder recorder) {
        recorder.setPreviewDisplay(this.previewHolder.getSurface());
    }

    @Override
    public View getWidget() {
        return this.preview;
    }
}

