/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.hardware.Camera;

public final class ZoomTransaction
implements Camera.OnZoomChangeListener {
    private Camera camera;
    private int level;
    private Runnable onComplete = null;
    private Camera.OnZoomChangeListener onChange = null;

    ZoomTransaction(Camera camera, int level) {
        this.camera = camera;
        this.level = level;
    }

    public ZoomTransaction onComplete(Runnable onComplete) {
        this.onComplete = onComplete;
        return this;
    }

    public ZoomTransaction onChange(Camera.OnZoomChangeListener onChange) {
        this.onChange = onChange;
        return this;
    }

    public void go() {
        Camera.Parameters params = this.camera.getParameters();
        if (params.isSmoothZoomSupported()) {
            this.camera.setZoomChangeListener((Camera.OnZoomChangeListener)this);
            this.camera.startSmoothZoom(this.level);
        } else {
            params.setZoom(this.level);
            this.camera.setParameters(params);
            this.onZoomChange(this.level, true, this.camera);
        }
    }

    public void cancel() {
        this.camera.stopSmoothZoom();
    }

    public void onZoomChange(int zoomValue, boolean stopped, Camera camera) {
        if (this.onChange != null) {
            this.onChange.onZoomChange(zoomValue, stopped, camera);
        }
        if (stopped && this.onComplete != null) {
            this.onComplete.run();
        }
    }
}

