/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.evernote.androidsdk.R;
import com.evernote.client.android.BootstrapManager;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.oauth.EvernoteAuthToken;
import com.evernote.client.oauth.YinxiangApi;
import com.evernote.edam.userstore.BootstrapInfo;
import com.evernote.edam.userstore.BootstrapProfile;
import java.io.Serializable;
import java.util.ArrayList;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.EvernoteApi;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class EvernoteOAuthActivity
extends Activity {
    private static final String LOGTAG = "EvernoteOAuthActivity";
    static final String EXTRA_EVERNOTE_SERVICE = "EVERNOTE_HOST";
    static final String EXTRA_CONSUMER_KEY = "CONSUMER_KEY";
    static final String EXTRA_CONSUMER_SECRET = "CONSUMER_SECRET";
    static final String EXTRA_REQUEST_TOKEN = "REQUEST_TOKEN";
    static final String EXTRA_REQUEST_TOKEN_SECRET = "REQUEST_TOKEN_SECRET";
    static final String EXTRA_SUPPORT_APP_LINKED_NOTEBOOKS = "SUPPORT_APP_LINKED_NOTEBOOKS";
    static final String EXTRA_BOOTSTRAP_SELECTED_PROFILE_POS = "BOOTSTRAP_SELECTED_PROFILE_POS";
    static final String EXTRA_BOOTSTRAP_SELECTED_PROFILE = "BOOTSTRAP_SELECTED_PROFILE";
    static final String EXTRA_BOOTSTRAP_SELECTED_PROFILES = "BOOTSTRAP_SELECTED_PROFILES";
    private EvernoteSession.EvernoteService mEvernoteService = null;
    private BootstrapProfile mSelectedBootstrapProfile;
    private int mSelectedBootstrapProfilePos = 0;
    private ArrayList<BootstrapProfile> mBootstrapProfiles = new ArrayList();
    private String mConsumerKey = null;
    private String mConsumerSecret = null;
    private String mRequestToken = null;
    private String mRequestTokenSecret = null;
    private boolean mSupportAppLinkedNotebooks = false;
    private final int DIALOG_PROGRESS = 101;
    private Activity mActivity;
    private WebView mWebView;
    private AsyncTask mBeginAuthSyncTask = null;
    private AsyncTask mCompleteAuthSyncTask = null;
    private WebViewClient mWebViewClient = new WebViewClient(){

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Uri uri = Uri.parse((String)url);
            if (uri.getScheme().equals(EvernoteOAuthActivity.this.getCallbackScheme())) {
                if (EvernoteOAuthActivity.this.mCompleteAuthSyncTask == null) {
                    EvernoteOAuthActivity.this.mCompleteAuthSyncTask = new CompleteAuthAsyncTask().execute(new Uri[]{uri});
                }
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    };
    private WebChromeClient mWebChromeClient = new WebChromeClient(){

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            EvernoteOAuthActivity.this.mActivity.setProgress(newProgress * 1000);
        }
    };

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(2);
        this.setContentView(R.layout.esdk__webview);
        this.mActivity = this;
        this.mWebView = (WebView)this.findViewById(R.id.esdk__webview);
        this.mWebView.setWebViewClient(this.mWebViewClient);
        this.mWebView.setWebChromeClient(this.mWebChromeClient);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        if (savedInstanceState != null) {
            this.mEvernoteService = (EvernoteSession.EvernoteService)savedInstanceState.getParcelable(EXTRA_EVERNOTE_SERVICE);
            this.mConsumerKey = savedInstanceState.getString(EXTRA_CONSUMER_KEY);
            this.mConsumerSecret = savedInstanceState.getString(EXTRA_CONSUMER_SECRET);
            this.mRequestToken = savedInstanceState.getString(EXTRA_REQUEST_TOKEN);
            this.mRequestTokenSecret = savedInstanceState.getString(EXTRA_REQUEST_TOKEN_SECRET);
            this.mSupportAppLinkedNotebooks = savedInstanceState.getBoolean(EXTRA_SUPPORT_APP_LINKED_NOTEBOOKS);
            this.mSelectedBootstrapProfile = (BootstrapProfile)savedInstanceState.getSerializable(EXTRA_BOOTSTRAP_SELECTED_PROFILE);
            this.mSelectedBootstrapProfilePos = savedInstanceState.getInt(EXTRA_BOOTSTRAP_SELECTED_PROFILE_POS);
            this.mBootstrapProfiles = (ArrayList)savedInstanceState.getSerializable(EXTRA_BOOTSTRAP_SELECTED_PROFILES);
            this.mWebView.restoreState(savedInstanceState);
        } else {
            Intent intent = this.getIntent();
            this.mEvernoteService = (EvernoteSession.EvernoteService)intent.getParcelableExtra(EXTRA_EVERNOTE_SERVICE);
            this.mConsumerKey = intent.getStringExtra(EXTRA_CONSUMER_KEY);
            this.mConsumerSecret = intent.getStringExtra(EXTRA_CONSUMER_SECRET);
            this.mSupportAppLinkedNotebooks = intent.getBooleanExtra(EXTRA_SUPPORT_APP_LINKED_NOTEBOOKS, false);
        }
    }

    protected void onResume() {
        super.onResume();
        if (TextUtils.isEmpty((CharSequence)this.mConsumerKey) || TextUtils.isEmpty((CharSequence)this.mConsumerSecret)) {
            this.exit(false);
            return;
        }
        if (this.mSelectedBootstrapProfile == null) {
            this.mBeginAuthSyncTask = new BootstrapAsyncTask().execute(new Void[0]);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putParcelable(EXTRA_EVERNOTE_SERVICE, (Parcelable)this.mEvernoteService);
        outState.putString(EXTRA_CONSUMER_KEY, this.mConsumerKey);
        outState.putString(EXTRA_CONSUMER_SECRET, this.mConsumerSecret);
        outState.putBoolean(EXTRA_SUPPORT_APP_LINKED_NOTEBOOKS, this.mSupportAppLinkedNotebooks);
        outState.putString(EXTRA_REQUEST_TOKEN, this.mRequestToken);
        outState.putString(EXTRA_REQUEST_TOKEN_SECRET, this.mRequestTokenSecret);
        outState.putSerializable(EXTRA_BOOTSTRAP_SELECTED_PROFILE, (Serializable)this.mSelectedBootstrapProfile);
        outState.putInt(EXTRA_BOOTSTRAP_SELECTED_PROFILE_POS, this.mSelectedBootstrapProfilePos);
        outState.putSerializable(EXTRA_BOOTSTRAP_SELECTED_PROFILES, this.mBootstrapProfiles);
        this.mWebView.saveState(outState);
        super.onSaveInstanceState(outState);
    }

    protected Dialog onCreateDialog(int id2) {
        switch (id2) {
            case 101: {
                return new ProgressDialog((Context)this);
            }
        }
        return super.onCreateDialog(id2);
    }

    protected void onPrepareDialog(int id2, Dialog dialog) {
        switch (id2) {
            case 101: {
                ((ProgressDialog)dialog).setIndeterminate(true);
                dialog.setCancelable(false);
                ((ProgressDialog)dialog).setMessage((CharSequence)this.getString(R.string.esdk__loading));
            }
        }
    }

    private String getCallbackScheme() {
        return "en-oauth";
    }

    private OAuthService createService() {
        OAuthService builder = null;
        Class apiClass = null;
        String host = this.mSelectedBootstrapProfile.getSettings().getServiceHost();
        if (host != null && !host.startsWith("http")) {
            host = "https://" + host;
        }
        if (host.equals("https://sandbox.evernote.com")) {
            apiClass = EvernoteApi.Sandbox.class;
        } else if (host.equals("https://www.evernote.com")) {
            apiClass = EvernoteApi.class;
        } else if (host.equals("https://app.yinxiang.com")) {
            apiClass = YinxiangApi.class;
        } else {
            throw new IllegalArgumentException("Unsupported Evernote host: " + host);
        }
        builder = new ServiceBuilder().provider(apiClass).apiKey(this.mConsumerKey).apiSecret(this.mConsumerSecret).callback(this.getCallbackScheme() + "://callback").build();
        return builder;
    }

    private void exit(final boolean success) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)EvernoteOAuthActivity.this.mActivity, (int)(success ? R.string.esdk__evernote_login_successful : R.string.esdk__evernote_login_failed), (int)1).show();
                EvernoteOAuthActivity.this.setResult(success ? -1 : 0);
                EvernoteOAuthActivity.this.finish();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.esdk__oauth, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        MenuItem itemSwitchService = menu2.findItem(R.id.esdk__switch_service);
        if (this.mBootstrapProfiles != null && this.mBootstrapProfiles.size() > 1) {
            if ("Evernote-China".equals(this.mSelectedBootstrapProfile.getName())) {
                itemSwitchService.setTitle((CharSequence)"Evernote International");
            } else {
                itemSwitchService.setTitle((CharSequence)"\u5370\u8c61\u7b14\u8bb0");
            }
            itemSwitchService.setVisible(true);
        } else {
            itemSwitchService.setVisible(false);
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.esdk__switch_service && (this.mBeginAuthSyncTask == null || this.mBeginAuthSyncTask.getStatus() != AsyncTask.Status.RUNNING) && this.mSelectedBootstrapProfile != null && this.mBootstrapProfiles != null) {
            this.mSelectedBootstrapProfilePos = (this.mSelectedBootstrapProfilePos + 1) % this.mBootstrapProfiles.size();
            this.mBootstrapProfiles = null;
            this.mSelectedBootstrapProfile = null;
            this.mBeginAuthSyncTask = new BootstrapAsyncTask().execute(new Void[0]);
        }
        return true;
    }

    private class CompleteAuthAsyncTask
    extends AsyncTask<Uri, Void, EvernoteAuthToken> {
        private CompleteAuthAsyncTask() {
        }

        protected void onPreExecute() {
            EvernoteOAuthActivity.this.showDialog(101);
        }

        protected EvernoteAuthToken doInBackground(Uri ... uris) {
            EvernoteAuthToken authToken = null;
            if (uris == null || uris.length == 0) {
                return null;
            }
            Uri uri = uris[0];
            if (!TextUtils.isEmpty((CharSequence)EvernoteOAuthActivity.this.mRequestToken)) {
                OAuthService service = EvernoteOAuthActivity.this.createService();
                String verifierString = uri.getQueryParameter("oauth_verifier");
                String appLnbString = uri.getQueryParameter("sandbox_lnb");
                boolean isAppLinkedNotebook = "true".equalsIgnoreCase(appLnbString);
                if (TextUtils.isEmpty((CharSequence)verifierString)) {
                    Log.i((String)EvernoteOAuthActivity.LOGTAG, (String)"User did not authorize access");
                } else {
                    Verifier verifier = new Verifier(verifierString);
                    Log.i((String)EvernoteOAuthActivity.LOGTAG, (String)"Retrieving OAuth access token...");
                    try {
                        Token reqToken = new Token(EvernoteOAuthActivity.this.mRequestToken, EvernoteOAuthActivity.this.mRequestTokenSecret);
                        authToken = new EvernoteAuthToken(service.getAccessToken(reqToken, verifier), isAppLinkedNotebook);
                    }
                    catch (Exception ex) {
                        Log.e((String)EvernoteOAuthActivity.LOGTAG, (String)"Failed to obtain OAuth access token", (Throwable)ex);
                    }
                }
            } else {
                Log.d((String)EvernoteOAuthActivity.LOGTAG, (String)"Unable to retrieve OAuth access token, no request token");
            }
            return authToken;
        }

        protected void onPostExecute(EvernoteAuthToken authToken) {
            EvernoteOAuthActivity.this.removeDialog(101);
            if (EvernoteSession.getOpenSession() == null) {
                EvernoteOAuthActivity.this.exit(false);
                return;
            }
            EvernoteOAuthActivity.this.exit(EvernoteSession.getOpenSession().persistAuthenticationToken(EvernoteOAuthActivity.this.getApplicationContext(), authToken, EvernoteOAuthActivity.this.mSelectedBootstrapProfile.getSettings().getServiceHost()));
        }
    }

    private class BootstrapAsyncTask
    extends AsyncTask<Void, Void, String> {
        private BootstrapAsyncTask() {
        }

        protected void onPreExecute() {
            EvernoteOAuthActivity.this.showDialog(101);
        }

        protected String doInBackground(Void ... params) {
            String url = null;
            try {
                BootstrapInfo info;
                BootstrapManager.BootstrapInfoWrapper infoWrapper;
                EvernoteSession session = EvernoteSession.getOpenSession();
                if (session != null && (infoWrapper = session.getBootstrapSession().getBootstrapInfo()) != null && (info = infoWrapper.getBootstrapInfo()) != null) {
                    EvernoteOAuthActivity.this.mBootstrapProfiles = (ArrayList)info.getProfiles();
                    if (EvernoteOAuthActivity.this.mBootstrapProfiles != null && EvernoteOAuthActivity.this.mBootstrapProfiles.size() > 0 && EvernoteOAuthActivity.this.mSelectedBootstrapProfilePos < EvernoteOAuthActivity.this.mBootstrapProfiles.size()) {
                        EvernoteOAuthActivity.this.mSelectedBootstrapProfile = (BootstrapProfile)EvernoteOAuthActivity.this.mBootstrapProfiles.get(EvernoteOAuthActivity.this.mSelectedBootstrapProfilePos);
                    }
                }
                if (EvernoteOAuthActivity.this.mSelectedBootstrapProfile == null || TextUtils.isEmpty((CharSequence)EvernoteOAuthActivity.this.mSelectedBootstrapProfile.getSettings().getServiceHost())) {
                    Log.d((String)EvernoteOAuthActivity.LOGTAG, (String)"Bootstrap did not return a valid host");
                    return null;
                }
                OAuthService service = EvernoteOAuthActivity.this.createService();
                Log.i((String)EvernoteOAuthActivity.LOGTAG, (String)"Retrieving OAuth request token...");
                Token reqToken = service.getRequestToken();
                EvernoteOAuthActivity.this.mRequestToken = reqToken.getToken();
                EvernoteOAuthActivity.this.mRequestTokenSecret = reqToken.getSecret();
                Log.i((String)EvernoteOAuthActivity.LOGTAG, (String)"Redirecting user for authorization...");
                url = service.getAuthorizationUrl(reqToken);
                if (EvernoteOAuthActivity.this.mSupportAppLinkedNotebooks) {
                    url = url + "&supportLinkedSandbox=true";
                }
            }
            catch (BootstrapManager.ClientUnsupportedException cue) {
                return null;
            }
            catch (Exception ex) {
                Log.e((String)EvernoteOAuthActivity.LOGTAG, (String)"Failed to obtain OAuth request token", (Throwable)ex);
            }
            return url;
        }

        protected void onPostExecute(String url) {
            EvernoteOAuthActivity.this.removeDialog(101);
            if (!TextUtils.isEmpty((CharSequence)url)) {
                EvernoteOAuthActivity.this.mWebView.loadUrl(url);
                if (Build.VERSION.SDK_INT >= 11) {
                    EvernoteOAuthActivity.this.invalidateOptionsMenu();
                }
            } else {
                EvernoteOAuthActivity.this.exit(false);
            }
        }
    }
}

