/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.oauth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Token;
import org.scribe.utils.OAuthEncoder;

public class EvernoteAuthToken
extends Token {
    private static final long serialVersionUID = -6892516333656106315L;
    private static final Pattern NOTESTORE_REGEX = Pattern.compile("edam_noteStoreUrl=([^&]+)");
    private static final Pattern WEBAPI_REGEX = Pattern.compile("edam_webApiUrlPrefix=([^&]+)");
    private static final Pattern USERID_REGEX = Pattern.compile("edam_userId=([^&]+)");
    private String mNoteStoreUrl = this.extract(this.getRawResponse(), NOTESTORE_REGEX);
    private String mWebApiUrlPrefix = this.extract(this.getRawResponse(), WEBAPI_REGEX);
    private int mUserId = Integer.parseInt(this.extract(this.getRawResponse(), USERID_REGEX));
    private boolean mAppLinkedNotebook;

    public EvernoteAuthToken(Token token, boolean appLinkedNotebook) {
        super(token.getToken(), token.getSecret(), token.getRawResponse());
        this.mAppLinkedNotebook = appLinkedNotebook;
    }

    private String extract(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return OAuthEncoder.decode((String)matcher.group(1));
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + response + "'", null);
    }

    public String getNoteStoreUrl() {
        return this.mNoteStoreUrl;
    }

    public String getWebApiUrlPrefix() {
        return this.mWebApiUrlPrefix;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public boolean isAppLinkedNotebook() {
        return this.mAppLinkedNotebook;
    }
}

