/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.os.Handler;
import android.os.Looper;
import com.evernote.client.android.OnClientCallback;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class AsyncReflector {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_MAP = new HashMap();
    private static ExecutorService sThreadExecutor;

    AsyncReflector() {
    }

    static <T> void execute(final Object receiver, final OnClientCallback<T> callback, final String function, final Object ... args) {
        final Handler handler = new Handler(Looper.getMainLooper());
        sThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Class[] classes = new Class[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        classes[i] = PRIMITIVE_MAP.containsKey(args[i].getClass()) ? PRIMITIVE_MAP.get(args[i].getClass()) : args[i].getClass();
                    }
                    Method method = null;
                    method = receiver instanceof Class ? ((Class)receiver).getMethod(function, classes) : receiver.getClass().getMethod(function, classes);
                    final Object answer = method.invoke(receiver, args);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onSuccess(answer);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onException(ex);
                            }
                        }
                    });
                }
            }
        });
    }

    static {
        PRIMITIVE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_MAP.put(Short.class, Short.TYPE);
        PRIMITIVE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_MAP.put(Double.class, Double.TYPE);
        sThreadExecutor = Executors.newSingleThreadExecutor();
    }
}

