/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import com.evernote.client.android.AsyncBusinessNoteStoreClient;
import com.evernote.client.android.AsyncLinkedNoteStoreClient;
import com.evernote.client.android.AsyncNoteStoreClient;
import com.evernote.client.android.AsyncReflector;
import com.evernote.client.android.AsyncUserStoreClient;
import com.evernote.client.android.AuthenticationResult;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.OnClientCallback;
import com.evernote.client.conn.mobile.TEvernoteHttpClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TBinaryProtocol;
import com.evernote.thrift.protocol.TProtocol;
import com.evernote.thrift.transport.TTransport;
import com.evernote.thrift.transport.TTransportException;
import java.io.File;
import java.util.Map;

public class ClientFactory {
    private static final String LOGTAG = "ClientFactory";
    private static final String USER_AGENT_KEY = "User-Agent";
    private String mUserAgent;
    private Map<String, String> mCustomHeaders;
    private File mTempDir;

    private ClientFactory() {
    }

    ClientFactory(String userAgent, File tempDir) {
        this.mUserAgent = userAgent;
        this.mTempDir = tempDir;
    }

    public AsyncNoteStoreClient createNoteStoreClient() throws TTransportException {
        if (EvernoteSession.getOpenSession() == null || EvernoteSession.getOpenSession().getAuthenticationResult() == null) {
            throw new IllegalStateException();
        }
        TEvernoteHttpClient transport = new TEvernoteHttpClient(EvernoteSession.getOpenSession().getAuthenticationResult().getNoteStoreUrl(), this.mUserAgent, this.mTempDir);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        return new AsyncNoteStoreClient((TProtocol)protocol, (TProtocol)protocol, EvernoteSession.getOpenSession().getAuthenticationResult().getAuthToken());
    }

    public void createBusinessNoteStoreClientAsync(OnClientCallback<AsyncBusinessNoteStoreClient> callback) {
        AsyncReflector.execute(this, callback, "createBusinessNoteStoreClient", new Object[0]);
    }

    public AsyncBusinessNoteStoreClient createBusinessNoteStoreClient() throws TException, EDAMUserException, EDAMSystemException {
        AuthenticationResult authResult = EvernoteSession.getOpenSession().getAuthenticationResult();
        if (authResult.getBusinessAuthToken() == null || authResult.getBusinessAuthTokenExpiration() < System.currentTimeMillis()) {
            com.evernote.edam.userstore.AuthenticationResult businessAuthResult = this.createUserStoreClient().getClient().authenticateToBusiness(authResult.getAuthToken());
            authResult.setBusinessAuthToken(businessAuthResult.getAuthenticationToken());
            authResult.setBusinessAuthTokenExpiration(businessAuthResult.getExpiration());
            authResult.setBusinessNoteStoreUrl(businessAuthResult.getNoteStoreUrl());
            authResult.setBusinessUser(businessAuthResult.getUser());
        }
        TEvernoteHttpClient transport = new TEvernoteHttpClient(authResult.getBusinessNoteStoreUrl(), this.mUserAgent, this.mTempDir);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        return new AsyncBusinessNoteStoreClient((TProtocol)protocol, (TProtocol)protocol, authResult.getBusinessAuthToken(), this);
    }

    public void createLinkedNoteStoreClientAsync(LinkedNotebook notebook, OnClientCallback<AsyncLinkedNoteStoreClient> callback) {
        AsyncReflector.execute(this, callback, "createLinkedNoteStoreClient", notebook);
    }

    public AsyncLinkedNoteStoreClient createLinkedNoteStoreClient(LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        AuthenticationResult authResult = EvernoteSession.getOpenSession().getAuthenticationResult();
        TEvernoteHttpClient transport = new TEvernoteHttpClient(linkedNotebook.getNoteStoreUrl(), this.mUserAgent, this.mTempDir);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        AsyncLinkedNoteStoreClient sharedNoteStore = new AsyncLinkedNoteStoreClient((TProtocol)protocol, (TProtocol)protocol, authResult.getAuthToken(), this);
        com.evernote.edam.userstore.AuthenticationResult sharedAuthKey = sharedNoteStore.getAsyncClient().getClient().authenticateToSharedNotebook(linkedNotebook.getShareKey(), authResult.getAuthToken());
        sharedNoteStore.setAuthToken(sharedAuthKey.getAuthenticationToken());
        return sharedNoteStore;
    }

    public AsyncUserStoreClient createUserStoreClient() throws IllegalStateException, TTransportException {
        if (EvernoteSession.getOpenSession() == null || EvernoteSession.getOpenSession().getAuthenticationResult() == null) {
            throw new IllegalStateException();
        }
        return this.createUserStoreClient(EvernoteSession.getOpenSession().getAuthenticationResult().getEvernoteHost());
    }

    AsyncUserStoreClient createUserStoreClient(String url) throws TTransportException {
        return this.createUserStoreClient(url, 0);
    }

    AsyncUserStoreClient createUserStoreClient(String url, int port) throws TTransportException {
        String serviceUrl = this.getFullUrl(url, port);
        TEvernoteHttpClient transport = new TEvernoteHttpClient(serviceUrl, this.mUserAgent, this.mTempDir);
        if (this.mCustomHeaders != null) {
            for (Map.Entry<String, String> header : this.mCustomHeaders.entrySet()) {
                transport.setCustomHeader(header.getKey(), header.getValue());
            }
        }
        if (this.mUserAgent != null) {
            transport.setCustomHeader(USER_AGENT_KEY, this.mUserAgent);
        }
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        String authToken = null;
        if (EvernoteSession.getOpenSession().isLoggedIn()) {
            authToken = EvernoteSession.getOpenSession().getAuthenticationResult().getAuthToken();
        }
        return new AsyncUserStoreClient((TProtocol)protocol, (TProtocol)protocol, authToken);
    }

    private String getFullUrl(String serviceUrl, int port) {
        String url = "";
        if (port != 0) {
            serviceUrl = serviceUrl + ":" + port;
        }
        if (!serviceUrl.startsWith("http")) {
            url = serviceUrl.contains(":") ? "http://" : "https://";
        }
        url = url + serviceUrl + "/edam/user";
        return url;
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    public void setUserAgent(String mUserAgent) {
        this.mUserAgent = mUserAgent;
    }

    public Map<String, String> getCustomHeaders() {
        return this.mCustomHeaders;
    }

    public void setCustomHeaders(Map<String, String> mCustomHeaders) {
        this.mCustomHeaders = mCustomHeaders;
    }

    public File getTempDir() {
        return this.mTempDir;
    }

    public void setTempDir(File mTempDir) {
        this.mTempDir = mTempDir;
    }
}

