/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.ai;

import com.github.rjeschke.neetutils.ai.Layer;
import com.github.rjeschke.neetutils.ai.Net;
import com.github.rjeschke.neetutils.ai.Trainer;

@Deprecated
public class BackpropLinearTrainer
implements Trainer {
    double step;
    Net net;
    Layer.State[] deltas;

    public BackpropLinearTrainer(Net net, double step) {
        this.net = net;
        this.step = step;
        this.deltas = net.createExtraStates(new double[net.numInputs]);
    }

    @Override
    public void train(double[] input, double[] expectedOutput) {
        int i;
        Layer.State[] netState = this.net.createExtraStates(input);
        this.net.run(netState);
        double[] os = netState[netState.length - 1].values;
        double[] ds = this.deltas[netState.length - 1].values;
        for (i = 0; i < os.length; ++i) {
            double o = os[i];
            ds[i] = o * (1.0 - o) * (expectedOutput[i] - o);
        }
        for (i = this.net.layers.length - 1; i >= 0; --i) {
            Layer l = this.net.layers[i];
            os = netState[i].values;
            ds = this.deltas[i + 1].values;
            double[] dso = this.deltas[i].values;
            for (int x = 0; x < l.numInputs; ++x) {
                double e = 0.0;
                for (int y = 0; y < l.numOutputs; ++y) {
                    e += ds[y] * l.matrix[y * l.width + x];
                }
                double o = os[x];
                dso[x] = o * (1.0 - o) * e;
            }
        }
        for (i = 0; i < this.net.layers.length; ++i) {
            Layer l = this.net.layers[i];
            for (int y = 0; y < l.numOutputs; ++y) {
                int p = y * l.width;
                double d = this.step * this.deltas[i + 1].values[y];
                int n = p + l.numInputs;
                l.matrix[n] = l.matrix[n] + d;
                for (int x = 0; x < l.numInputs; ++x) {
                    int n2 = p + x;
                    l.matrix[n2] = l.matrix[n2] + d * netState[i].values[x];
                }
            }
        }
    }

    public void setStep(double v) {
        this.step = v;
    }
}

