/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.ai;

import com.github.rjeschke.neetutils.ai.TransferFunction;
import com.github.rjeschke.neetutils.ai.TransferFunctions;
import com.github.rjeschke.neetutils.io.NInputStream;
import com.github.rjeschke.neetutils.io.NOutputStream;
import java.io.IOException;

@Deprecated
class Layer {
    final TransferFunction tf;
    final int numInputs;
    final int numOutputs;
    final int width;
    final double[] matrix;

    Layer(TransferFunction tf, int numInputs, int numOutputs) {
        this.tf = tf;
        this.numInputs = numInputs;
        this.numOutputs = numOutputs;
        this.width = numInputs + 1;
        this.matrix = new double[this.width * this.numOutputs];
    }

    public Layer clone() {
        Layer l = new Layer(this.tf, this.numInputs, this.numOutputs);
        System.arraycopy(this.matrix, 0, l.matrix, 0, this.matrix.length);
        return l;
    }

    double[] eval(double[] inputs, double[] outputs) {
        for (int y = 0; y < this.numOutputs; ++y) {
            double o = 0.0;
            int p = y * this.width;
            for (int x = 0; x < this.numInputs; ++x) {
                o += inputs[x] * this.matrix[p + x];
            }
            outputs[y] = this.tf.map(o + this.matrix[p + this.numInputs]);
        }
        return outputs;
    }

    State createState() {
        return new State(this.numOutputs);
    }

    State createState(double[] outputs) {
        return new State(outputs);
    }

    void toStream(NOutputStream out) throws IOException {
        out.write32(this.numInputs);
        out.write32(this.numOutputs);
        this.tf.toStream(out);
        for (int i = 0; i < this.matrix.length; ++i) {
            out.writeDouble(this.matrix[i]);
        }
    }

    public void zeroNaNsAndInfs() {
        for (int i = 0; i < this.matrix.length; ++i) {
            double d = this.matrix[i];
            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
            this.matrix[i] = 0.0;
        }
    }

    static Layer fromStream(NInputStream in) throws IOException {
        int a = in.readI32();
        int b = in.readI32();
        TransferFunction tf = TransferFunctions.fromStream(in);
        Layer l = new Layer(tf, a, b);
        for (int i = 0; i < l.matrix.length; ++i) {
            l.matrix[i] = in.readDouble();
        }
        return l;
    }

    static class State {
        public final double[] values;

        State(int values) {
            this.values = new double[values];
        }

        State(double[] values) {
            this.values = values;
        }
    }
}

