/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.math.NMath;

public class DigitalOSC {
    private Wave wave = Wave.NONE;
    private final double freqMul;
    private int phase;
    private int step;
    private double fstep;
    private double invFstep;
    private double rampFstep;
    private double fpw;
    private int pw;
    private int nextPw;
    private static final double SIN3 = -0.16666666666666666;
    private static final double SIN5 = 0.008333333333333333;
    private static final double SIN7 = -1.984126984126984E-4;
    private static final double SIN9 = 2.7557319223985893E-6;
    private static final double F0PI5 = 1.5707963267948966;
    private static final double F0PI5_2 = 3.7450702829239286E-7;
    private static final double P1 = 5.960464477539063E-8;

    public DigitalOSC(double fs) {
        this.freqMul = 7.38197504E9 / fs;
        this.pw = 0x800000;
        this.fpw = 0.5;
        this.nextPw = 0xFFFFFF;
    }

    public void setPw(double v) {
        this.nextPw = (int)(NMath.clamp(v, 0.05, 0.95) * 1.6777216E7);
    }

    public void setPitch(int cents) {
        int c = NMath.clamp(cents, 0, 12799);
        this.step = (int)(this.freqMul * Math.pow(2.0, (double)(c - 6900) / 1200.0));
        this.fstep = (double)this.step / 1.6777216E7;
        this.invFstep = 1.0 / this.fstep;
        this.rampFstep = this.fstep * (this.fstep + 5.960464477539063E-8) * 0.5 * this.invFstep;
    }

    public void setWave(Wave w) {
        this.wave = w;
    }

    public static int pitchFromFreq(double freq) {
        return (int)Math.floor(6900.5 + 1200.0 * Math.log(freq / 440.0) / Math.log(2.0));
    }

    public static double fastSin(int p) {
        double x = (double)(p & 0x3FFFFF) * 3.7450702829239286E-7;
        if ((p & 0x400000) != 0) {
            x = 1.5707963267948966 - x;
        }
        if ((p & 0x800000) != 0) {
            x = -x;
        }
        double x2 = x * x;
        return ((((2.7557319223985893E-6 * x2 + -1.984126984126984E-4) * x2 + 0.008333333333333333) * x2 + -0.16666666666666666) * x2 + 1.0) * x;
    }

    public double tick() {
        int np = this.phase + this.step & 0xFFFFFF;
        double out = 0.0;
        switch (this.wave) {
            default: {
                out = 0.0;
                break;
            }
            case SINE: {
                out = DigitalOSC.fastSin(this.phase);
                break;
            }
            case SAWTOOTH: {
                double fp = (double)this.phase * 5.960464477539063E-8;
                if (this.phase > np) {
                    double a = 1.0 - fp;
                    out = a * (fp + (a + 5.960464477539063E-8) * 0.5);
                    a = this.fstep - a;
                    out = (out + a * (a + 5.960464477539063E-8) * 0.5) * this.invFstep;
                } else {
                    out = fp + this.rampFstep;
                }
                out = 2.0 * out - 1.0;
                break;
            }
            case PULSE: {
                if (this.phase > np) {
                    if (this.phase < this.pw && np < this.pw) {
                        out = (1.0 - this.fpw) * this.invFstep;
                    } else if (this.phase >= this.pw && np >= this.pw) {
                        out = (this.fstep - this.fpw) * this.invFstep;
                    } else {
                        double fp = (double)this.phase * 5.960464477539063E-8;
                        out = (1.0 - fp) * this.invFstep;
                    }
                } else if (this.phase < this.pw && np >= this.pw) {
                    double fp = (double)this.phase / 1.6777216E7;
                    out = (fp + this.fstep - this.fpw) * this.invFstep;
                } else if (this.phase >= this.pw) {
                    out = 1.0;
                }
                if (np > this.nextPw) {
                    this.pw = this.nextPw;
                    this.fpw = (double)this.pw * 5.960464477539063E-8;
                    this.nextPw = 0xFFFFFF;
                }
                out = 2.0 * out - 1.0;
                break;
            }
            case TRIANGLE: {
                double fp = (double)this.phase * 5.960464477539063E-8;
                if (this.phase > np) {
                    double a = 1.0 - fp;
                    out = a * (a - (a + 5.960464477539063E-8) * 0.5);
                    a = this.fstep - a;
                    out = (out + a * (a + 5.960464477539063E-8) * 0.5) * this.invFstep;
                } else if (this.phase < 0x800000 && np >= 0x800000) {
                    double a = 0.5 - fp;
                    out = a * (fp + (a + 5.960464477539063E-8) * 0.5);
                    a = 1.0 - this.fstep + a;
                    out = (out + a * (0.5 - (a + 5.960464477539063E-8) * 0.5)) * this.invFstep;
                } else {
                    out = this.phase < 0x800000 ? fp + this.rampFstep : 1.0 - fp - this.rampFstep;
                }
                out = 4.0 * out - 1.0;
                break;
            }
        }
        this.phase = np;
        return out;
    }

    public static enum Wave {
        NONE,
        SINE,
        SAWTOOTH,
        PULSE,
        TRIANGLE;

    }
}

