/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.math.NMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class FIRUtils {
    private static final String[] PRES = new String[]{"1", "10", "100"};
    private static final String[] POSTS = new String[]{"", "k", "M", "G", "T", "P"};

    private FIRUtils() {
    }

    public static final double[] createLowpass(int order, double fc, double fs) {
        double cutoff = fc / fs;
        double[] fir = new double[order + 1];
        double factor = 2.0 * cutoff;
        int half = order >> 1;
        for (int i = 0; i < fir.length; ++i) {
            fir[i] = factor * NMath.sinc(factor * (double)(i - half));
        }
        return fir;
    }

    public static final double[] createHighpass(int order, double fc, double fs) {
        double cutoff = fc / fs;
        double[] fir = new double[order + 1];
        double factor = 2.0 * cutoff;
        int half = order >> 1;
        for (int i = 0; i < fir.length; ++i) {
            fir[i] = (i == half ? 1.0 : 0.0) - factor * NMath.sinc(factor * (double)(i - half));
        }
        return fir;
    }

    public static final double[] createBandstop(int order, double fcl, double fch, double fs) {
        double[] low = FIRUtils.createLowpass(order, fcl, fs);
        double[] high = FIRUtils.createHighpass(order, fch, fs);
        for (int i = 0; i < low.length; ++i) {
            int n = i;
            low[n] = low[n] + high[i];
        }
        return low;
    }

    public static final double[] createBandpass(int order, double fcl, double fch, double fs) {
        double[] fir = FIRUtils.createBandstop(order, fcl, fch, fs);
        int half = order >> 1;
        for (int i = 0; i < fir.length; ++i) {
            fir[i] = (i == half ? 1.0 : 0.0) - fir[i];
        }
        return fir;
    }

    public static final double[] normalize(double[] fir) {
        int i;
        double sum = 0.0;
        for (i = 0; i < fir.length; ++i) {
            sum += fir[i];
        }
        if (sum != 0.0) {
            i = 0;
            while (i < fir.length) {
                int n = i++;
                fir[n] = fir[n] / sum;
            }
        }
        return fir;
    }

    public static final double[] windowKaiser(double transitionWidth, double attenuation, double fs) {
        double tw = Math.PI * 2 * transitionWidth / fs;
        int m = attenuation <= 21.0 ? (int)Math.ceil(5.79 / tw) : (int)Math.ceil((attenuation - 7.95) / (2.285 * tw));
        if ((m & 1) == 0) {
            ++m;
        }
        double[] win = new double[m];
        double beta = attenuation <= 21.0 ? 0.0 : (attenuation <= 50.0 ? 0.5842 * Math.pow(attenuation - 21.0, 0.4) + 0.07886 * (attenuation - 21.0) : 0.1102 * (attenuation - 8.7));
        double i0b = NMath.i0(beta);
        for (int n = 0; n < m; ++n) {
            double v = beta * Math.sqrt(1.0 - Math.pow(2.0 * (double)n / (double)(m - 1) - 1.0, 2.0));
            win[n] = NMath.i0(v) / i0b;
        }
        return win;
    }

    public static final double kaiserTransitionWidth(int m, double attenuation, double fs) {
        double tw = attenuation <= 21.0 ? 5.79 / (double)m : (attenuation - 7.95) / (2.285 * (double)m);
        return tw * fs / (Math.PI * 2);
    }

    public static final double[] windowKaiserFromAttenuation(double[] fir, double attenuation, double fs) {
        int m = fir.length;
        double beta = attenuation <= 21.0 ? 0.0 : (attenuation <= 50.0 ? 0.5842 * Math.pow(attenuation - 21.0, 0.4) + 0.07886 * (attenuation - 21.0) : 0.1102 * (attenuation - 8.7));
        double i0b = NMath.i0(beta);
        int n = 0;
        while (n < m) {
            double v = beta * Math.sqrt(1.0 - Math.pow(2.0 * (double)n / (double)(m - 1) - 1.0, 2.0));
            int n2 = n++;
            fir[n2] = fir[n2] * (NMath.i0(v) / i0b);
        }
        return fir;
    }

    public static final double[] windowBartlett(double[] fir) {
        int m = fir.length - 1;
        int m2 = m >> 1;
        for (int i = 0; i < fir.length; ++i) {
            int n = i;
            fir[n] = fir[n] * (1.0 - 2.0 * (double)(i - m2) / (double)m);
        }
        return fir;
    }

    public static final double[] windowSinc(double[] fir) {
        int m = fir.length - 1;
        for (int i = 0; i < fir.length; ++i) {
            int n = i;
            fir[n] = fir[n] * NMath.sinc(2.0 * (double)i / (double)m - 1.0);
        }
        return fir;
    }

    public static final double[] windowHanning(double[] fir) {
        int m = fir.length - 1;
        for (int i = 0; i < fir.length; ++i) {
            int n = i;
            fir[n] = fir[n] * (0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)m));
        }
        return fir;
    }

    public static final double[] windowHamming(double[] fir) {
        int m = fir.length - 1;
        for (int i = 0; i < fir.length; ++i) {
            int n = i;
            fir[n] = fir[n] * (0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / (double)m));
        }
        return fir;
    }

    public static final double[] windowBlackman(double[] fir) {
        int m = fir.length - 1;
        for (int i = 0; i < fir.length; ++i) {
            int n = i;
            fir[n] = fir[n] * (0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)m) + 0.08 * Math.cos(Math.PI * 4 * (double)i / (double)m));
        }
        return fir;
    }

    public static final float[] toFloats(double[] array) {
        float[] ret = new float[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (float)array[i];
        }
        return ret;
    }

    private static final String engVal(int val) {
        int z = 0;
        for (int v = 1; v < val; v *= 10) {
            ++z;
        }
        int pre = z % 3;
        int post = z / 3;
        return PRES[pre] + POSTS[post];
    }

    public static final BufferedImage freqResponse(double[] fir, double fs) {
        int x;
        int v;
        int db;
        int dy;
        int[] dbs = new int[]{12, 6, 0, -6, -12, -24, -48, -72, -96, -120};
        BufferedImage ret = new BufferedImage(1024, 512, 1);
        Graphics2D g = ret.createGraphics();
        g.setFont(new Font("Arial", 0, 12));
        FontRenderContext frc = g.getFontRenderContext();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 1024, 512);
        g.setColor(Color.GRAY);
        int n = 0;
        for (int i = 0; i < 500 && (dy = 511 - ((db = 12 - i) + 144) * 512 / 156) <= 511; i += 6) {
            g.drawLine(0, dy, 1024, dy);
            if (n >= dbs.length || dbs[n] != db) continue;
            g.setColor(Color.WHITE);
            String value = Integer.toString(db);
            Rectangle2D r = g.getFont().getStringBounds(value, frc);
            g.drawString(value, 2.0f, (float)dy - (float)r.getMinY());
            g.setColor(Color.GRAY);
            ++n;
        }
        double logFs = Math.log10(fs * 0.5);
        int st = v = 1;
        int next = v * 10;
        boolean wasNext = false;
        while ((x = (int)(1024.0 * Math.log10(v) / logFs)) < 1024) {
            g.drawLine(x, 0, x, 512);
            if (wasNext) {
                g.setColor(Color.WHITE);
                String value = FIRUtils.engVal(next / 10);
                Rectangle2D r = g.getFont().getStringBounds(value, frc);
                g.drawString(value, (float)x - (float)r.getWidth() * 0.5f, 518.0f + (float)r.getMinY());
                g.setColor(Color.GRAY);
                wasNext = false;
            }
            if ((v += st) != next) continue;
            next *= 10;
            st *= 10;
            wasNext = true;
        }
        double max = 0.0;
        for (int i = 0; i < fir.length; ++i) {
            max = Math.max(Math.abs(fir[i]), max);
        }
        max = 255.0 / max;
        int oldy2 = 0;
        int oldy = 0;
        for (x = 0; x < 1024; ++x) {
            double w = Math.pow(10.0, logFs * (double)x / 1024.0) / (fs * 0.5) * Math.PI;
            double re = 0.0;
            double im = 0.0;
            for (int i = 0; i < fir.length; ++i) {
                re += fir[i] * Math.cos((double)i * w);
                im -= fir[i] * Math.sin((double)i * w);
            }
            double v2 = Math.sqrt(re * re + im * im);
            v2 = v2 != 0.0 ? Math.max(Math.log10(v2) * 20.0, -144.0) : -144.0;
            int y = 511 - (int)((v2 + 144.0) * 512.0 / 156.0);
            double pp = (double)fir.length * (double)x / 1024.0;
            int pi = (int)pp;
            double fv = fir[NMath.clamp(pi, 0, fir.length - 1)] + (pp -= (double)pi) * (fir[NMath.clamp(pi + 1, 0, fir.length - 1)] - fir[NMath.clamp(pi, 0, fir.length - 1)]);
            int y2 = 256 - (int)(fv * max);
            if (x > 0) {
                g.setColor(Color.BLUE);
                g.drawLine(x - 1, oldy2, x, y2);
                g.setColor(Color.GREEN);
                g.drawLine(x - 1, oldy, x, y);
            }
            oldy = y;
            oldy2 = y2;
        }
        return ret;
    }

    public static final double[] multiply(double[] inout, double[] in) {
        if (inout.length != in.length) {
            throw new RuntimeException("Filter lengths do not match!");
        }
        for (int i = 0; i < inout.length; ++i) {
            int n = i;
            inout[n] = inout[n] * in[i];
        }
        return inout;
    }

    public static final double[] add(double[] inout, double[] in) {
        if (inout.length != in.length) {
            throw new RuntimeException("Filter lengths do not match!");
        }
        for (int i = 0; i < inout.length; ++i) {
            int n = i;
            inout[n] = inout[n] + in[i];
        }
        return inout;
    }

    public static final double[] scale(double[] fir, double f) {
        int i = 0;
        while (i < fir.length) {
            int n = i++;
            fir[n] = fir[n] * f;
        }
        return fir;
    }
}

