/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.DefaultClipper;
import com.github.rjeschke.neetutils.math.NMath;

public class LPF24dB {
    private final double fs;
    private double q;
    private double qfu0;
    private double f;
    private double bl0;
    private double bb0;
    private double r0;
    private double t0;
    private double tf0;
    private double u0;
    private double f0u1;
    private double bl1;
    private double bb1;
    private double r1;
    private double t1;
    private double tf1;
    private double u1;
    private Clipper clipper = new DefaultClipper();

    public LPF24dB(double fs) {
        this.fs = fs;
        this.setButterworthResponse();
        this.setCutoff(fs * 0.1);
    }

    public void setCutoff(double cutoff) {
        this.f = Math.tan(Math.PI * cutoff / this.fs);
        this.recalc();
    }

    private void recalc() {
        this.t0 = 1.0 / (1.0 + this.r0 * this.f);
        this.tf0 = this.t0 * this.f;
        this.u0 = 1.0 / (1.0 + this.t0 * this.f * this.f);
        this.t1 = 1.0 / (1.0 + this.r1 * this.f);
        this.tf1 = this.t1 * this.f;
        this.u1 = 1.0 / (1.0 + this.t1 * this.f * this.f);
        this.f0u1 = this.f * this.u1;
        this.qfu0 = this.u0 / (1.0 + this.u0 * this.tf0 * this.f * this.tf1 * this.u1 * this.f * this.q);
    }

    public void setQ(double q) {
        this.q = q;
        this.recalc();
    }

    public LPF24dB setButterworthResponse() {
        this.setRawQs(NMath.getButterworthFactor(4, 1), NMath.getButterworthFactor(4, 2));
        return this;
    }

    public LPF24dB setMoogLadderResponse() {
        this.setRawQs(2.0, 2.0);
        return this;
    }

    public void reset() {
        this.bl1 = 0.0;
        this.bl0 = 0.0;
        this.bb1 = 0.0;
        this.bb0 = 0.0;
    }

    public LPF24dB setRawQs(double r0, double r1) {
        this.r0 = r0;
        this.r1 = r1;
        this.recalc();
        return this;
    }

    public LPF24dB setClipper(Clipper clipper) {
        this.clipper = clipper;
        return this;
    }

    public double process(double input) {
        double out = this.qfu0 * (this.bl0 + this.tf0 * (this.bb0 + this.f0u1 * (this.bl1 + this.tf1 * (this.bb1 + this.f * input))));
        double qin = input - this.q * out;
        double low1 = (this.bl1 + this.tf1 * (this.bb1 + this.f * qin)) * this.u1;
        double band1 = (this.bb1 + this.f * (qin - low1)) * this.t1;
        double high1 = qin - low1 - this.r1 * band1;
        double low0 = (this.bl0 + this.tf0 * (this.bb0 + this.f * low1)) * this.u0;
        double band0 = (this.bb0 + this.f * (low1 - low0)) * this.t0;
        double high0 = low1 - low0 - this.r0 * band0;
        this.bb1 = this.clipper.clip(band1 + this.f * high1);
        this.bl1 = this.clipper.clip(low1 + this.f * band1);
        this.bb0 = this.clipper.clip(band0 + this.f * high0);
        this.bl0 = this.clipper.clip(low0 + this.f * band0);
        return out;
    }
}

