/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.DefaultClipper;
import com.github.rjeschke.neetutils.math.NMath;

public class SVF24dB {
    private final double fs;
    private double b0;
    private double b1;
    private double b2;
    private double b3;
    private double f;
    private double fB0;
    private double fB1;
    private double fC0;
    private double fC1;
    private double fD0;
    private double fD1;
    private double fE0;
    private double a;
    private double b;
    private double c;
    private double d;
    private double r;
    private double dr;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    private Clipper clipper = new DefaultClipper();

    public SVF24dB(double fs) {
        this.fs = fs;
        this.setButterworthResponse();
    }

    public SVF24dB setCoefficients(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.recalc();
        return this;
    }

    public SVF24dB setButterworthResponse() {
        double a = NMath.getButterworthFactor(4, 1);
        double b = NMath.getButterworthFactor(4, 2);
        return this.setCoefficients(a + b, 2.0 * a + b, a + b, 1.0);
    }

    public SVF24dB setLadderResponse() {
        return this.setCoefficients(4.0, 6.0, 4.0, 1.0);
    }

    public SVF24dB setTBResponse() {
        return this.setCoefficients(6.727171322029717, 14.142135623730951, 9.513656920021768, 1.0);
    }

    public SVF24dB setEMSResponse() {
        return this.setCoefficients(8.335135415365786, 20.207259421636902, 13.677042341728665, 1.0);
    }

    public SVF24dB setDResponse() {
        return this.setCoefficients(8.115667411135693, 19.595917942265423, 13.554030054147672, 1.0);
    }

    public void setCutoff(double freq) {
        this.f = Math.tan(Math.PI * freq / this.fs);
        this.recalc();
    }

    public void setQ(double q) {
        this.r = q;
        this.recalc();
    }

    public void reset() {
        this.b3 = 0.0;
        this.b2 = 0.0;
        this.b1 = 0.0;
        this.b0 = 0.0;
    }

    public SVF24dB setClipper(Clipper clipper) {
        this.clipper = clipper;
        return this;
    }

    private void recalc() {
        this.dr = this.d + this.r;
        this.fB0 = 1.0 / (1.0 + this.f * this.a);
        this.fB1 = this.f * this.fB0;
        this.fC0 = 1.0 / (1.0 + this.fB1 * this.f * this.b);
        this.fC1 = this.f * this.fC0;
        this.fD0 = 1.0 / (1.0 + this.fC1 * this.fB1 * this.f * this.c);
        this.fD1 = this.f * this.fD0;
        this.fE0 = 1.0 / (1.0 + this.fD1 * this.fC1 * this.fB1 * this.f * this.dr);
    }

    public double low() {
        return this.E;
    }

    public double lowBand() {
        return this.D;
    }

    public double band() {
        return this.C;
    }

    public double highBand() {
        return this.B;
    }

    public double high() {
        return this.A;
    }

    public SVF24dB process(double input) {
        this.E = (this.b3 + this.fD1 * (this.b2 + this.fC1 * (this.b1 + this.fB1 * (this.b0 + this.f * input)))) * this.fE0;
        double temp = input - this.dr * this.E;
        this.D = (this.b2 + this.fC1 * (this.b1 + this.fB1 * (this.b0 + this.f * temp))) * this.fD0;
        this.C = (this.b1 + this.fB1 * (this.b0 + this.f * (temp -= this.c * this.D))) * this.fC0;
        this.B = (this.b0 + this.f * (temp -= this.b * this.C)) * this.fB0;
        this.A = temp - this.a * this.B;
        this.b3 = this.clipper.clip(this.E + this.f * this.D);
        this.b2 = this.clipper.clip(this.D + this.f * this.C);
        this.b1 = this.clipper.clip(this.C + this.f * this.B);
        this.b0 = this.clipper.clip(this.B + this.f * this.A);
        return this;
    }
}

