/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.io.NOutputStream;
import com.github.rjeschke.neetutils.io.NOutputStreamLE;
import com.github.rjeschke.neetutils.math.NMath;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class WavWriter {
    private final int sampleRate;
    private final int bitsPerSample;
    private final int channels;
    private File tempFile = null;
    private NOutputStream tempStream = null;
    private static final byte[] RIFF = new byte[]{82, 73, 70, 70};
    private static final byte[] WAVE = new byte[]{87, 65, 86, 69};
    private static final byte[] FMT_ = new byte[]{102, 109, 116, 32};
    private static final byte[] SMPL = new byte[]{115, 109, 112, 108};
    private static final byte[] DATA = new byte[]{100, 97, 116, 97};
    private int loopOffset = -1;

    public WavWriter(int sampleRate, int bitsPerSample, int channels) {
        this.sampleRate = sampleRate;
        this.bitsPerSample = bitsPerSample;
        this.channels = channels;
    }

    private void openTemp() throws IOException {
        this.tempFile = File.createTempFile("wavwrite", "bin");
        this.tempFile.deleteOnExit();
        this.tempStream = new NOutputStreamLE(new BufferedOutputStream(new FileOutputStream(this.tempFile)));
    }

    public void save(String filename) throws IOException {
        this.save(new File(filename));
    }

    public void save(File file) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.save(out);
        }
    }

    public void setLoopRestart(int loop) {
        this.loopOffset = loop;
    }

    public static final double[] normalize(double[] wave) {
        int i;
        double max = 0.0;
        for (i = 0; i < wave.length; ++i) {
            max = Math.max(Math.abs(wave[i]), max);
        }
        if (max > 0.0) {
            i = 0;
            while (i < wave.length) {
                int n = i++;
                wave[n] = wave[n] / max;
            }
        }
        return wave;
    }

    public static final float[] normalize(float[] wave) {
        int i;
        float max = 0.0f;
        for (i = 0; i < wave.length; ++i) {
            max = Math.max(Math.abs(wave[i]), max);
        }
        if (max > 0.0f) {
            i = 0;
            while (i < wave.length) {
                int n = i++;
                wave[n] = wave[n] / max;
            }
        }
        return wave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException {
        NOutputStreamLE out = new NOutputStreamLE(output);
        try {
            if (this.tempFile == null) {
                throw new IOException("No data supplied.");
            }
            if (this.tempStream != null) {
                this.tempStream.close();
                this.tempStream = null;
            }
            if (this.channels < 1) {
                throw new IOException("Illegal channel count: " + this.channels);
            }
            if (this.sampleRate < 1) {
                throw new IOException("Illegal sample rate: " + this.sampleRate);
            }
            int dLen = (int)this.tempFile.length();
            if (dLen <= 0 || dLen + 36 <= 0) {
                throw new IOException("Too much wave data. RIFF WAVE is only 32 bits.");
            }
            int samples = dLen / (this.bitsPerSample >> 3);
            int frames = samples / this.channels;
            int blockAlign = this.channels * (this.bitsPerSample >> 3);
            if (dLen != frames * this.channels * (this.bitsPerSample >> 3)) {
                throw new IOException("Unfinished frame.");
            }
            boolean isLooped = this.loopOffset > -1 && this.loopOffset < frames;
            out.write(RIFF);
            out.write32(dLen + 36 + (isLooped ? 68 : 0));
            out.write(WAVE);
            out.write(FMT_);
            out.write32(16);
            out.write16(1);
            out.write16(this.channels);
            out.write32(this.sampleRate);
            out.write32(this.sampleRate * blockAlign);
            out.write16(blockAlign);
            out.write16(this.bitsPerSample);
            if (isLooped) {
                out.write(SMPL);
                out.write32(60);
                out.write32(0);
                out.write32(0);
                out.write32((int)(1.0 / (double)this.sampleRate * 1.0E9 + 0.5));
                out.write32(60);
                out.write32(0);
                out.write32(0);
                out.write32(0);
                out.write32(1);
                out.write32(0);
                out.write32(0);
                out.write32(0);
                out.write32(this.loopOffset);
                out.write32(samples);
                out.write32(0);
                out.write32(0);
            }
            out.write(DATA);
            out.write32(dLen);
            try (FileInputStream in = new FileInputStream(this.tempFile);){
                int read;
                byte[] b = new byte[8192];
                for (int todo = dLen; todo > 0; todo -= read) {
                    read = in.read(b);
                    out.write(b, 0, read);
                }
            }
        }
        finally {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.tempStream != null) {
            try {
                this.tempStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.tempStream = null;
            }
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
    }

    public void write(int ... samples) throws IOException {
        if (this.tempStream == null) {
            this.openTemp();
        }
        switch (this.bitsPerSample) {
            case 8: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write(NMath.clamp(samples[i], -128, 127) + 128);
                }
                break;
            }
            case 16: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write16(NMath.clamp(samples[i], Short.MIN_VALUE, Short.MAX_VALUE));
                }
                break;
            }
            case 24: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write24(NMath.clamp(samples[i], -8388608, 0x7FFFFF));
                }
                break;
            }
            default: {
                throw new IOException("Unsupported bit depth: " + this.bitsPerSample);
            }
        }
    }

    public void write(float ... samples) throws IOException {
        if (this.tempStream == null) {
            this.openTemp();
        }
        switch (this.bitsPerSample) {
            case 8: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write8(NMath.clamp((int)(samples[i] * 128.0f), -128, 127) + 128);
                }
                break;
            }
            case 16: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write16(NMath.clamp((int)(samples[i] * 32768.0f), Short.MIN_VALUE, Short.MAX_VALUE));
                }
                break;
            }
            case 24: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write24(NMath.clamp((int)(samples[i] * 8388608.0f), -8388608, 0x7FFFFF));
                }
                break;
            }
            default: {
                throw new IOException("Unsupported bit depth: " + this.bitsPerSample);
            }
        }
    }

    public void write(double ... samples) throws IOException {
        if (this.tempStream == null) {
            this.openTemp();
        }
        switch (this.bitsPerSample) {
            case 8: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write8(NMath.clamp((int)(samples[i] * 128.0), -128, 127) + 128);
                }
                break;
            }
            case 16: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write16(NMath.clamp((int)(samples[i] * 32768.0), Short.MIN_VALUE, Short.MAX_VALUE));
                }
                break;
            }
            case 24: {
                for (int i = 0; i < samples.length; ++i) {
                    this.tempStream.write24(NMath.clamp((int)(samples[i] * 8388608.0), -8388608, 0x7FFFFF));
                }
                break;
            }
            default: {
                throw new IOException("Unsupported bit depth: " + this.bitsPerSample);
            }
        }
    }

    public static final void write(String filename, int sampleRate, int bitsPerSample, int channels, double[] samples, boolean normalize) throws IOException {
        WavWriter wav = new WavWriter(sampleRate, bitsPerSample, channels);
        if (normalize) {
            int i;
            double max = 0.0;
            for (i = 0; i < samples.length; ++i) {
                max = Math.max(max, Math.abs(samples[i]));
            }
            if (max != 0.0) {
                for (i = 0; i < samples.length; ++i) {
                    samples[i] = samples[i] / max * 0.985;
                }
            }
        }
        wav.write(samples);
        wav.save(filename);
    }
}

