/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.FIRUtils;
import com.github.rjeschke.neetutils.math.CatmullRomSpline;
import com.github.rjeschke.neetutils.math.NMath;
import java.util.Arrays;

public class WaveMipMap {
    private final MipWave[] mipWaves;
    final int maxHarmonics;
    final int minHarmonics;
    private final int[] mipHarmonics;
    final MipWave first;
    final MipWave last;

    public WaveMipMap(double[] wave, int minSize, boolean normalize) {
        int i;
        int bits = (int)NMath.log2(wave.length);
        int minBits = (int)NMath.log2(minSize);
        if (1 << bits != wave.length) {
            throw new IllegalArgumentException("Wave length must be a power of two");
        }
        if (1 << minBits != minSize) {
            throw new IllegalArgumentException("Minimum size must be a power of two");
        }
        if (minBits > bits) {
            throw new IllegalArgumentException("Minimum size must be less than wave length");
        }
        double[] fir = FIRUtils.windowKaiserFromAttenuation(FIRUtils.createLowpass(510, 9500.0, 40000.0), 90.0, 40000.0);
        this.mipWaves = new MipWave[bits - minBits + 1];
        this.mipWaves[0] = new MipWave(wave);
        if (normalize) {
            int i2;
            double max = 0.0;
            MipWave w = this.mipWaves[0];
            for (i2 = 0; i2 < w.size; ++i2) {
                max = Math.max(Math.abs(w.wave[i2]), max);
            }
            if (max != 0.0) {
                i2 = 0;
                while (i2 < w.size) {
                    int n = i2++;
                    w.wave[n] = w.wave[n] / max;
                }
            }
        }
        for (i = 1; i < this.mipWaves.length; ++i) {
            this.mipWaves[i] = this.mipWaves[i - 1].half(fir);
        }
        this.first = this.mipWaves[0];
        this.last = this.mipWaves[this.mipWaves.length - 1];
        this.maxHarmonics = this.first.harmonics;
        this.minHarmonics = this.last.harmonics;
        this.mipHarmonics = new int[this.maxHarmonics - this.minHarmonics];
        for (i = this.minHarmonics; i < this.maxHarmonics; ++i) {
            int m;
            for (m = 0; i <= this.mipWaves[m].harmonics && m < this.size() - 1; ++m) {
            }
            this.mipHarmonics[i - this.minHarmonics] = m;
        }
    }

    public MipWave getMipMap(int index) {
        return this.mipWaves[index];
    }

    public int size() {
        return this.mipWaves.length;
    }

    public int getMipMapIndex(int harmonics) {
        if (harmonics >= this.maxHarmonics) {
            return 0;
        }
        if (harmonics <= this.minHarmonics) {
            return this.mipWaves.length - 1;
        }
        return this.mipHarmonics[harmonics - this.minHarmonics];
    }

    protected static final class MipWave {
        public final int harmonics;
        public final int size;
        public final int mask;
        public final int shift;
        public final int shiftMask;
        public final double frac;
        public final double[] wave;

        public MipWave(double[] wave) {
            this(wave, wave.length / 2);
        }

        public MipWave(double[] wave, int harmonics) {
            this.size = wave.length;
            this.mask = this.size - 1;
            this.harmonics = harmonics;
            this.wave = Arrays.copyOf(wave, this.size);
            this.shift = 28 - (int)NMath.log2(this.size);
            this.shiftMask = (1 << this.shift) - 1;
            this.frac = 1.0 / (double)(1 << this.shift);
        }

        public double get(int phase) {
            int p = phase >> this.shift;
            double f = (double)(phase & this.shiftMask) * this.frac;
            return CatmullRomSpline.get(this.wave[p - 1 & this.mask], this.wave[p & this.mask], this.wave[p + 1 & this.mask], this.wave[p + 2 & this.mask], f);
        }

        public MipWave half(double[] fir) {
            int nl = this.size >> 1;
            double[] out = new double[nl];
            for (int n = 0; n < nl; ++n) {
                int p = n * 2 - fir.length / 2 + 1;
                double sum = 0.0;
                for (int m = 0; m < fir.length; ++m) {
                    sum += fir[m] * this.wave[p + m & this.mask];
                }
                out[n] = sum;
            }
            return new MipWave(out, this.harmonics / 2);
        }
    }
}

