/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.collections;

import com.github.rjeschke.neetutils.collections.Tuple;

public class Pair<A extends Comparable<A>, B extends Comparable<B>>
extends Tuple<A, B>
implements Comparable<Pair<A, B>> {
    public Pair(A a, B b) {
        super(a, b);
        if (a == null) {
            throw new IllegalArgumentException("First value of Pair is null");
        }
        if (b == null) {
            throw new IllegalArgumentException("Second value of Pair is null");
        }
    }

    public static final <A extends Comparable<A>, B extends Comparable<B>> Pair<A, B> of(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    @Override
    public int hashCode() {
        return ((Comparable)this.a).hashCode() * 31 + ((Comparable)this.b).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair p = (Pair)obj;
        return ((Comparable)this.a).equals(p.a) && ((Comparable)this.b).equals(p.b);
    }

    @Override
    public int compareTo(Pair<A, B> o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        int t = ((Comparable)this.a).compareTo(o.a);
        return t != 0 ? t : ((Comparable)this.b).compareTo(o.b);
    }
}

