/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.concurrent;

import com.github.rjeschke.neetutils.SysUtils;
import com.github.rjeschke.neetutils.concurrent.RequeueWatcherCallback;
import java.util.concurrent.ConcurrentLinkedQueue;

class RequeueWatcher<A, B>
implements Runnable {
    private final RequeueWatcherCallback<A, B> callback;
    private final ConcurrentLinkedQueue<A> jobs;
    private final ConcurrentLinkedQueue<B> workers;
    private Thread thread;
    private final int delayMs = 100;
    private volatile boolean running = true;

    private RequeueWatcher(RequeueWatcherCallback<A, B> callback, ConcurrentLinkedQueue<A> jobs, ConcurrentLinkedQueue<B> workers) {
        this.callback = callback;
        this.jobs = jobs;
        this.workers = workers;
    }

    public static <A, B> RequeueWatcher<A, B> start(RequeueWatcherCallback<A, B> callback, ConcurrentLinkedQueue<A> jobs, ConcurrentLinkedQueue<B> workers) {
        RequeueWatcher<A, B> watcher = new RequeueWatcher<A, B>(callback, jobs, workers);
        watcher.thread = new Thread(watcher);
        watcher.thread.setDaemon(true);
        watcher.thread.start();
        return watcher;
    }

    public void stop() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.running) {
            long t0 = System.nanoTime();
            if (!this.jobs.isEmpty() && !this.workers.isEmpty()) {
                A job = this.jobs.poll();
                B worker = this.workers.poll();
                if (job != null && worker != null) {
                    this.callback.requeue(worker, job);
                } else {
                    if (job != null) {
                        this.jobs.offer(job);
                    }
                    if (worker != null) {
                        this.workers.offer(worker);
                    }
                }
            }
            long t1 = System.nanoTime();
            int ms = this.delayMs - (int)((t1 - t0) / 1000000L);
            SysUtils.fineSleep(Math.max(1, ms));
        }
    }
}

