/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.fn;

import com.github.rjeschke.neetutils.Objects;
import java.util.Collections;
import java.util.Iterator;

public abstract class Maybe<A>
implements Iterable<A> {
    public abstract boolean isNothing();

    public abstract Maybe<A> or(Maybe<A> var1);

    public static final <A> Maybe<A> nothing() {
        return new Nothing();
    }

    public static final <A> Maybe<A> just(A value) {
        return new Just<A>(value);
    }

    private static final class Just<A>
    extends Maybe<A> {
        private final A value;

        public Just(A value) {
            this.value = value;
        }

        @Override
        public Iterator<A> iterator() {
            return Collections.singleton(this.value).iterator();
        }

        @Override
        public boolean isNothing() {
            return false;
        }

        @Override
        public Maybe<A> or(Maybe<A> a) {
            return this;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Just)) {
                return false;
            }
            Just just = (Just)obj;
            return Objects.equals(this.value, just.value);
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "null";
        }
    }

    private static final class Nothing<A>
    extends Maybe<A> {
        @Override
        public Iterator<A> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public boolean isNothing() {
            return true;
        }

        @Override
        public Maybe<A> or(Maybe<A> a) {
            return a;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public String toString() {
            return "nothing";
        }
    }
}

