/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.fn;

import com.github.rjeschke.neetutils.fn.FnPredicate;

public final class Predicates {
    private Predicates() {
    }

    public static final <A> FnPredicate<A> isNull() {
        return new FnPredicate<A>(){

            @Override
            public boolean applyPredicate(A a) {
                return a == null;
            }
        };
    }

    public static final <A> FnPredicate<A> notNull() {
        return new FnPredicate<A>(){

            @Override
            public boolean applyPredicate(A a) {
                return a != null;
            }
        };
    }

    public static final <A> FnPredicate<A> not(final FnPredicate<? super A> predicate) {
        return new FnPredicate<A>(){

            @Override
            public boolean applyPredicate(A a) {
                return !predicate.applyPredicate(a);
            }
        };
    }

    public static final <A> FnPredicate<A> and(final FnPredicate<? super A> predicateA, final FnPredicate<? super A> predicateB) {
        return new FnPredicate<A>(){

            @Override
            public boolean applyPredicate(A a) {
                return predicateA.applyPredicate(a) && predicateB.applyPredicate(a);
            }
        };
    }

    public static final <A> FnPredicate<A> and(final FnPredicate<? super A> predicateA, final FnPredicate<? super A> predicateB, final FnPredicate<? super A> predicateC) {
        return new FnPredicate<A>(){

            @Override
            public boolean applyPredicate(A a) {
                return predicateA.applyPredicate(a) && predicateB.applyPredicate(a) && predicateC.applyPredicate(a);
            }
        };
    }

    public static final <A> FnPredicate<A> or(final FnPredicate<? super A> predicateA, final FnPredicate<? super A> predicateB) {
        return new FnPredicate<A>(){

            @Override
            public boolean applyPredicate(A a) {
                return predicateA.applyPredicate(a) || predicateB.applyPredicate(a);
            }
        };
    }

    public static final <A> FnPredicate<A> or(final FnPredicate<? super A> predicateA, final FnPredicate<? super A> predicateB, final FnPredicate<? super A> predicateC) {
        return new FnPredicate<A>(){

            @Override
            public boolean applyPredicate(A a) {
                return predicateA.applyPredicate(a) || predicateB.applyPredicate(a) || predicateC.applyPredicate(a);
            }
        };
    }
}

