/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.fn;

import com.github.rjeschke.neetutils.fn.FnFoldStep;
import com.github.rjeschke.neetutils.fn.FnMapping;
import com.github.rjeschke.neetutils.fn.FnPredicate;
import com.github.rjeschke.neetutils.iterables.Collector;
import java.util.Arrays;
import java.util.Iterator;

public final class StringFns {
    private StringFns() {
    }

    public static final FnPredicate<String> notEmpty() {
        return new FnPredicate<String>(){

            @Override
            public boolean applyPredicate(String a) {
                return a != null && a.length() > 0;
            }
        };
    }

    public static final FnPredicate<String> isEmpty() {
        return new FnPredicate<String>(){

            @Override
            public boolean applyPredicate(String a) {
                return a == null || a.length() < 1;
            }
        };
    }

    public static final Collector<Character, String> splitCollector(final char splitCharacter) {
        return new Collector<Character, String>(){

            @Override
            public void collect(Iterator<? extends Character> iterator) {
                if (iterator.hasNext()) {
                    char c;
                    StringBuilder sb = new StringBuilder();
                    while (iterator.hasNext() && (c = iterator.next().charValue()) != splitCharacter) {
                        sb.append(c);
                    }
                    this.emit(sb.toString());
                }
            }
        };
    }

    public static final FnMapping<String, String> toUpperCase() {
        return new FnMapping<String, String>(){

            @Override
            public String applyMapping(String value) {
                return value.toUpperCase();
            }
        };
    }

    public static final FnMapping<String, String> trim() {
        return new FnMapping<String, String>(){

            @Override
            public String applyMapping(String value) {
                return value.trim();
            }
        };
    }

    public static final <A> FnMapping<A, String> asString() {
        return new FnMapping<A, String>(){

            @Override
            public String applyMapping(A value) {
                return value.toString();
            }
        };
    }

    public static final FnMapping<String, String> toLowerCase() {
        return new FnMapping<String, String>(){

            @Override
            public String applyMapping(String value) {
                return value.toLowerCase();
            }
        };
    }

    public static final FnPredicate<String> endsWith(String ... strings) {
        final String[] needles = Arrays.copyOf(strings, strings.length);
        return new FnPredicate<String>(){

            @Override
            public boolean applyPredicate(String a) {
                if (needles.length == 0) {
                    return true;
                }
                for (int i = 0; i < needles.length; ++i) {
                    if (!a.endsWith(needles[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final FnPredicate<String> startsWith(String ... strings) {
        final String[] needles = Arrays.copyOf(strings, strings.length);
        return new FnPredicate<String>(){

            @Override
            public boolean applyPredicate(String a) {
                if (needles.length == 0) {
                    return true;
                }
                for (int i = 0; i < needles.length; ++i) {
                    if (!a.startsWith(needles[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final FnPredicate<String> endsWithIgnoreCase(String ... strings) {
        final String[] needles = Arrays.copyOf(strings, strings.length);
        for (int i = 0; i < needles.length; ++i) {
            needles[i] = needles[i].toLowerCase();
        }
        return new FnPredicate<String>(){

            @Override
            public boolean applyPredicate(String a) {
                if (needles.length == 0) {
                    return true;
                }
                for (int i = 0; i < needles.length; ++i) {
                    if (!a.toLowerCase().endsWith(needles[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final FnPredicate<String> startsWithIgnoreCase(String ... strings) {
        final String[] needles = Arrays.copyOf(strings, strings.length);
        for (int i = 0; i < needles.length; ++i) {
            needles[i] = needles[i].toLowerCase();
        }
        return new FnPredicate<String>(){

            @Override
            public boolean applyPredicate(String a) {
                if (needles.length == 0) {
                    return true;
                }
                for (int i = 0; i < needles.length; ++i) {
                    if (!a.toLowerCase().startsWith(needles[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final <A> FnFoldStep<A, StringBuilder> stringConcat() {
        return new FnFoldStep<A, StringBuilder>(){

            @Override
            public StringBuilder applyFoldStep(A a, StringBuilder b) {
                b.append(a);
                return b;
            }
        };
    }
}

