/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import com.github.rjeschke.neetutils.graphics.WrappedImage;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ImageFrame
implements WindowListener,
KeyListener {
    private final Frame frame;
    private final Canvas canvas;
    Image image = null;
    volatile boolean isClosed = false;

    public ImageFrame(String title, int width, int height, boolean resizable) {
        this.frame = new Frame(title);
        ImageCanvas c = new ImageCanvas();
        Dimension dim = new Dimension(width, height);
        c.setMinimumSize(dim);
        c.setMaximumSize(dim);
        c.setPreferredSize(dim);
        if (resizable) {
            ScrollPane pane = new ScrollPane(0);
            pane.add(c);
            this.frame.add(pane);
        } else {
            this.frame.add(c);
        }
        this.frame.pack();
        this.frame.setResizable(resizable);
        this.canvas = c;
        this.frame.addWindowListener(this);
        this.frame.addKeyListener(this);
        this.canvas.addKeyListener(this);
    }

    public ImageFrame(String title, int width, int height) {
        this(title, width, height, false);
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public static void display(String title, Image image) {
        ((ImageFrame)new ImageFrame(title, image.getWidth(null), image.getHeight(null)).setVisible(true)).setImage(image);
    }

    public static void display(String title, WrappedImage image) {
        ((ImageFrame)new ImageFrame(title, image.getWidth(), image.getHeight()).setVisible(true)).setImage(image);
    }

    public <T extends ImageFrame> T setVisible(boolean visible) {
        this.frame.setVisible(visible);
        return (T)this;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public <T extends ImageFrame> T setImage(Image image) {
        this.image = image;
        this.canvas.repaint();
        return (T)this;
    }

    public <T extends ImageFrame> T setImage(WrappedImage image) {
        this.image = image.getImage();
        this.canvas.repaint();
        return (T)this;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.isClosed = true;
        this.frame.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private class ImageCanvas
    extends Canvas {
        private static final long serialVersionUID = -4066767503350157062L;

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            Image img = ImageFrame.this.image;
            if (img != null) {
                g.drawImage(img, 0, 0, null);
            }
        }
    }
}

